/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.regionGrowing.Watershed3D;

public class Watershed_3D
implements PlugIn {
    ImagePlus seedPlus;
    ImageStack seedStack;
    ImagePlus spotPlus;
    ImageStack spotStack;
    double resXY = 0.1328;
    double resZ = 0.2;
    int seeds_threshold = 7000;
    int voxels_threshold = 0;
    int rad = 2;
    boolean anim = false;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.showMessage((String)"No image opened !");
            return;
        }
        String[] namesRaw = new String[nbima];
        String[] namesSeeds = new String[nbima + 1];
        namesSeeds[0] = "Automatic";
        for (int i = 0; i < nbima; ++i) {
            namesRaw[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesSeeds[i + 1] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        this.seeds_threshold = (int)Prefs.get((String)"Watershed3D_SeedsThreshold.int", (double)this.seeds_threshold);
        this.voxels_threshold = (int)Prefs.get((String)"Watershed3D_VoxelsThreshold.int", (double)this.voxels_threshold);
        int spot = 0;
        int seed = nbima > 1 ? nbima - 1 : 0;
        GenericDialog dia = new GenericDialog("Seeds Watershed");
        dia.addNumericField("Seeds_Threshold", (double)this.seeds_threshold, 0);
        dia.addNumericField("Image_Threshold", (double)this.voxels_threshold, 0);
        dia.addChoice("Image", namesRaw, namesRaw[spot]);
        dia.addChoice("Seeds", namesSeeds, namesSeeds[seed]);
        dia.addNumericField("Radius for automatic seeds", (double)this.rad, 0);
        dia.addCheckbox("Show animation (slow)", this.anim);
        dia.showDialog();
        if (dia.wasOKed()) {
            this.seeds_threshold = (int)dia.getNextNumber();
            this.voxels_threshold = (int)dia.getNextNumber();
            spot = dia.getNextChoiceIndex();
            seed = dia.getNextChoiceIndex();
            this.rad = (int)dia.getNextNumber();
            this.anim = dia.getNextBoolean();
            Prefs.set((String)"Watershed3D_SeedsThreshold.int", (int)this.seeds_threshold);
            Prefs.set((String)"Watershed3D_VoxelsThreshold.int", (int)this.voxels_threshold);
            this.spotPlus = WindowManager.getImage((int)(spot + 1));
            this.spotStack = this.spotPlus.getImageStack();
            if (seed > 0) {
                this.seedPlus = WindowManager.getImage((int)seed);
                this.seedStack = this.seedPlus.getImageStack();
            } else {
                IJ.log((String)"Computing seeds as local maxima");
                this.seedStack = this.spotStack.getBitDepth() < 32 ? FastFilters3D.filterIntImageStack((ImageStack)this.spotStack, (int)4, (float)this.rad, (float)this.rad, (float)this.rad, (int)0, (boolean)true) : FastFilters3D.filterFloatImageStack((ImageStack)this.spotStack, (int)4, (float)this.rad, (float)this.rad, (float)this.rad, (int)0, (boolean)true);
            }
            this.Watershed();
        }
    }

    private void Watershed() {
        IJ.log((String)"Computing watershed");
        long t = System.currentTimeMillis();
        Watershed3D water = new Watershed3D(this.spotStack, this.seedStack, (double)this.voxels_threshold, this.seeds_threshold);
        water.setLabelSeeds(true);
        water.setAnim(this.anim);
        water.getWatershedImage3D().show();
        IJ.log((String)("Finished in " + (System.currentTimeMillis() - t) + " ms."));
    }
}

