/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.GaussianBlur3D;
import ij.plugin.PlugIn;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.regionGrowing.Watershed3D;

public class Watershed_Split3D
implements PlugIn {
    ImagePlus seedPlus = null;
    ImageStack seedStack = null;
    ImagePlus binaryMask;
    ImageStack binaryStack;
    float rad = 2.0f;
    boolean anim = false;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.showMessage((String)"No image opened !");
            return;
        }
        String[] namesRaw = new String[nbima];
        String[] namesSeeds = new String[nbima + 1];
        namesSeeds[0] = "Automatic";
        for (int i = 0; i < nbima; ++i) {
            namesRaw[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesSeeds[i + 1] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        int mask = 0;
        int seed = nbima > 1 ? nbima - 1 : 0;
        GenericDialog dia = new GenericDialog("Watershed split");
        dia.addChoice("Binary mask", namesRaw, namesRaw[mask]);
        dia.addChoice("Seeds", namesSeeds, namesSeeds[seed]);
        dia.addNumericField("Radius (pixel)", (double)this.rad, 0);
        dia.showDialog();
        if (dia.wasOKed()) {
            mask = dia.getNextChoiceIndex();
            seed = dia.getNextChoiceIndex();
            this.rad = (float)dia.getNextNumber();
            this.binaryMask = WindowManager.getImage((int)(mask + 1));
            this.binaryStack = this.binaryMask.getImageStack();
            if (seed > 0) {
                this.seedPlus = WindowManager.getImage((int)seed);
                this.seedStack = this.seedPlus.getImageStack();
            }
            this.WatershedSplit();
        }
    }

    private void WatershedSplit() {
        ImageInt seedsImg;
        IJ.log((String)"");
        long t = System.currentTimeMillis();
        float resXY = 1.0f;
        float resZ = 1.0f;
        float radXY = this.rad;
        float radZ = this.rad;
        Calibration cal = this.binaryMask.getCalibration();
        if (cal != null) {
            resXY = (float)cal.pixelWidth;
            resZ = (float)cal.pixelDepth;
            radZ = radXY * (resXY / resZ);
        }
        IJ.log((String)"Computing EDT");
        ImageInt imgMask = ImageInt.wrap((ImagePlus)this.binaryMask);
        ImageFloat edt = EDT.run((ImageHandler)imgMask, (float)0.0f, (float)resXY, (float)resZ, (boolean)false, (int)0);
        ImageShort edt16 = edt.convertToShort(true);
        IJ.log((String)"Smoothing EDT");
        ImagePlus edt16Plus = edt16.getImagePlus();
        GaussianBlur3D.blur((ImagePlus)edt16Plus, (double)2.0, (double)2.0, (double)2.0);
        edt16 = ImageInt.wrap((ImagePlus)edt16Plus);
        edt16.intersectMask(imgMask);
        edt16.show("EDT");
        if (this.seedPlus == null) {
            IJ.log((String)"computing seeds as max local of EDT");
            seedsImg = FastFilters3D.filterImage((ImageHandler)edt16, (int)4, (float)radXY, (float)radXY, (float)radZ, (int)0, (boolean)false);
        } else {
            seedsImg = ImageInt.wrap((ImagePlus)this.seedPlus);
        }
        IJ.log((String)"Computing watershed");
        Watershed3D water = new Watershed3D((ImageHandler)edt16, (ImageHandler)seedsImg, 0.0, 0);
        water.setLabelSeeds(true);
        water.setAnim(this.anim);
        water.getWatershedImage3D().show("Split");
        IJ.log((String)("Finished in " + (System.currentTimeMillis() - t) + " ms."));
    }
}

