/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.regionGrowing.Watershed3DVoronoi;

public class Watershed_Voronoi3D
implements PlugIn {
    ImagePlus seedPlus = null;
    float radMax = 0.0f;
    boolean showLines = false;
    boolean showEDT = false;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.showMessage((String)"No image opened !");
            return;
        }
        this.seedPlus = WindowManager.getCurrentImage();
        if (this.Dialog()) {
            this.WatershedVoronoi();
        }
    }

    private void WatershedVoronoi() {
        IJ.log((String)"");
        long t = System.currentTimeMillis();
        ImageHandler image = ImageHandler.wrap((ImagePlus)this.seedPlus);
        Watershed3DVoronoi watershed3DVoronoi = new Watershed3DVoronoi(image, this.radMax);
        watershed3DVoronoi.getVoronoiZones(this.showEDT).show("VoronoiZones");
        if (this.showLines) {
            watershed3DVoronoi.getVoronoiLines(true).show("VoronoiLines");
        }
        IJ.log((String)("Finished in " + (System.currentTimeMillis() - t) + " ms."));
    }

    private boolean Dialog() {
        Calibration calibration = this.seedPlus.getCalibration();
        String unit = "pixel";
        if (calibration != null) {
            unit = calibration.getUnits();
        }
        GenericDialog genericDialog = new GenericDialog("Voronoi");
        genericDialog.addNumericField("Radius_Max (0 for no max)", (double)this.radMax, 2, 10, unit);
        genericDialog.addCheckbox("Show_EDT", this.showEDT);
        genericDialog.addCheckbox("Show_Lines", this.showLines);
        genericDialog.showDialog();
        this.radMax = (float)genericDialog.getNextNumber();
        if (this.radMax == 0.0f) {
            this.radMax = Float.MAX_VALUE;
        }
        this.showEDT = genericDialog.getNextBoolean();
        this.showLines = genericDialog.getNextBoolean();
        return genericDialog.wasOKed();
    }
}

