/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.analysis;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.Duplicator;
import ij.process.StackConverter;

public class GLCMTexture {
    public boolean verbose = false;
    int step = 1;
    int dir = 0;
    ImagePlus imp;
    double[][] glcm;

    public GLCMTexture(ImagePlus imp2, int dir, int step) {
        if (imp2.getBitDepth() != 8) {
            if (this.verbose) {
                IJ.log((String)"converting to 8-bits");
            }
            Duplicator dup = new Duplicator();
            this.imp = dup.run(imp2);
            StackConverter sc = new StackConverter(this.imp);
            sc.convertToGray8();
        } else {
            this.imp = imp2;
        }
        this.dir = dir;
        this.step = step;
        this.computeMatrix();
    }

    private void computeMatrix() {
        int a;
        ImageStack ip = this.imp.getStack();
        double pixelCounter = 0.0;
        this.glcm = new double[256][256];
        for (int z = this.step; z < ip.getSize() - this.step; ++z) {
            for (int y = this.step; y < ip.getHeight() - this.step; ++y) {
                for (int x = this.step; x < ip.getWidth() - this.step; ++x) {
                    int b2;
                    int b1;
                    switch (this.dir) {
                        case 0: {
                            b1 = (int)ip.getVoxel(x + this.step, y, z);
                            b2 = (int)ip.getVoxel(x - this.step, y, z);
                            break;
                        }
                        case 1: {
                            b1 = (int)ip.getVoxel(x, y + this.step, z);
                            b2 = (int)ip.getVoxel(x, y - this.step, z);
                            break;
                        }
                        case 2: {
                            b1 = (int)ip.getVoxel(x, y, z + this.step);
                            b2 = (int)ip.getVoxel(x, y, z - this.step);
                            break;
                        }
                        default: {
                            b1 = 0;
                            b2 = 0;
                        }
                    }
                    a = (int)ip.getVoxel(x, y, z);
                    double[] dArray = this.glcm[a];
                    int n = b1;
                    dArray[n] = dArray[n] + 1.0;
                    double[] dArray2 = this.glcm[b1];
                    int n2 = a;
                    dArray2[n2] = dArray2[n2] + 1.0;
                    double[] dArray3 = this.glcm[a];
                    int n3 = b2;
                    dArray3[n3] = dArray3[n3] + 1.0;
                    double[] dArray4 = this.glcm[b2];
                    int n4 = a;
                    dArray4[n4] = dArray4[n4] + 1.0;
                    pixelCounter += 4.0;
                }
            }
        }
        for (a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                this.glcm[a][b] = this.glcm[a][b] / pixelCounter;
            }
        }
    }

    public double getASM() {
        double asm = 0.0;
        for (int a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                asm += this.glcm[a][b] * this.glcm[a][b];
            }
        }
        return asm;
    }

    public double getContrast() {
        double contrast = 0.0;
        for (int a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                contrast += (double)((a - b) * (a - b)) * this.glcm[a][b];
            }
        }
        return contrast;
    }

    public double getCorrelation() {
        int b;
        int a;
        double correlation = 0.0;
        double px = 0.0;
        double py = 0.0;
        double meanx = 0.0;
        double meany = 0.0;
        double stdevx = 0.0;
        double stdevy = 0.0;
        for (a = 0; a < 256; ++a) {
            for (b = 0; b < 256; ++b) {
                px += (double)a * this.glcm[a][b];
                py += (double)b * this.glcm[a][b];
            }
        }
        for (a = 0; a < 256; ++a) {
            for (b = 0; b < 256; ++b) {
                stdevx += ((double)a - px) * ((double)a - px) * this.glcm[a][b];
                stdevy += ((double)b - py) * ((double)b - py) * this.glcm[a][b];
            }
        }
        for (a = 0; a < 256; ++a) {
            for (b = 0; b < 256; ++b) {
                correlation += ((double)a - px) * ((double)b - py) * this.glcm[a][b] / (stdevx * stdevy);
            }
        }
        return correlation;
    }

    public double getIDM() {
        double IDM = 0.0;
        for (int a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                IDM += this.glcm[a][b] / (double)(1 + (a - b) * (a - b));
            }
        }
        return IDM;
    }

    public double getEntropy() {
        double entropy = 0.0;
        for (int a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                if (this.glcm[a][b] == 0.0) continue;
                entropy -= this.glcm[a][b] * Math.log(this.glcm[a][b]);
            }
        }
        return entropy;
    }

    public double getSum() {
        double suma = 0.0;
        for (int a = 0; a < 256; ++a) {
            for (int b = 0; b < 256; ++b) {
                suma += this.glcm[a][b];
            }
        }
        return suma;
    }
}

