/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.analysis;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.ResultsTable;
import ij.plugin.Duplicator;
import java.util.List;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom2.Objects3DIntPopulation;
import mcib3d.geom2.measurements.MeasureCentroid;
import mcib3d.geom2.measurements.MeasureCompactness;
import mcib3d.geom2.measurements.MeasureDistancesCenter;
import mcib3d.geom2.measurements.MeasureEllipsoid;
import mcib3d.geom2.measurements.MeasureFeret;
import mcib3d.geom2.measurements.MeasureIntensity;
import mcib3d.geom2.measurements.MeasureIntensityHist;
import mcib3d.geom2.measurements.MeasureSurface;
import mcib3d.geom2.measurements.MeasureVolume;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;

public class SimpleMeasure {
    public static final String CENTROID = "Centroid";
    public static final String DISTCENTER = "DistCenter";
    public static final String ELLIPSOID = "Ellipsoid";
    public static final String FERET = "Feret";
    public static final String SHAPE = "Shape";
    public static final String SURFACE = "Surface";
    public static final String VOLUME = "Volume";
    Objects3DIntPopulation population;
    ImageHandler input;
    ImagePlus inputPlus;

    public SimpleMeasure(ImagePlus in) {
        this.inputPlus = in;
        this.input = ImageHandler.wrap((ImagePlus)this.inputPlus);
        if (this.input.isBinary(0)) {
            IJ.log((String)"Labelling image.");
            ImageLabeller label = new ImageLabeller();
            this.input = label.getLabels(this.input);
        }
        IJ.log((String)"Computing population ...");
        this.population = new Objects3DIntPopulation(this.input);
    }

    public static ImagePlus extractCurrentStack(ImagePlus plus) {
        ImagePlus stack;
        int[] dims = plus.getDimensions();
        int channel = plus.getChannel();
        int frame = plus.getFrame();
        if (dims[2] > 1 || dims[4] > 1) {
            IJ.log((String)("Hyperstack found, extracting current channel " + channel + " and frame " + frame));
            Duplicator duplicator = new Duplicator();
            stack = duplicator.run(plus, channel, channel, 1, dims[3], frame, frame);
            stack.setTitle(plus.getTitle() + "-C" + channel + "-T" + frame);
        } else {
            stack = plus.duplicate();
        }
        stack.setTitle(plus.getTitle());
        return stack;
    }

    public List<Double[]> getMeasuresCentroid() {
        return this.population.getMeasurementsList(new MeasureCentroid().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresVolume() {
        return this.population.getMeasurementsList(new MeasureVolume().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresSurface() {
        return this.population.getMeasurementsList(new MeasureSurface().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresStats(ImageHandler raw) {
        return this.population.getMeasurementsIntensityList(new MeasureIntensity().getNamesMeasurement(), raw);
    }

    public List<Double[]> getMeasuresStatsHist(ImageHandler raw) {
        return this.population.getMeasurementsIntensityList(new MeasureIntensityHist().getNamesMeasurement(), raw);
    }

    public List<Double[]> getMeasuresStats(ImagePlus myPlus) {
        IJ.log((String)("Computing measurements for " + this.population.getNbObjects() + " objects ..."));
        return this.getMeasuresStats(ImageHandler.wrap((ImagePlus)myPlus));
    }

    public List<Double[]> getMeasuresStatsHist(ImagePlus myPlus) {
        IJ.log((String)("Computing measurements for " + this.population.getNbObjects() + " objects ..."));
        return this.getMeasuresStatsHist(ImageHandler.wrap((ImagePlus)myPlus));
    }

    public List<Double[]> getMeasuresCompactness() {
        return this.population.getMeasurementsList(new MeasureCompactness().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresEllipsoid() {
        return this.population.getMeasurementsList(new MeasureEllipsoid().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresDistanceCentreContour() {
        return this.population.getMeasurementsList(new MeasureDistancesCenter().getNamesMeasurement());
    }

    public List<Double[]> getMeasuresFeret() {
        return this.population.getMeasurementsList(new MeasureFeret().getNamesMeasurement());
    }

    @Deprecated
    public List<Double[]> getMeshSurfaces() {
        Objects3DPopulation pop = new Objects3DPopulation(this.input);
        return pop.getMeasuresMesh();
    }

    public ResultsTable getResultsTable(String measure) {
        IJ.log((String)("Computing measurements for " + this.population.getNbObjects() + " objects ..."));
        switch (measure) {
            case "Centroid": {
                return this.getResultsTable(this.getMeasuresCentroid(), new MeasureCentroid().getNamesMeasurement());
            }
            case "DistCenter": {
                return this.getResultsTable(this.getMeasuresDistanceCentreContour(), new MeasureDistancesCenter().getNamesMeasurement());
            }
            case "Ellipsoid": {
                return this.getResultsTable(this.getMeasuresEllipsoid(), new MeasureEllipsoid().getNamesMeasurement());
            }
            case "Feret": {
                return this.getResultsTable(this.getMeasuresFeret(), new MeasureFeret().getNamesMeasurement());
            }
            case "Shape": {
                return this.getResultsTable(this.getMeasuresCompactness(), new MeasureCompactness().getNamesMeasurement());
            }
            case "Volume": {
                return this.getResultsTable(this.getMeasuresVolume(), new MeasureVolume().getNamesMeasurement());
            }
            case "Surface": {
                return this.getResultsTable(this.getMeasuresSurface(), new MeasureSurface().getNamesMeasurement());
            }
        }
        return null;
    }

    private ResultsTable getResultsTable(List<Double[]> res, String[] namesMeasurements) {
        String title = this.inputPlus.getTitle();
        int channel = this.inputPlus.getChannel();
        int frame = this.inputPlus.getFrame();
        int nbCT = this.inputPlus.getNChannels() * this.inputPlus.getNFrames();
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null) {
            rt = new ResultsTable();
        }
        int row = rt.getCounter();
        for (Double[] re : res) {
            rt.incrementCounter();
            for (int k = 0; k < namesMeasurements.length; ++k) {
                if (re[k] == null) {
                    rt.setValue(namesMeasurements[k], row, Double.NaN);
                    continue;
                }
                rt.setValue(namesMeasurements[k], row, re[k].doubleValue());
            }
            rt.setLabel(title, row);
            if (nbCT > 1) {
                rt.setValue("Channel", row, (double)channel);
                rt.setValue("Frame", row, (double)frame);
            }
            ++row;
        }
        rt.sort("LabelObj");
        rt.updateResults();
        return rt;
    }
}

