/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.analysis;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.measure.Calibration;
import ij.plugin.Selection;
import java.awt.Color;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DLabel;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Point3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.CDFTools;
import mcib3d.utils.ThreadUtil;

public class SpatialAnalysis {
    private final int numEvaluationPoints;
    private final int numRandomSamples;
    private final double distHardCore;
    private final double env;
    ImageHandler randomPop;
    int nbBins = 1000;
    int nbCpus = 1;
    private double sdi_F = Double.NaN;
    private double sdi_G = Double.NaN;
    private double sdi_H = Double.NaN;
    private Color ColorAVG = Color.red;
    private Color ColorENV = Color.green;
    private Color ColorOBS = Color.blue;

    public SpatialAnalysis(int numPoints, int numRandomSamples, double distHardCore, double env) {
        this.numEvaluationPoints = numPoints;
        this.numRandomSamples = numRandomSamples;
        this.distHardCore = distHardCore;
        this.env = env;
    }

    public static void createMask(ImagePlus plus) {
        WindowManager.setTempCurrentImage((ImagePlus)plus);
        Selection DrawMask = new Selection();
        DrawMask.run("mask");
    }

    public void setMultiThread(int nb) {
        this.nbCpus = nb;
    }

    public boolean process(ImagePlus plusSpots, ImagePlus plusMask, String functions, boolean verbose, boolean show, boolean save) {
        return this.process((ImageHandler)ImageInt.wrap((ImagePlus)plusSpots), (ImageHandler)ImageInt.wrap((ImagePlus)plusMask), functions, verbose, show, save);
    }

    public void processAll(ImageHandler plusSpots, ImageHandler plusMask, boolean verbose, boolean show, boolean save) {
        this.process(plusSpots, plusMask, "FGH", verbose, show, save);
    }

    public void processAll(ImagePlus plusSpots, ImagePlus plusMask, boolean verbose, boolean show, boolean save) {
        this.process(plusSpots, plusMask, "FGH", verbose, show, save);
    }

    @Deprecated
    private void processFMonoThread(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        ArrayUtil distances;
        Objects3DPopulation poprandom;
        int i;
        Calibration calibration = mask.getCalibration();
        int nbspots = pop.getNbObjects();
        Point3D[] evaluationPoints = this.createEvaluationPoints(this.numEvaluationPoints, pop);
        ArrayUtil observedDistancesF = pop.computeDistances(evaluationPoints);
        observedDistancesF.sort();
        ArrayUtil observedCDF = CDFTools.cdf((ArrayUtil)observedDistancesF);
        ArrayUtil xEvalsF = new ArrayUtil(this.numRandomSamples * this.numEvaluationPoints);
        ArrayUtil[] sampleDistancesF = new ArrayUtil[this.numRandomSamples];
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population F " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            poprandom.createKDTreeCenters();
            distances = poprandom.computeDistances(evaluationPoints);
            distances.sort();
            sampleDistancesF[i] = distances;
            xEvalsF.insertValues(i * this.numEvaluationPoints, distances);
        }
        xEvalsF.sort();
        ArrayUtil averageCDF = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesF, (ArrayUtil)xEvalsF);
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population F " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            poprandom.createKDTreeCenters();
            distances = poprandom.computeDistances(evaluationPoints);
            distances.sort();
            sampleDistancesF[i] = distances;
        }
        if (show || save) {
            PlotWindow plotW;
            Plot plotF = this.createPlot(xEvalsF, sampleDistancesF, observedDistancesF, observedCDF, averageCDF, "F");
            plotF.draw();
            if (save && (plotW = plotF.show()) != null) {
                try {
                    plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-F.csv");
                }
                catch (IOException ex) {
                    Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        IJ.log((String)"--- F Function ---");
        this.sdi_F = CDFTools.SDI((ArrayUtil)observedDistancesF, (ArrayUtil[])sampleDistancesF, (ArrayUtil)averageCDF, (ArrayUtil)xEvalsF);
        IJ.log((String)("SDI F=" + this.sdi_F));
    }

    private void processF(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        int iThread;
        double sxy = mask.getResXY();
        double sz = mask.getResZ();
        String unit = mask.getUnits();
        int nbSpots = pop.getNbObjects();
        Point3D[] evaluationPoints = this.createEvaluationPoints(this.numEvaluationPoints, pop);
        ArrayUtil observedDistancesF = pop.computeDistances(evaluationPoints);
        observedDistancesF.sort();
        ArrayUtil observedCDF = CDFTools.cdf((ArrayUtil)observedDistancesF);
        ArrayUtil xEvalF = new ArrayUtil(this.numRandomSamples * this.numEvaluationPoints);
        ArrayUtil[] sampleDistancesF = new ArrayUtil[this.numRandomSamples];
        Object3D mask2 = mask;
        AtomicInteger ai = new AtomicInteger(0);
        int nCpu = this.nbCpus == 0 ? ThreadUtil.getNbCpus() : this.nbCpus;
        Thread[] threads = ThreadUtil.createThreadArray((int)nCpu);
        int dec = (int)Math.ceil((double)this.numRandomSamples / (double)nCpu);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population F " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation popRandom = new Objects3DPopulation();
                        popRandom.setCalibration(sxy, sz, unit);
                        popRandom.setMask(mask2);
                        popRandom.createRandomPopulation(nbSpots, this.distHardCore);
                        popRandom.createKDTreeCenters();
                        ArrayUtil distances2 = popRandom.computeDistances(evaluationPoints);
                        distances2.sort();
                        sampleDistancesF[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        for (int i = 0; i < this.numRandomSamples; ++i) {
            xEvalF.insertValues(i * this.numEvaluationPoints, sampleDistancesF[i]);
        }
        xEvalF.sort();
        ArrayUtil averageCDF = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesF, (ArrayUtil)xEvalF);
        ai.set(0);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population F " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation poprandom = new Objects3DPopulation();
                        poprandom.setCalibration(sxy, sz, unit);
                        poprandom.setMask(mask2);
                        poprandom.createRandomPopulation(nbSpots, this.distHardCore);
                        poprandom.createKDTreeCenters();
                        ArrayUtil distances2 = poprandom.computeDistances(evaluationPoints);
                        distances2.sort();
                        sampleDistancesF[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        if (show || save) {
            PlotWindow plotW;
            Plot plotF = this.createPlot(xEvalF, sampleDistancesF, observedDistancesF, observedCDF, averageCDF, "F");
            plotF.draw();
            if (save && (plotW = plotF.show()) != null) {
                try {
                    plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-F.csv");
                }
                catch (IOException ex) {
                    Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        IJ.log((String)"--- F Function ---");
        this.sdi_F = CDFTools.SDI((ArrayUtil)observedDistancesF, (ArrayUtil[])sampleDistancesF, (ArrayUtil)averageCDF, (ArrayUtil)xEvalF);
        IJ.log((String)("SDI F=" + this.sdi_F));
    }

    @Deprecated
    private void processGMonoThread(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        PlotWindow plotW;
        ArrayUtil distances;
        Objects3DPopulation poprandom;
        int i;
        Calibration calibration = mask.getCalibration();
        int nbspots = pop.getNbObjects();
        ArrayUtil observedDistancesG = pop.distancesAllClosestCenter();
        observedDistancesG.sort();
        ArrayUtil observedCDG = CDFTools.cdf((ArrayUtil)observedDistancesG);
        ArrayUtil xEvalsG = new ArrayUtil(this.numRandomSamples * nbspots);
        ArrayUtil[] sampleDistancesG = new ArrayUtil[this.numRandomSamples];
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population G " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            distances = poprandom.distancesAllClosestCenter();
            distances.sort();
            sampleDistancesG[i] = distances;
            xEvalsG.insertValues(i * nbspots, distances);
        }
        xEvalsG.sort();
        ArrayUtil averageCDG = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesG, (ArrayUtil)xEvalsG);
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population G " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            poprandom.createKDTreeCenters();
            distances = poprandom.distancesAllClosestCenter();
            distances.sort();
            sampleDistancesG[i] = distances;
        }
        Plot plotG = null;
        if (show || save) {
            plotG = this.createPlot(xEvalsG, sampleDistancesG, observedDistancesG, observedCDG, averageCDG, "G");
        }
        if (show) {
            plotG.draw();
        }
        if (save && (plotW = plotG.show()) != null) {
            try {
                plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-G.csv");
            }
            catch (IOException ex) {
                Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        IJ.log((String)"--- G Function ---");
        this.sdi_G = CDFTools.SDI((ArrayUtil)observedDistancesG, (ArrayUtil[])sampleDistancesG, (ArrayUtil)averageCDG, (ArrayUtil)xEvalsG);
        IJ.log((String)("SDI G=" + this.sdi_G));
    }

    private void processG(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        PlotWindow plotW;
        int iThread;
        double sxy = mask.getResXY();
        double sz = mask.getResZ();
        String unit = mask.getUnits();
        int nbSpots = pop.getNbObjects();
        ArrayUtil observedDistancesG = pop.distancesAllClosestCenter();
        observedDistancesG.sort();
        ArrayUtil observedCDG = CDFTools.cdf((ArrayUtil)observedDistancesG);
        ArrayUtil xEvalG = new ArrayUtil(this.numRandomSamples * nbSpots);
        ArrayUtil[] sampleDistancesG = new ArrayUtil[this.numRandomSamples];
        Object3D mask2 = mask;
        AtomicInteger ai = new AtomicInteger(0);
        int nCpu = this.nbCpus == 0 ? ThreadUtil.getNbCpus() : this.nbCpus;
        Thread[] threads = ThreadUtil.createThreadArray((int)nCpu);
        int dec = (int)Math.ceil((double)this.numRandomSamples / (double)nCpu);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population G " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation popRandom = new Objects3DPopulation();
                        popRandom.setCalibration(sxy, sz, unit);
                        popRandom.setMask(mask2);
                        popRandom.createRandomPopulation(nbSpots, this.distHardCore);
                        ArrayUtil distances2 = popRandom.distancesAllClosestCenter();
                        distances2.sort();
                        sampleDistancesG[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        for (int i = 0; i < this.numRandomSamples; ++i) {
            xEvalG.insertValues(i * nbSpots, sampleDistancesG[i]);
        }
        xEvalG.sort();
        ArrayUtil averageCDG = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesG, (ArrayUtil)xEvalG);
        ai.set(0);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population G " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation popRandom = new Objects3DPopulation();
                        popRandom.setCalibration(sxy, sz, unit);
                        popRandom.setMask(mask2);
                        popRandom.createRandomPopulation(nbSpots, this.distHardCore);
                        ArrayUtil distances2 = popRandom.distancesAllClosestCenter();
                        distances2.sort();
                        sampleDistancesG[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        Plot plotG = null;
        if (show || save) {
            plotG = this.createPlot(xEvalG, sampleDistancesG, observedDistancesG, observedCDG, averageCDG, "G");
        }
        if (show) {
            plotG.draw();
        }
        if (save && (plotW = plotG.show()) != null) {
            try {
                plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-G.csv");
            }
            catch (IOException ex) {
                Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        IJ.log((String)"--- G Function ---");
        this.sdi_G = CDFTools.SDI((ArrayUtil)observedDistancesG, (ArrayUtil[])sampleDistancesG, (ArrayUtil)averageCDG, (ArrayUtil)xEvalG);
        IJ.log((String)("SDI G=" + this.sdi_G));
    }

    @Deprecated
    private void processHMonoThread(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        PlotWindow plotW;
        ArrayUtil distances;
        Objects3DPopulation poprandom;
        int i;
        Calibration calibration = mask.getCalibration();
        int nbspots = pop.getNbObjects();
        ArrayUtil observedDistancesH = pop.distancesAllCenter();
        observedDistancesH.sort();
        ArrayUtil observedCDH = CDFTools.cdf((ArrayUtil)observedDistancesH);
        ArrayUtil xEvalsH = new ArrayUtil(this.numRandomSamples * nbspots);
        ArrayUtil[] sampleDistancesH = new ArrayUtil[this.numRandomSamples];
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population H " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            distances = poprandom.distancesAllCenter();
            distances.sort();
            sampleDistancesH[i] = distances;
            xEvalsH.insertValues(i * nbspots, distances);
        }
        xEvalsH.sort();
        ArrayUtil averageCDH = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesH, (ArrayUtil)xEvalsH);
        for (i = 0; i < this.numRandomSamples; ++i) {
            if (verbose) {
                IJ.showStatus((String)("Random population H " + (i + 1)));
            }
            poprandom = new Objects3DPopulation();
            poprandom.setCalibration(calibration);
            poprandom.setMask(mask);
            poprandom.createRandomPopulation(nbspots, this.distHardCore);
            distances = poprandom.distancesAllCenter();
            distances.sort();
            sampleDistancesH[i] = distances;
        }
        Plot plotH = null;
        if (show || save) {
            plotH = this.createPlot(xEvalsH, sampleDistancesH, observedDistancesH, observedCDH, averageCDH, "H");
        }
        if (show) {
            plotH.draw();
        }
        if (save && (plotW = plotH.show()) != null) {
            try {
                plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-H.csv");
            }
            catch (IOException ex) {
                Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        IJ.log((String)"--- H Function ---");
        this.sdi_H = CDFTools.SDI((ArrayUtil)observedDistancesH, (ArrayUtil[])sampleDistancesH, (ArrayUtil)averageCDH, (ArrayUtil)xEvalsH);
        IJ.log((String)("SDI H=" + this.sdi_H));
    }

    private void processH(Objects3DPopulation pop, Object3D mask, boolean verbose, boolean show, boolean save) {
        PlotWindow plotW;
        int iThread;
        double sxy = mask.getResXY();
        double sz = mask.getResZ();
        String unit = mask.getUnits();
        int nbSpots = pop.getNbObjects();
        ArrayUtil observedDistancesH = pop.distancesAllCenter();
        observedDistancesH.sort();
        ArrayUtil observedCDH = CDFTools.cdf((ArrayUtil)observedDistancesH);
        ArrayUtil xEvalH = new ArrayUtil(this.numRandomSamples * nbSpots);
        ArrayUtil[] sampleDistancesH = new ArrayUtil[this.numRandomSamples];
        Object3D mask2 = mask;
        AtomicInteger ai = new AtomicInteger(0);
        int nCpu = this.nbCpus == 0 ? ThreadUtil.getNbCpus() : this.nbCpus;
        Thread[] threads = ThreadUtil.createThreadArray((int)nCpu);
        int dec = (int)Math.ceil((double)this.numRandomSamples / (double)nCpu);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population H " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation popRandom = new Objects3DPopulation();
                        popRandom.setCalibration(sxy, sz, unit);
                        popRandom.setMask(mask2);
                        popRandom.createRandomPopulation(nbSpots, this.distHardCore);
                        ArrayUtil distances2 = popRandom.distancesAllCenter();
                        distances2.sort();
                        sampleDistancesH[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        for (int i = 0; i < this.numRandomSamples; ++i) {
            xEvalH.insertValues(i * nbSpots, sampleDistancesH[i]);
        }
        xEvalH.sort();
        ArrayUtil averageCDH = CDFTools.cdfAverage((ArrayUtil[])sampleDistancesH, (ArrayUtil)xEvalH);
        ai.set(0);
        for (iThread = 0; iThread < threads.length; ++iThread) {
            threads[iThread] = new Thread(() -> {
                int k = ai.getAndIncrement();
                while (k < nCpu) {
                    for (int i = dec * k; i < dec * (k + 1) && i < this.numRandomSamples; ++i) {
                        if (verbose) {
                            IJ.showStatus((String)("Random population H " + (i + 1) + " by processor " + (k + 1)));
                        }
                        Objects3DPopulation popRandom = new Objects3DPopulation();
                        popRandom.setCalibration(sxy, sz, unit);
                        popRandom.setMask(mask2);
                        popRandom.createRandomPopulation(nbSpots, this.distHardCore);
                        ArrayUtil distances2 = popRandom.distancesAllCenter();
                        distances2.sort();
                        sampleDistancesH[i] = distances2;
                    }
                    k = ai.getAndIncrement();
                }
            });
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        Plot plotH = null;
        if (show || save) {
            plotH = this.createPlot(xEvalH, sampleDistancesH, observedDistancesH, observedCDH, averageCDH, "H");
        }
        if (show) {
            plotH.draw();
        }
        if (save && (plotW = plotH.show()) != null) {
            try {
                plotW.getResultsTable().saveAs(IJ.getDirectory((String)"home") + "StatsPlot-H.csv");
            }
            catch (IOException ex) {
                Logger.getLogger(SpatialAnalysis.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        IJ.log((String)"--- H Function ---");
        this.sdi_H = CDFTools.SDI((ArrayUtil)observedDistancesH, (ArrayUtil[])sampleDistancesH, (ArrayUtil)averageCDH, (ArrayUtil)xEvalH);
        IJ.log((String)("SDI H=" + this.sdi_H));
    }

    private Plot createPlot(ArrayUtil xEvals, ArrayUtil[] sampleDistances, ArrayUtil observedDistances, ArrayUtil observedCD, ArrayUtil averageCD, String function) {
        double plotMaxX = observedDistances.getMaximum();
        double plotMaxY = observedCD.getMaximum();
        double max = xEvals.getMaximum();
        ArrayUtil xEval0 = new ArrayUtil(this.nbBins);
        for (int i = 0; i < this.nbBins; ++i) {
            xEval0.addValue(i, (double)i * max / (double)this.nbBins);
        }
        ArrayUtil samplesPc5 = CDFTools.cdfPercentage((ArrayUtil[])sampleDistances, (ArrayUtil)xEval0, (double)(this.env / 2.0));
        ArrayUtil samplesPc95 = CDFTools.cdfPercentage((ArrayUtil[])sampleDistances, (ArrayUtil)xEval0, (double)(1.0 - this.env / 2.0));
        if (xEval0.getMaximum() > plotMaxX) {
            plotMaxX = xEval0.getMaximum();
        }
        if (samplesPc5.getMaximum() > plotMaxY) {
            plotMaxY = samplesPc5.getMaximum();
        }
        if (samplesPc95.getMaximum() > plotMaxY) {
            plotMaxY = samplesPc95.getMaximum();
        }
        if (xEvals.getMaximum() > plotMaxX) {
            plotMaxX = xEvals.getMaximum();
        }
        if (averageCD.getMaximum() > plotMaxY) {
            plotMaxY = averageCD.getMaximum();
        }
        if (observedCD.getMaximum() > plotMaxY) {
            plotMaxY = observedCD.getMaximum();
        }
        if (observedDistances.getMaximum() > plotMaxX) {
            plotMaxX = observedDistances.getMaximum();
        }
        Plot plot = new Plot(function + "-function", "distance", "cumulated frequency");
        plot.setLimits(0.0, plotMaxX, 0.0, plotMaxY);
        plot.setColor(this.ColorENV);
        plot.addPoints(xEval0.getArray(), samplesPc5.getArray(), 2);
        plot.setColor(this.ColorENV);
        plot.addPoints(xEval0.getArray(), samplesPc95.getArray(), 2);
        plot.setColor(this.ColorAVG);
        plot.addPoints(xEvals.getArray(), averageCD.getArray(), 2);
        plot.setColor(this.ColorOBS);
        plot.addPoints(observedDistances.getArray(), observedCD.getArray(), 2);
        return plot;
    }

    public boolean process(ImageHandler plusSpots, ImageHandler plusMask, String functions, boolean verbose, boolean show, boolean save) {
        ImageInt segImage;
        double scaleXY = plusMask.getVoxelSizeXY();
        double scaleZ = plusMask.getVoxelSizeZ();
        String unit = plusMask.getUnit();
        ImageInt inImage = (ImageInt)plusSpots;
        if (inImage.isBinary(0)) {
            if (verbose) {
                IJ.log((String)"Segmenting image...");
            }
            inImage = inImage.threshold(0.0f, false, true);
            ImageLabeller labels = new ImageLabeller(false);
            segImage = labels.getLabels((ImageHandler)inImage);
            if (labels.getNbObjectsTotal((ImageHandler)inImage) < 2) {
                IJ.log((String)"Not enough objects detected. Please check parameters and input images.");
                return false;
            }
            if (verbose) {
                segImage.show("Labelled Image");
            }
        } else {
            segImage = inImage.duplicate();
        }
        segImage.setScale(plusSpots);
        Objects3DPopulation pop = new Objects3DPopulation();
        ImageInt maskHandler = (ImageInt)plusMask;
        Object3DLabel mask = new Object3DLabel(maskHandler, (int)maskHandler.getMax());
        mask.setCalibration(scaleXY, scaleZ, unit);
        pop.setMask((Object3D)mask);
        pop.addImage((ImageHandler)segImage, 0);
        pop.setCalibration(scaleXY, scaleZ, unit);
        int nbSpots = pop.getNbObjects();
        Objects3DPopulation popRandom = new Objects3DPopulation();
        popRandom.setCalibration(scaleXY, scaleZ, unit);
        popRandom.setMask((Object3D)mask);
        boolean test = popRandom.createRandomPopulation(nbSpots, this.distHardCore);
        if (!test) {
            IJ.log((String)"Could not create random population. Aborting.");
            return false;
        }
        this.randomPop = segImage.createSameDimensions();
        popRandom.draw(this.randomPop);
        if (verbose) {
            IJ.log((String)"Computing spatial statistics, please wait ...");
        }
        if (verbose) {
            IJ.log((String)("Nb Spot=" + nbSpots));
            IJ.log((String)("Volume mask=" + mask.getVolumeUnit()));
            IJ.log((String)("Density=" + (double)nbSpots / mask.getVolumeUnit()));
        }
        if (functions.contains("F")) {
            this.processF(pop, (Object3D)mask, verbose, show, save);
        }
        if (functions.contains("G")) {
            this.processG(pop, (Object3D)mask, verbose, show, save);
        }
        if (functions.contains("H")) {
            this.processH(pop, (Object3D)mask, verbose, show, save);
        }
        return true;
    }

    public double getSdi_F() {
        return this.sdi_F;
    }

    public double getSdi_G() {
        return this.sdi_G;
    }

    public double getSdi_H() {
        return this.sdi_H;
    }

    public ImageHandler getRandomSample() {
        return this.randomPop;
    }

    private Point3D[] createEvaluationPoints(int numPoints, Objects3DPopulation population) {
        Point3D[] evaluationPoints = new Point3D[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            evaluationPoints[i] = population.getRandomPointInMask();
        }
        return evaluationPoints;
    }

    public void setColorsPlot(Color avg, Color env, Color obs) {
        this.ColorAVG = avg;
        this.ColorENV = env;
        this.ColorOBS = obs;
    }
}

