/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.segmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import mcib3d.image3d.processing.ManualSpot;

public class Manual_Spot
implements PlugIn {
    public void run(String arg) {
        ImagePlus labelImage;
        ImagePlus signalImage;
        int nbima = WindowManager.getImageCount();
        if (nbima == 0) {
            IJ.log((String)"Image required :");
            return;
        }
        if (nbima < 2) {
            signalImage = IJ.getImage();
            Calibration cal = signalImage.getCalibration();
            labelImage = IJ.createImage((String)"labels", (int)signalImage.getWidth(), (int)signalImage.getHeight(), (int)signalImage.getStackSize(), (int)16);
            if (cal != null) {
                labelImage.setCalibration(cal);
            }
            labelImage.show();
        }
        nbima = WindowManager.getImageCount();
        String[] names = new String[nbima];
        for (int i = 0; i < nbima; ++i) {
            names[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        int signal = 0;
        int label = 1;
        GenericDialog dia = new GenericDialog("Seeds spots");
        dia.addChoice("Spots_Signal", names, names[signal]);
        dia.addChoice("Spots_Label", names, names[label]);
        dia.showDialog();
        signal = dia.getNextChoiceIndex();
        label = dia.getNextChoiceIndex();
        signalImage = WindowManager.getImage((int)(signal + 1));
        labelImage = WindowManager.getImage((int)(label + 1));
        if (label < nbima) {
            labelImage = WindowManager.getImage((int)(label + 1));
        }
        new ManualSpot(signalImage, labelImage).setVisible(true);
    }
}

