/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.tools;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Object3D_IJUtils;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.image3d.ImageHandler;

public class Draw_RoiSlices
implements PlugIn {
    ImagePlus segPlus;
    ImagePlus rawPlus = null;
    int currentZmin;
    int currentZmax;
    Roi[] arrayRois;
    Objects3DPopulation objects3D;

    public void run(String arg) {
        int nbima = WindowManager.getImageCount();
        if (nbima < 1) {
            IJ.showMessage((String)"No image opened !");
            return;
        }
        String[] namesRaw = new String[nbima + 1];
        String[] namesSeg = new String[nbima];
        namesRaw[0] = "None";
        for (int i = 0; i < nbima; ++i) {
            namesRaw[i + 1] = WindowManager.getImage((int)(i + 1)).getShortTitle();
            namesSeg[i] = WindowManager.getImage((int)(i + 1)).getShortTitle();
        }
        int seg = 0;
        int raw = nbima > 1 ? nbima - 1 : 0;
        boolean label3D = false;
        GenericDialog dia = new GenericDialog("Draw Roi 3D");
        dia.addChoice("Raw", namesRaw, namesRaw[raw]);
        dia.addChoice("Seg", namesSeg, namesSeg[seg]);
        dia.addCheckbox("Display 3D labelled Roi", label3D);
        dia.showDialog();
        if (dia.wasOKed()) {
            raw = dia.getNextChoiceIndex();
            seg = dia.getNextChoiceIndex();
            label3D = dia.getNextBoolean();
            this.segPlus = WindowManager.getImage((int)(seg + 1));
            if (raw > 0) {
                this.rawPlus = WindowManager.getImage((int)raw);
            }
            this.objects3D = new Objects3DPopulation(ImageHandler.wrap((ImagePlus)this.segPlus));
            if (label3D) {
                ObjectCreator3D draw = new ObjectCreator3D(this.segPlus.getWidth(), this.segPlus.getHeight(), this.segPlus.getNSlices());
                for (int o = 0; o < this.objects3D.getNbObjects(); ++o) {
                    Object3DVoxels obj = (Object3DVoxels)this.objects3D.getObject(o);
                    obj.computeContours();
                    int col = obj.getValue();
                    if (this.segPlus.getNSlices() > 1) {
                        obj.drawContours(draw, col);
                        continue;
                    }
                    obj.drawContoursXY(draw, 0, col);
                }
                draw.getImageHandler().show("LabelRoi");
            }
            this.computeRois();
            if (this.rawPlus == null) {
                this.drawRoisNew().show();
            } else {
                this.drawRois().show();
            }
        }
    }

    private ImagePlus drawRoisNew() {
        ColorProcessor processor;
        int z;
        ImageStack stack = new ImageStack(this.segPlus.getWidth(), this.segPlus.getHeight());
        for (int z2 = 0; z2 < this.currentZmin; ++z2) {
            ColorProcessor processor2 = new ColorProcessor(this.segPlus.getWidth(), this.segPlus.getHeight());
            stack.addSlice((ImageProcessor)processor2);
        }
        Color col = Toolbar.getForegroundColor();
        for (z = this.currentZmin; z <= this.currentZmax; ++z) {
            processor = new ColorProcessor(this.segPlus.getWidth(), this.segPlus.getHeight());
            processor.setColor(col);
            Roi roi = this.arrayRois[z];
            roi.drawPixels((ImageProcessor)processor);
            stack.addSlice((ImageProcessor)processor);
        }
        for (z = this.currentZmax + 1; z < this.segPlus.getNSlices(); ++z) {
            processor = new ColorProcessor(this.segPlus.getWidth(), this.segPlus.getHeight());
            stack.addSlice((ImageProcessor)processor);
        }
        return new ImagePlus("drawRoi3D", stack);
    }

    private ImagePlus drawRois() {
        this.rawPlus.deleteRoi();
        Duplicator duplicator = new Duplicator();
        ImagePlus rawCopy = duplicator.run(this.rawPlus);
        ImageConverter converter = new ImageConverter(rawCopy);
        converter.convertToRGB();
        Color col = Toolbar.getForegroundColor();
        ImageStack stack = rawCopy.getImageStack();
        for (int z = this.currentZmin; z < this.currentZmax; ++z) {
            ImageProcessor processor = stack.getProcessor(z + 1);
            processor.setColor(col);
            Roi roi = this.arrayRois[z];
            if (roi == null) continue;
            roi.drawPixels(processor);
        }
        return rawCopy;
    }

    void computeRois() {
        Object3D obj;
        this.arrayRois = new Roi[this.segPlus.getNSlices()];
        int zmin = this.segPlus.getNSlices() + 1;
        int zmax = -1;
        for (int i = 0; i < this.objects3D.getNbObjects(); ++i) {
            obj = this.objects3D.getObject(i);
            if (obj.getZmin() < zmin) {
                zmin = obj.getZmin();
            }
            if (obj.getZmax() <= zmax) continue;
            zmax = obj.getZmax();
        }
        this.currentZmin = zmin;
        this.currentZmax = zmax;
        for (int zz = zmin; zz <= zmax; ++zz) {
            ByteProcessor mask = new ByteProcessor(this.segPlus.getWidth(), this.segPlus.getHeight());
            boolean ok = false;
            for (int i = 0; i < this.objects3D.getNbObjects(); ++i) {
                obj = this.objects3D.getObject(i);
                ok |= Object3D_IJUtils.draw((Object3D)obj, (ByteProcessor)mask, (int)zz, (int)255);
            }
            if (!ok) {
                this.arrayRois[zz] = null;
                continue;
            }
            mask.setThreshold(1.0, 255.0, 2);
            ImagePlus maskPlus = new ImagePlus("mask " + zz, (ImageProcessor)mask);
            ThresholdToSelection tts = new ThresholdToSelection();
            tts.setup("", maskPlus);
            tts.run((ImageProcessor)mask);
            this.arrayRois[zz] = maskPlus.getRoi();
        }
    }
}

