/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.tools;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MessageDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.macro.ExtensionDescriptor;
import ij.macro.Functions;
import ij.macro.MacroExtension;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij3d.Content;
import ij3d.ContentCreator;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.ImageJ_3D_Viewer;
import ij3d.UniverseListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Scrollbar;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Object3D_IJUtils;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.ObjectsPopulationDistances;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.segment.Segment3DSpotsOld;
import mcib3d.utils.AboutMCIB;
import mcib3d.utils.CheckInstall;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.IJLog;
import mcib_plugins.tools.Manager3DMeasurements;
import mcib_plugins.tools.ResultsFrame;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;

public class RoiManager3D_2
extends JFrame
implements PlugIn,
MouseWheelListener,
AdjustmentListener,
MacroExtension,
UniverseListener,
DropTargetListener,
WindowListener {
    private static final String version = AboutMCIB.getVERSION();
    private static RoiManager3D_2 manager3d = null;
    public JPanel jPanel;
    public JList list;
    protected Objects3DPopulation objects3DPopulation = null;
    protected DefaultListModel objectsModel = new DefaultListModel();
    boolean canceled;
    boolean live = true;
    ImageByte label = null;
    private HashMap<String, Integer> hashNames;
    private ImagePlus currentImage;
    private Roi[] arrayRois = null;
    private ResultsFrame tableResultsMeasure = null;
    private ResultsFrame tableResultsQuantif = null;
    private ResultsFrame tableResultsColoc = null;
    private ResultsFrame tableResultsDistance = null;
    private ResultsFrame tableResultsVoxels = null;
    private boolean multi = false;
    private Image3DUniverse universe = null;
    private final boolean showUniverse = true;
    private int currentZmin = 0;
    private int currentZmax = 0;
    private JButton button3Dviewer;
    private JButton buttonAbout;
    private JButton buttonAddImage;
    private JButton buttonAngles;
    private JButton buttonColoc;
    private JButton buttonConfig;
    private JButton buttonDelete;
    private JButton buttonDeselect;
    private JButton buttonDistances;
    private JButton buttonErase;
    private JButton buttonFillStack;
    private JButton buttonLabel;
    private JButton buttonListVoxels;
    private JButton buttonLiveRoi;
    private JButton buttonLoad;
    private JButton buttonMeasure;
    private JButton buttonMerge;
    private JButton buttonQuantif;
    private JButton buttonRename;
    private JButton buttonSave;
    private JButton buttonSegmentation3D;
    private JButton buttonSelectAll;
    private JButton buttonSplit;
    private JScrollPane jScrollPane;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;

    public static void main(String[] args) {
        block6: {
            try {
                if (!Prefs.get((String)"RoiManager3D-Options_UseUI.boolean", (boolean)false)) break block6;
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean multiple = Prefs.get((String)"RoiManager3D-Options_UseMultiple.boolean", (boolean)false);
                if (manager3d == null || multiple) {
                    if (manager3d == null) {
                        IJ.log((String)"First instance of 3D Manager");
                    }
                    if (multiple) {
                        IJ.log((String)"Multiple instances of 3D Manager allowed, check options");
                    }
                    manager3d = new RoiManager3D_2();
                    manager3d.setVisible(true);
                }
                Functions.registerExtensions((MacroExtension)manager3d);
            }
        });
    }

    public void create3DManager() {
        if (!CheckInstall.installComplete()) {
            IJ.log((String)"Not starting RoiManager3D");
            return;
        }
        IJ.log((String)"Starting RoiManager3D");
        this.initComponents();
        this.setTitle("RoiManager3D " + version);
        this.setVisible(true);
        this.objects3DPopulation = new Objects3DPopulation();
        this.objects3DPopulation.setLog((AbstractLog)new IJLog());
        this.list.setModel(this.objectsModel);
        this.hashNames = new HashMap();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        if (IJ.macroRunning()) {
            Functions.registerExtensions((MacroExtension)this);
            this.setLiveMode(false);
        }
        this.setLiveMode(false);
        if (Recorder.record) {
            // empty if block
        }
        this.getUniverse();
        this.universe.addUniverseListener((UniverseListener)this);
        new DropTarget(this.list, 3, this);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                int[] indices;
                String key = String.valueOf(ke.getKeyChar());
                if (!(key.equalsIgnoreCase("0") || key.equalsIgnoreCase("1") || key.equalsIgnoreCase("2") || key.equalsIgnoreCase("3") || key.equalsIgnoreCase("4") || key.equalsIgnoreCase("5") || key.equalsIgnoreCase("6") || key.equalsIgnoreCase("7") || key.equalsIgnoreCase("8") || key.equalsIgnoreCase("9"))) {
                    return;
                }
                for (int i : indices = RoiManager3D_2.this.list.getSelectedIndices()) {
                    RoiManager3D_2.this.objects3DPopulation.getObject(i).setType(Integer.parseInt(key));
                    RoiManager3D_2.this.objects3DPopulation.getObject(i).setComment("");
                    RoiManager3D_2.this.updateName(i);
                }
                RoiManager3D_2.this.list.updateUI();
            }
        });
        WindowManager.addWindow((Frame)this);
        WindowManager.setWindow((Frame)this);
        this.setMinimumSize(new Dimension(500, 500));
        this.setPreferredSize(new Dimension(500, 500));
        this.setResizable(true);
    }

    public ExtensionDescriptor[] getExtensionFunctions() {
        int[] argSeg = new int[]{2, 2};
        int[] argCol = new int[]{2, 2, 2};
        int[] argViewer = new int[]{2, 2, 2, 2};
        int[] argSel = new int[]{2};
        int[] argName = new int[]{2, 17};
        int[] argRename = new int[]{1};
        int[] argSaveResult = new int[]{1, 1};
        int[] argCount = new int[]{18};
        int[] argDist2 = new int[]{2, 2, 1, 18};
        int[] argColoc = new int[]{2, 2, 18, 18, 18};
        int[] argMeasure3D = new int[]{2, 1, 18};
        int[] argCentroid3D = new int[]{2, 18, 18, 18};
        int[] argBorder3D = new int[]{2, 2, 2, 18, 18, 18};
        int[] argBounding3D = new int[]{2, 18, 18, 18, 18, 18, 18};
        int[] argClosestK = new int[]{2, 2, 1, 18};
        int[] argString = new int[]{17};
        ExtensionDescriptor[] extensions = new ExtensionDescriptor[]{ExtensionDescriptor.newDescriptor((String)"Manager3D_Close", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_AddImage", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_LiveRoi", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Delete", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Reset", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Erase", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Rename", (MacroExtension)this, (int[])argRename), ExtensionDescriptor.newDescriptor((String)"Manager3D_Merge", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_FillStack", (MacroExtension)this, (int[])argCol), ExtensionDescriptor.newDescriptor((String)"Manager3D_FillStack2", (MacroExtension)this, (int[])argViewer), ExtensionDescriptor.newDescriptor((String)"Manager3D_Fill3DViewer", (MacroExtension)this, (int[])argCol), ExtensionDescriptor.newDescriptor((String)"Manager3D_Fill3DViewer2", (MacroExtension)this, (int[])argViewer), ExtensionDescriptor.newDescriptor((String)"Manager3D_Split", (MacroExtension)this, (int[])argCount), ExtensionDescriptor.newDescriptor((String)"Manager3D_Measure", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_List", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Quantif", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Distance", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Coloc", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Angle", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Select", (MacroExtension)this, (int[])argSel), ExtensionDescriptor.newDescriptor((String)"Manager3D_SelectAll", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_GetName", (MacroExtension)this, (int[])argName), ExtensionDescriptor.newDescriptor((String)"Manager3D_SelectFor", (MacroExtension)this, (int[])argCol), ExtensionDescriptor.newDescriptor((String)"Manager3D_MultiSelect", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_MonoSelect", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_DeselectAll", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_GetSelected", (MacroExtension)this, (int[])argString), ExtensionDescriptor.newDescriptor((String)"Manager3D_Count", (MacroExtension)this, (int[])argCount), ExtensionDescriptor.newDescriptor((String)"Manager3D_Segment", (MacroExtension)this, (int[])argSeg), ExtensionDescriptor.newDescriptor((String)"Manager3D_ShowRoi", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Dist2", (MacroExtension)this, (int[])argDist2), ExtensionDescriptor.newDescriptor((String)"Manager3D_Coloc2", (MacroExtension)this, (int[])argColoc), ExtensionDescriptor.newDescriptor((String)"Manager3D_Measure3D", (MacroExtension)this, (int[])argMeasure3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_Quantif3D", (MacroExtension)this, (int[])argMeasure3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_RadiusBorderVoxel", (MacroExtension)this, (int[])argBorder3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_Centroid3D", (MacroExtension)this, (int[])argCentroid3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_MassCenter3D", (MacroExtension)this, (int[])argCentroid3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_Label", (MacroExtension)this), ExtensionDescriptor.newDescriptor((String)"Manager3D_Load", (MacroExtension)this, (int[])argRename), ExtensionDescriptor.newDescriptor((String)"Manager3D_Save", (MacroExtension)this, (int[])argRename), ExtensionDescriptor.newDescriptor((String)"Manager3D_Bounding3D", (MacroExtension)this, (int[])argBounding3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_Closest", (MacroExtension)this, (int[])argMeasure3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_ClosestK", (MacroExtension)this, (int[])argClosestK), ExtensionDescriptor.newDescriptor((String)"Manager3D_Feret1", (MacroExtension)this, (int[])argCentroid3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_Feret2", (MacroExtension)this, (int[])argCentroid3D), ExtensionDescriptor.newDescriptor((String)"Manager3D_BorderVoxel", (MacroExtension)this, (int[])argColoc), ExtensionDescriptor.newDescriptor((String)"Manager3D_CloseResult", (MacroExtension)this, (int[])argRename), ExtensionDescriptor.newDescriptor((String)"Manager3D_SaveResult", (MacroExtension)this, (int[])argSaveResult), ExtensionDescriptor.newDescriptor((String)"Manager3D_Rotate", (MacroExtension)this, (int[])argCol), ExtensionDescriptor.newDescriptor((String)"Manager3D_LoadView3D", (MacroExtension)this, (int[])argRename)};
        return extensions;
    }

    public String handleExtension(String name, Object[] args) {
        if (name.equals("Manager3D_Close")) {
            this.dispose();
        } else if (name.equals("Manager3D_AddImage")) {
            this.addImage();
        } else if (name.equals("Manager3D_Delete")) {
            this.delete(false);
        } else if (name.equals("Manager3D_LiveRoi")) {
            this.setLiveMode(!this.live);
        } else if (name.equals("Manager3D_Reset")) {
            this.reset();
        } else if (name.equals("Manager3D_Erase")) {
            this.delete(true);
        } else if (name.equals("Manager3D_Rename")) {
            String S = (String)args[0];
            this.rename(S);
        } else if (name.equals("Manager3D_FillStack")) {
            Double D = (Double)args[0];
            int a = D.intValue();
            D = (Double)args[1];
            int b = D.intValue();
            D = (Double)args[2];
            int c = D.intValue();
            this.fill3D(a, b, c);
        } else if (name.equals("Manager3D_FillStack2")) {
            Double D = (Double)args[0];
            int obj = D.intValue();
            D = (Double)args[1];
            int r = D.intValue();
            D = (Double)args[2];
            int g = D.intValue();
            D = (Double)args[3];
            int b = D.intValue();
            this.fill3D(obj, r, g, b);
        } else if (name.equals("Manager3D_Fill3DViewer")) {
            Double D = (Double)args[0];
            int r = D.intValue();
            D = (Double)args[1];
            int g = D.intValue();
            D = (Double)args[2];
            int b = D.intValue();
            this.fill3DViewer(r, g, b);
        } else if (name.equals("Manager3D_Fill3DViewer2")) {
            Double D = (Double)args[0];
            int obj = D.intValue();
            D = (Double)args[1];
            int r = D.intValue();
            D = (Double)args[2];
            int g = D.intValue();
            D = (Double)args[3];
            int b = D.intValue();
            this.fill3DViewer(obj, r, g, b);
        } else if (name.equals("Manager3D_Split")) {
            ((Double[])args[0])[0] = this.split() ? Double.valueOf(1.0) : Double.valueOf(0.0);
        } else if (name.equals("Manager3D_Merge")) {
            this.merge();
        } else if (name.equals("Manager3D_Measure")) {
            this.measure3D();
        } else if (name.equals("Manager3D_Quantif")) {
            this.quantif3D();
        } else if (name.equals("Manager3D_List")) {
            this.listVoxels();
        } else if (name.equals("Manager3D_Label")) {
            this.label();
        } else if (name.equals("Manager3D_Distance")) {
            this.distance();
        } else if (name.equals("Manager3D_Coloc")) {
            this.coloc();
        } else if (name.equals("Manager3D_Angle")) {
            this.angle();
        } else if (name.equals("Manager3D_Segment")) {
            Double D = (Double)args[0];
            int a = D.intValue();
            D = (Double)args[1];
            int b = D.intValue();
            this.segmentation3D(a, b);
        } else if (name.equals("Manager3D_Select")) {
            Double D = (Double)args[0];
            int a = D.intValue();
            this.selectMacroMode(a);
        } else if (name.equals("Manager3D_SelectAll")) {
            this.selectAll();
        } else if (name.equals("Manager3D_GetName")) {
            Double D = (Double)args[0];
            int a = D.intValue();
            ((String[])args[1])[0] = (String)this.objectsModel.get(a);
        } else if (name.equals("Manager3D_SelectFor")) {
            Double D = (Double)args[0];
            int a = D.intValue();
            D = (Double)args[1];
            int b = D.intValue();
            D = (Double)args[2];
            int c = D.intValue();
            this.selectFor(a, b, c);
        } else if (name.equals("Manager3D_DeselectAll")) {
            this.deselect();
        } else if (name.equals("Manager3D_MultiSelect")) {
            this.multi = true;
        } else if (name.equals("Manager3D_MonoSelect")) {
            this.multi = false;
        } else if (name.equals("Manager3D_GetSelected")) {
            int[] idx = this.list.getSelectedIndices();
            if (idx.length > 0) {
                String res = String.valueOf(idx[0]);
                for (int i = 1; i < idx.length; ++i) {
                    res = res.concat(":" + idx[i]);
                }
                ((String[])args[0])[0] = res;
            } else {
                ((String[])args[0])[0] = "NA";
            }
        } else if (!name.equals("Manager3D_3DViewerSelect")) {
            if (name.equals("Manager3D_Count")) {
                ((Double[])args[0])[0] = this.objectsModel.getSize();
            } else if (name.equals("Manager3D_Dist2")) {
                this.handleDistance(args);
            } else if (name.equals("Manager3D_Coloc2")) {
                this.handleColoc(args);
            } else if (name.equals("Manager3D_ShowRoi")) {
                if (this.arrayRois == null) {
                    this.computeRois();
                }
                this.updateRois();
            } else if (name.equals("Manager3D_Measure3D")) {
                this.handleMeasure3D(args);
            } else if (name.equals("Manager3D_Quantif3D")) {
                this.handleQuantif3D(args);
            } else if (name.equals("Manager3D_Centroid3D")) {
                this.handleCentroid3D(args);
            } else if (name.equals("Manager3D_MassCenter3D")) {
                this.handleMassCentroid3D(args);
            } else if (name.equals("Manager3D_RadiusBorderVoxel")) {
                this.handleRadiusBorderVoxel(args);
            } else if (name.equals("Manager3D_Bounding3D")) {
                this.handleBounding3D(args);
            } else if (name.equals("Manager3D_Load")) {
                String S = (String)args[0];
                this.loadObjects(S);
            } else if (name.equals("Manager3D_Save")) {
                String S = (String)args[0];
                this.saveObjects(S);
            } else if (name.equals("Manager3D_SaveMeasure")) {
                String S = (String)args[0];
                this.saveResult("M", S);
            } else if (name.equals("Manager3D_SaveQuantif")) {
                String S = (String)args[0];
                this.saveResult("Q", S);
            } else if (name.equals("Manager3D_Closest")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                String s = (String)args[1];
                double res = this.closestObject(a, s);
                ((Double[])args[2])[0] = res;
            } else if (name.equals("Manager3D_ClosestK")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                D = (Double)args[1];
                int k = D.intValue();
                String s = (String)args[2];
                double res = this.kClosestObject(a, k, s);
                ((Double[])args[3])[0] = res;
            } else if (name.equals("Manager3D_Feret1")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                Object3D ob = this.objects3DPopulation.getObject(a);
                Voxel3D vox = ob.getFeretVoxel1();
                ((Double[])args[1])[0] = vox.getX();
                ((Double[])args[2])[0] = vox.getY();
                ((Double[])args[3])[0] = vox.getZ();
            } else if (name.equals("Manager3D_Feret2")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                Object3D ob = this.objects3DPopulation.getObject(a);
                Voxel3D vox = ob.getFeretVoxel2();
                ((Double[])args[1])[0] = vox.getX();
                ((Double[])args[2])[0] = vox.getY();
                ((Double[])args[3])[0] = vox.getZ();
            } else if (name.equals("Manager3D_BorderVoxel")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                Object3D ob1 = this.objects3DPopulation.getObject(a);
                D = (Double)args[1];
                a = D.intValue();
                Object3D ob2 = this.objects3DPopulation.getObject(a);
                Voxel3D vox = ob1.VoxelsBorderBorder(ob2)[0];
                ((Double[])args[2])[0] = vox.getX();
                ((Double[])args[3])[0] = vox.getY();
                ((Double[])args[4])[0] = vox.getZ();
            } else if (name.equals("Manager3D_Rotate")) {
                Double D = (Double)args[0];
                int a = D.intValue();
                D = (Double)args[1];
                int b = D.intValue();
                D = (Double)args[2];
                int c = D.intValue();
                this.rotateUniverse(a, b, c);
            } else if (name.equals("Manager3D_LoadView3D")) {
                String S = (String)args[0];
                this.loadView3D(S);
            } else if (name.equals("Manager3D_CloseResult")) {
                String S = (String)args[0];
                this.closeResult(S);
            } else if (name.equals("Manager3D_SaveResult")) {
                String S = (String)args[0];
                String file = (String)args[1];
                this.saveResult(S, file);
            }
        }
        return null;
    }

    public void closing() {
        if (this.currentImage != null) {
            this.removeScrollListener(this.currentImage, this, this);
            this.currentImage.killRoi();
            this.currentImage.updateAndDraw();
            this.currentImage = null;
        }
        WindowManager.removeWindow((Frame)this);
        this.objects3DPopulation = null;
        manager3d = null;
        this.dispose();
    }

    void reset() {
        int count = this.objectsModel.getSize();
        if (count > 0) {
            this.objectsModel.removeAllElements();
            this.objects3DPopulation = new Objects3DPopulation();
        }
        this.list.updateUI();
        if (this.universe != null) {
            this.universe.removeAllContents();
        }
    }

    private void selectMacroMode(int index) {
        if (this.multi) {
            if (this.list.isSelectedIndex(index)) {
                this.list.removeSelectionInterval(index, index);
            } else {
                this.list.addSelectionInterval(index, index);
            }
        } else {
            this.list.clearSelection();
            this.list.setSelectedIndex(index);
        }
        this.list.updateUI();
    }

    public void selectFor(int start, int end, int step) {
        this.list.clearSelection();
        for (int i = start; i < end; i += step) {
            this.list.addSelectionInterval(i, i);
        }
        this.list.updateUI();
    }

    private void handleDistance(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int b = D.intValue();
        String par = (String)args[2];
        double[] res = new double[1];
        this.distance(a, b, par, res);
        ((Double[])args[3])[0] = res[0];
    }

    private void distance(int i, int j, String par, double[] dist) {
        dist[0] = -1.0;
        if (i < 0 || i >= this.objects3DPopulation.getNbObjects()) {
            return;
        }
        Object3D ob1 = this.objects3DPopulation.getObject(i);
        if (j < 0 || j >= this.objects3DPopulation.getNbObjects()) {
            return;
        }
        Object3D ob2 = this.objects3DPopulation.getObject(j);
        if (par.equalsIgnoreCase("cc")) {
            dist[0] = ob1.distCenterUnit(ob2);
        } else if (par.equalsIgnoreCase("bb")) {
            dist[0] = ob1.distBorderUnit(ob2);
        } else if (par.equalsIgnoreCase("c1b2")) {
            dist[0] = ob1.distCenterBorderUnit(ob2);
        } else if (par.equalsIgnoreCase("c2b1")) {
            dist[0] = ob2.distCenterBorderUnit(ob1);
        } else if (par.equalsIgnoreCase("r1c2")) {
            dist[0] = ob1.radiusCenter(ob2);
        } else if (par.equalsIgnoreCase("r2c1")) {
            dist[0] = ob2.radiusCenter(ob1);
        } else if (par.equalsIgnoreCase("ex2c1")) {
            dist[0] = ob1.distCenterUnit(ob2) / ob1.radiusCenter(ob2);
        } else if (par.equalsIgnoreCase("ex1c2")) {
            dist[0] = ob2.distCenterUnit(ob1) / ob2.radiusCenter(ob1);
        } else if (par.equalsIgnoreCase("-r1c2")) {
            dist[0] = ob1.radiusCenter(ob2, true);
        } else if (par.equalsIgnoreCase("-r2c1")) {
            dist[0] = ob2.radiusCenter(ob1, true);
        }
    }

    private void handleColoc(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        D = (Double)args[1];
        int b = D.intValue();
        double[] res = new double[3];
        this.coloc(a, b, res);
        ((Double[])args[2])[0] = res[0];
        ((Double[])args[3])[0] = res[1];
        ((Double[])args[4])[0] = res[2];
    }

    private void coloc(int i, int j, double[] coloc) {
        coloc[0] = -1.0;
        coloc[1] = -1.0;
        coloc[2] = -1.0;
        if (i < 0 || i >= this.objects3DPopulation.getNbObjects()) {
            return;
        }
        Object3D ob1 = this.objects3DPopulation.getObject(i);
        if (j < 0 || j >= this.objects3DPopulation.getNbObjects()) {
            return;
        }
        Object3D ob2 = this.objects3DPopulation.getObject(j);
        coloc[0] = ob1.pcColoc(ob2);
        coloc[1] = ob2.pcColoc(ob1);
        boolean sc = Prefs.get((String)"RoiManager3D-Options_SurfContact.boolean", (boolean)true);
        int[] surfc = new int[]{0, 0};
        if (sc) {
            surfc = ob1.surfaceContact(ob2, Prefs.get((String)"RoiManager3D-Options_surfDist.double", (double)1.0));
        }
        coloc[2] = surfc[0] + surfc[1];
    }

    private void handleMeasure3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        String s = (String)args[1];
        double res = this.measure3D(a, s);
        ((Double[])args[2])[0] = res;
    }

    private double measure3D(int i, String par) {
        double res = Double.NaN;
        if (i < 0 || i >= this.objects3DPopulation.getNbObjects()) {
            return res;
        }
        Object3D obj = this.objects3DPopulation.getObject(i);
        if (par.equalsIgnoreCase("Vol")) {
            res = obj.getVolumeUnit();
        } else if (par.equalsIgnoreCase("NbVox")) {
            res = obj.getVolumePixels();
        } else if (par.equalsIgnoreCase("Surf")) {
            res = obj.getAreaUnit();
        } else if (par.equalsIgnoreCase("Comp")) {
            res = obj.getCompactness();
        } else if (par.equalsIgnoreCase("Spher")) {
            res = obj.getSphericity();
        } else if (par.equalsIgnoreCase("Feret")) {
            res = obj.getFeret();
        } else if (par.equalsIgnoreCase("Elon1")) {
            res = obj.getMainElongation();
        } else if (par.equalsIgnoreCase("Elon2")) {
            res = obj.getMedianElongation();
        } else if (par.equalsIgnoreCase("DCMin")) {
            res = obj.getDistCenterMin();
        } else if (par.equalsIgnoreCase("DCMax")) {
            res = obj.getDistCenterMax();
        } else if (par.equalsIgnoreCase("DCMean")) {
            res = obj.getDistCenterMean();
        } else if (par.equalsIgnoreCase("DCSD")) {
            res = obj.getDistCenterSigma();
        } else if (par.equalsIgnoreCase("Radius1Ell")) {
            res = obj.getRadiusMoments(2);
        } else if (par.equalsIgnoreCase("Radius2Ell")) {
            res = obj.getRadiusMoments(1);
        } else if (par.equalsIgnoreCase("Radius3Ell")) {
            res = obj.getRadiusMoments(0);
        }
        return res;
    }

    private void handleQuantif3D(Object[] args) {
        Double D = (Double)args[0];
        int a = D.intValue();
        String s = (String)args[1];
        double res = this.quantif3D(a, s);
        ((Double[])args[2])[0] = res;
    }

    private double quantif3D(int i, String par) {
        ImageHandler ima = this.getImage3D();
        double res = Double.NaN;
        if (i < 0 || i >= this.objects3DPopulation.getNbObjects()) {
            return res;
        }
        Object3D obj = this.objects3DPopulation.getObject(i);
        if (par.equalsIgnoreCase("IntDen")) {
            res = obj.getIntegratedDensity(ima);
        } else if (par.equalsIgnoreCase("Mean")) {
            res = obj.getPixMeanValue(ima);
        } else if (par.equalsIgnoreCase("Min")) {
            res = obj.getPixMinValue(ima);
        } else if (par.equalsIgnoreCase("Max")) {
            res = obj.getPixMaxValue(ima);
        } else if (par.equalsIgnoreCase("Sigma")) {
            res = obj.getPixStdDevValue(ima);
        }
        return res;
    }

    private void handleCentroid3D(Object[] args) {
        Double D = (Double)args[0];
        int i = D.intValue();
        Object3D obj = this.objects3DPopulation.getObject(i);
        ((Double[])args[1])[0] = obj.getCenterX();
        ((Double[])args[2])[0] = obj.getCenterY();
        ((Double[])args[3])[0] = obj.getCenterZ();
    }

    private void handleMassCentroid3D(Object[] args) {
        ImageHandler ima = this.getImage3D();
        Double D = (Double)args[0];
        int i = D.intValue();
        Object3D obj = this.objects3DPopulation.getObject(i);
        ((Double[])args[1])[0] = obj.getMassCenterX(ima);
        ((Double[])args[2])[0] = obj.getMassCenterY(ima);
        ((Double[])args[3])[0] = obj.getMassCenterZ(ima);
    }

    private void handleRadiusBorderVoxel(Object[] args) {
        Double D = (Double)args[0];
        int i = D.intValue();
        D = (Double)args[1];
        int j = D.intValue();
        D = (Double)args[2];
        int s = D.intValue();
        Object3D obj1 = this.objects3DPopulation.getObject(i);
        Point3D cen1 = obj1.getCenterAsPoint();
        Object3D obj2 = this.objects3DPopulation.getObject(j);
        Point3D cen2 = obj2.getCenterAsPoint();
        Vector3D dir = s == 1 ? new Vector3D(cen1, cen2) : new Vector3D(cen2, cen1);
        Vector3D Vborder = obj1.vectorPixelBorder(cen1.getX(), cen1.getY(), cen1.getZ(), dir);
        Vector3D border = cen1.getVector3D().add(Vborder);
        ((Double[])args[3])[0] = border.getX();
        ((Double[])args[4])[0] = border.getY();
        ((Double[])args[5])[0] = border.getZ();
    }

    private int closestObject(int a, String Dist) {
        int[] indices = this.list.getSelectedIndices();
        if (indices.length == 0) {
            indices = this.getAllIndexes();
        }
        Object3D ob1 = this.objects3DPopulation.getObject(a);
        Object3D ob2 = null;
        if (Dist.equalsIgnoreCase("bb")) {
            ob2 = this.objects3DPopulation.closestBorder(ob1, indices);
        } else if (Dist.equalsIgnoreCase("cc")) {
            ob2 = this.objects3DPopulation.closestCenter(ob1, indices, true);
        }
        return this.objects3DPopulation.getIndexOf(ob2);
    }

    private int kClosestObject(int a, int k, String Dist) {
        Object3D ob1 = this.objects3DPopulation.getObject(a);
        Object3D ob2 = null;
        if (Dist.equalsIgnoreCase("bb")) {
            ObjectsPopulationDistances distances = new ObjectsPopulationDistances(this.objects3DPopulation);
            distances.setCurrentObject(ob1);
            ob2 = distances.kClosestBorder(k);
        } else if (Dist.equalsIgnoreCase("cc")) {
            ob2 = this.objects3DPopulation.kClosestCenter(ob1, k, true);
        }
        return this.objects3DPopulation.getIndexOf(ob2);
    }

    private void handleBounding3D(Object[] args) {
        Double D = (Double)args[0];
        int i = D.intValue();
        Object3D obj = this.objects3DPopulation.getObject(i);
        ((Double[])args[1])[0] = obj.getXmin();
        ((Double[])args[2])[0] = obj.getXmax();
        ((Double[])args[3])[0] = obj.getYmin();
        ((Double[])args[4])[0] = obj.getYmax();
        ((Double[])args[5])[0] = obj.getZmin();
        ((Double[])args[6])[0] = obj.getZmax();
    }

    private void initComponents() {
        block6: {
            try {
                if (!Prefs.get((String)"RoiManager3D-Options_UseUI.boolean", (boolean)false)) break block6;
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(RoiManager3D_2.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.jPanel = new JPanel();
        this.jScrollPane = new JScrollPane();
        this.list = new JList();
        this.buttonSegmentation3D = new JButton();
        this.buttonAddImage = new JButton();
        this.buttonDelete = new JButton();
        this.buttonErase = new JButton();
        this.buttonRename = new JButton();
        this.buttonSplit = new JButton();
        this.buttonMerge = new JButton();
        this.buttonQuantif = new JButton();
        this.buttonMeasure = new JButton();
        this.buttonLoad = new JButton();
        this.buttonColoc = new JButton();
        this.button3Dviewer = new JButton();
        this.buttonFillStack = new JButton();
        this.buttonAngles = new JButton();
        this.buttonListVoxels = new JButton();
        this.buttonLabel = new JButton();
        this.buttonSave = new JButton();
        this.buttonDistances = new JButton();
        this.buttonAbout = new JButton();
        this.buttonLiveRoi = new JButton();
        this.buttonSelectAll = new JButton();
        this.buttonDeselect = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.buttonConfig = new JButton();
        this.setDefaultCloseOperation(3);
        this.setPreferredSize(new Dimension(440, 445));
        this.setResizable(false);
        this.list.setModel(new AbstractListModel(){
            final String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                RoiManager3D_2.this.listMouseReleased(evt);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RoiManager3D_2.this.listValueChanged(evt);
            }
        });
        this.jScrollPane.setViewportView(this.list);
        this.buttonSegmentation3D.setText("3D Segmentation");
        this.buttonSegmentation3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonSegmentation3DActionPerformed(evt);
            }
        });
        this.buttonAddImage.setText("Add Image");
        this.buttonAddImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonAddImageActionPerformed(evt);
            }
        });
        this.buttonDelete.setText("Delete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.buttonErase.setText("Erase");
        this.buttonErase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonEraseActionPerformed(evt);
            }
        });
        this.buttonRename.setText("Rename");
        this.buttonRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonRenameActionPerformed(evt);
            }
        });
        this.buttonSplit.setText("Split in two");
        this.buttonSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonSplitActionPerformed(evt);
            }
        });
        this.buttonMerge.setText("Merge");
        this.buttonMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonMergeActionPerformed(evt);
            }
        });
        this.buttonQuantif.setText("Quantif 3D");
        this.buttonQuantif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonQuantifActionPerformed(evt);
            }
        });
        this.buttonMeasure.setText("Measure 3D");
        this.buttonMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonMeasureActionPerformed(evt);
            }
        });
        this.buttonLoad.setIcon(new ImageIcon(this.getClass().getResource("/icons/fileopen.png")));
        this.buttonLoad.setToolTipText("Load objects");
        this.buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonLoadActionPerformed(evt);
            }
        });
        this.buttonColoc.setText("Colocalisation");
        this.buttonColoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonColocActionPerformed(evt);
            }
        });
        this.button3Dviewer.setText("3D Viewer");
        this.button3Dviewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.button3DviewerActionPerformed(evt);
            }
        });
        this.buttonFillStack.setText("Fill Stack");
        this.buttonFillStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonFillStackActionPerformed(evt);
            }
        });
        this.buttonAngles.setText("Angles");
        this.buttonAngles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonAnglesActionPerformed(evt);
            }
        });
        this.buttonListVoxels.setText("List Voxels");
        this.buttonListVoxels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonListVoxelsActionPerformed(evt);
            }
        });
        this.buttonLabel.setText("Label");
        this.buttonLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonLabelActionPerformed(evt);
            }
        });
        this.buttonSave.setIcon(new ImageIcon(this.getClass().getResource("/icons/filesave.png")));
        this.buttonSave.setToolTipText("Save objects");
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonSaveActionPerformed(evt);
            }
        });
        this.buttonDistances.setText("Distances");
        this.buttonDistances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonDistancesActionPerformed(evt);
            }
        });
        this.buttonAbout.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_about.png")));
        this.buttonAbout.setToolTipText("About");
        this.buttonAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonAboutActionPerformed(evt);
            }
        });
        this.buttonLiveRoi.setText("Live Roi:  OFF");
        this.buttonLiveRoi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonLiveRoiActionPerformed(evt);
            }
        });
        this.buttonSelectAll.setText("Select All");
        this.buttonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonSelectAllActionPerformed(evt);
            }
        });
        this.buttonDeselect.setText("Deselect");
        this.buttonDeselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonDeselectActionPerformed(evt);
            }
        });
        this.buttonConfig.setIcon(new ImageIcon(this.getClass().getResource("/icons/config.png")));
        this.buttonConfig.setToolTipText("Settings");
        this.buttonConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RoiManager3D_2.this.buttonConfigActionPerformed(evt);
            }
        });
        GroupLayout jPanelLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(jPanelLayout);
        jPanelLayout.setHorizontalGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.buttonMerge, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonSplit)).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.buttonRename).addGap(0, 0, 0).addComponent(this.buttonDelete).addGap(0, 0, 0).addComponent(this.buttonErase, -1, -1, Short.MAX_VALUE)).addComponent(this.jSeparator3).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.buttonSegmentation3D).addGap(0, 0, 0).addComponent(this.buttonAddImage))).addContainerGap(24, Short.MAX_VALUE)).addGroup(jPanelLayout.createSequentialGroup().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.buttonDistances).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonAngles)).addComponent(this.jSeparator4).addComponent(this.jSeparator5).addGroup(GroupLayout.Alignment.LEADING, jPanelLayout.createSequentialGroup().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonColoc, -1, -1, Short.MAX_VALUE).addComponent(this.buttonMeasure, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonListVoxels, -1, 130, Short.MAX_VALUE).addComponent(this.buttonQuantif, -1, -1, Short.MAX_VALUE))).addGroup(jPanelLayout.createSequentialGroup().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonSelectAll, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.button3Dviewer, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonFillStack).addComponent(this.buttonDeselect))).addGroup(GroupLayout.Alignment.LEADING, jPanelLayout.createSequentialGroup().addComponent(this.buttonLoad, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSave, -2, 46, -2)).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.buttonConfig, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAbout, -2, 46, -2))).addGroup(jPanelLayout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.buttonLiveRoi).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonLabel))).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanelLayout.setVerticalGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelLayout.createSequentialGroup().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSegmentation3D).addComponent(this.buttonAddImage)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonRename).addComponent(this.buttonDelete).addComponent(this.buttonErase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonMerge).addComponent(this.buttonSplit)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonMeasure).addComponent(this.buttonQuantif)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonDistances).addComponent(this.buttonAngles)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonColoc).addComponent(this.buttonListVoxels)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button3Dviewer).addComponent(this.buttonFillStack)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSelectAll).addComponent(this.buttonDeselect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonLiveRoi).addComponent(this.buttonLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSave, -1, -1, Short.MAX_VALUE).addComponent(this.buttonAbout, -1, -1, Short.MAX_VALUE).addComponent(this.buttonConfig, -1, -1, Short.MAX_VALUE).addComponent(this.buttonLoad, -1, -1, Short.MAX_VALUE)).addGap(9, 9, 9)).addComponent(this.jScrollPane, -2, 390, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel, -2, 402, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void buttonEraseActionPerformed(ActionEvent evt) {
        this.delete(true);
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.delete(false);
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        if (!this.saveObjects()) {
            IJ.log((String)"Could not write RoiSet3D ");
        }
    }

    private void buttonSegmentation3DActionPerformed(ActionEvent evt) {
        String text = this.buttonSegmentation3D.getText();
        this.buttonSegmentation3D.setText("Segmenting...");
        this.buttonSegmentation3D.setEnabled(false);
        Thread thread = new Thread(() -> {
            this.segmentation3D();
            SwingUtilities.invokeLater(() -> {
                this.buttonSegmentation3D.setText(text);
                this.list.updateUI();
                this.buttonSegmentation3D.setEnabled(true);
            });
        });
        thread.start();
    }

    private void buttonAddImageActionPerformed(ActionEvent evt) {
        this.buttonAddImage.setText("Adding ...");
        this.buttonAddImage.setEnabled(false);
        Thread thread = new Thread(() -> {
            this.addImage();
            SwingUtilities.invokeLater(() -> {
                this.buttonAddImage.setText("Add Image");
                this.list.updateUI();
                this.buttonAddImage.setEnabled(true);
            });
        });
        thread.start();
    }

    private void listValueChanged(ListSelectionEvent evt) {
        if (this.live) {
            this.computeRois();
        }
    }

    private void buttonRenameActionPerformed(ActionEvent evt) {
        this.rename(null);
    }

    private void buttonMergeActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndices().length < 2) {
            IJ.showMessage((String)"Needs at least 2 selected objects");
        } else {
            this.merge();
        }
    }

    private void buttonSplitActionPerformed(ActionEvent evt) {
        this.split();
    }

    private void buttonMeasureActionPerformed(ActionEvent evt) {
        String text = this.buttonMeasure.getText();
        this.buttonMeasure.setText("Measure ...");
        this.buttonMeasure.setEnabled(false);
        Thread thread = new Thread(() -> {
            this.measure3D();
            SwingUtilities.invokeLater(() -> {
                this.buttonMeasure.setText(text);
                this.list.updateUI();
                this.buttonMeasure.setEnabled(true);
            });
        });
        thread.start();
    }

    private void buttonQuantifActionPerformed(ActionEvent evt) {
        String text = this.buttonQuantif.getText();
        this.buttonQuantif.setText("Quantif ...");
        this.buttonQuantif.setEnabled(false);
        Thread thread = new Thread(() -> {
            this.quantif3D();
            SwingUtilities.invokeLater(() -> {
                this.buttonQuantif.setText(text);
                this.list.updateUI();
                this.buttonQuantif.setEnabled(true);
            });
        });
        thread.start();
    }

    private void buttonDistancesActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndices().length == 1) {
            IJ.showMessage((String)"Needs at least 2 selected objects");
        } else {
            String text = this.buttonDistances.getText();
            this.buttonDistances.setText("Distances ...");
            this.buttonDistances.setEnabled(false);
            Thread thread = new Thread(() -> {
                this.distance();
                SwingUtilities.invokeLater(() -> {
                    this.buttonDistances.setText(text);
                    this.list.updateUI();
                    this.buttonDistances.setEnabled(true);
                });
            });
            thread.start();
        }
    }

    private void buttonAnglesActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndices().length != 3) {
            IJ.showMessage((String)"Needs 3 objects selected");
        } else {
            this.angle();
        }
    }

    private void buttonColocActionPerformed(ActionEvent evt) {
        if (this.list.getSelectedIndices().length == 1) {
            IJ.showMessage((String)"Needs at least 2 selected objects");
        } else {
            String text = this.buttonColoc.getText();
            this.buttonColoc.setText("Coloc ...");
            this.buttonColoc.setEnabled(false);
            Thread thread = new Thread(() -> {
                this.coloc();
                SwingUtilities.invokeLater(() -> {
                    this.buttonColoc.setText(text);
                    this.list.updateUI();
                    this.buttonColoc.setEnabled(true);
                });
            });
            thread.start();
        }
    }

    private void buttonListVoxelsActionPerformed(ActionEvent evt) {
        String text = this.buttonListVoxels.getText();
        this.buttonListVoxels.setText("List ...");
        this.buttonListVoxels.setEnabled(false);
        Thread thread = new Thread(() -> {
            this.listVoxels();
            SwingUtilities.invokeLater(() -> {
                this.buttonListVoxels.setText(text);
                this.list.updateUI();
                this.buttonListVoxels.setEnabled(true);
            });
        });
        thread.start();
    }

    private void buttonLiveRoiActionPerformed(ActionEvent evt) {
        this.setLiveMode(!this.live);
    }

    private void listMouseReleased(MouseEvent evt) {
        int index = this.list.locationToIndex(evt.getPoint());
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Select", (int)index);
        }
    }

    private void buttonAboutActionPerformed(ActionEvent evt) {
        AboutMCIB about = new AboutMCIB("RoiManager3D V" + version);
        about.drawAbout();
    }

    private void button3DviewerActionPerformed(ActionEvent evt) {
        this.fill3DViewer();
    }

    private void buttonDeselectActionPerformed(ActionEvent evt) {
        this.deselect();
    }

    private void buttonSelectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private void buttonLabelActionPerformed(ActionEvent evt) {
        this.label();
    }

    private void buttonFillStackActionPerformed(ActionEvent evt) {
        this.fill3D();
    }

    private void buttonConfigActionPerformed(ActionEvent evt) {
        IJ.run((String)"3D Manager Options");
    }

    private void buttonLoadActionPerformed(ActionEvent evt) {
        this.loadObjects();
    }

    void addImage() {
        ImagePlus contours;
        ImagePlus plus = this.getImage();
        if (plus == null) {
            IJ.showMessage((String)"Please open an labelled image");
            return;
        }
        String title = plus.getTitle();
        this.objects3DPopulation.setCalibration(plus.getCalibration());
        if (plus.getBitDepth() == 24) {
            IJ.showMessage((String)"Cannot import RGB image");
            return;
        }
        if (title.contains("Objects map of")) {
            contours = WindowManager.getImage((String)(title = title.replaceFirst("Objects map of", "Surface map of")));
            if (contours != null) {
                IJ.log((String)("Contours found : " + title));
            }
        } else if (title.contains("-3Dseg") && (contours = WindowManager.getImage((String)(title = title.replace("-3Dseg", "-3Dsurf")))) != null) {
            IJ.log((String)("Contours found : " + title));
        }
        int[] dims = plus.getDimensions();
        int channel = plus.getChannel();
        int frame = plus.getFrame();
        if (plus.isHyperStack() || dims[2] > 1 || dims[4] > 1) {
            IJ.log((String)("Hyperstack found, extracting current channel " + channel + " and frame " + frame));
            Duplicator duplicator = new Duplicator();
            plus = duplicator.run(plus, channel, channel, 1, dims[3], frame, frame);
        }
        ImageHandler seg = ImageHandler.wrap((ImagePlus)plus);
        int minX = 0;
        int maxX = seg.sizeX;
        int minY = 0;
        int maxY = seg.sizeY;
        int minZ = 0;
        int maxZ = seg.sizeZ;
        int nb = this.objects3DPopulation.getNbObjects();
        int min = (int)seg.getMinAboveValue(0.0f);
        int max = (int)seg.getMax();
        if (min == Integer.MAX_VALUE || max == 0) {
            IJ.log((String)"No objects found.");
            return;
        }
        IJ.log((String)("Adding image : min-max " + min + " " + max));
        LinkedList[] objects = new LinkedList[max - min + 1];
        for (int i = 0; i < max - min + 1; ++i) {
            objects[i] = new LinkedList();
        }
        for (int k = minZ; k < maxZ; ++k) {
            for (int j = minY; j < maxY; ++j) {
                for (int i = minX; i < maxX; ++i) {
                    float pix = seg.getPixel(i, j, k);
                    if (!(pix > 0.0f)) continue;
                    objects[(int)pix - min].add(new Voxel3D(i, j, k, pix));
                }
            }
        }
        LinkedList<LinkedList> listObjects = new LinkedList<LinkedList>();
        for (int i = 0; i < max - min + 1; ++i) {
            if (objects[i].isEmpty()) continue;
            listObjects.add(objects[i]);
        }
        this.addListVoxels(listObjects, plus);
        this.buildHash();
        this.label = null;
        IJ.log((String)(this.objects3DPopulation.getNbObjects() - nb + " objects added. Total of " + this.objects3DPopulation.getNbObjects() + " objects"));
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_AddImage");
        }
        this.list.updateUI();
    }

    public void addListVoxels(LinkedList list, ImagePlus plus) {
        Iterator it = list.iterator();
        Calibration cal = plus.getCalibration();
        Roi roi = plus.getRoi();
        boolean excludeXY = Prefs.get((String)"RoiManager3D-Options_ExcludeXY.boolean", (boolean)false);
        boolean excludeZ = Prefs.get((String)"RoiManager3D-Options_ExcludeZ.boolean", (boolean)false);
        ImageInt seg = plus.getBitDepth() < 32 ? ImageInt.wrap((ImagePlus)plus) : null;
        while (it.hasNext()) {
            LinkedList objList = (LinkedList)it.next();
            if (objList.isEmpty()) continue;
            boolean roiok = false;
            boolean edgeok = false;
            Object3DVoxels obj = new Object3DVoxels((List)objList);
            Object3D_IJUtils.setCalibration((Object3D)obj, (Calibration)cal);
            obj.setLabelImage(seg);
            obj.computeContours();
            obj.setLabelImage(null);
            if (roi == null || roi.contains((int)Math.round(obj.getCenterX()), (int)Math.round(obj.getCenterY()))) {
                roiok = true;
            }
            if (excludeXY || excludeZ) {
                if (!obj.edgeImage((ImageHandler)seg, excludeXY, excludeZ)) {
                    edgeok = true;
                }
            } else {
                edgeok = true;
            }
            if (!roiok || !edgeok) continue;
            this.addObject3D((Object3D)obj);
        }
    }

    public void addObjects3DPopulation(Objects3DPopulation pop) {
        for (int i = 0; i < pop.getNbObjects(); ++i) {
            this.addObject3D(pop.getObject(i));
        }
        this.buildHash();
    }

    public void addObjects3D(Object3D[] objs) {
        for (Object3D obj : objs) {
            this.addObject3D(obj);
        }
    }

    public void addObjects3D(ArrayList<Object3D> objs) {
        for (Object3D obj : objs) {
            this.addObject3D(obj);
        }
    }

    public void addObject3D(Object3D obj) {
        this.objects3DPopulation.addObject(obj);
        String name = this.getModelNameFromObject(this.objects3DPopulation.getNbObjects() - 1);
        this.objectsModel.addElement(name);
        this.hashNames.put(name, this.objectsModel.size() - 1);
    }

    private String getModelNameFromObject(int i) {
        String name;
        Object3D obj = this.objects3DPopulation.getObject(i);
        if (obj.getName().length() == 0) {
            name = "obj" + this.objects3DPopulation.getNbObjects() + "-val" + obj.getValue();
            obj.setName(name);
        } else {
            name = obj.getName();
            if (!obj.getComment().isEmpty()) {
                name = name.concat(" " + obj.getComment());
            }
            if (obj.getType() > 0) {
                name = name.concat(" (" + obj.getType() + ")");
            }
        }
        return name;
    }

    void buildHash() {
        this.hashNames.clear();
        for (int i = 0; i < this.objectsModel.getSize(); ++i) {
            this.hashNames.put((String)this.objectsModel.get(i), i);
        }
    }

    private boolean merge() {
        int i;
        int[] indexes = this.list.getSelectedIndices();
        Object3DVoxels obj0 = (Object3DVoxels)this.objects3DPopulation.getObject(indexes[0]);
        int le = indexes.length;
        for (i = 1; i < le; ++i) {
            IJ.showStatus((String)("Merging Object " + this.objectsModel.get(indexes[i])));
            Object3DVoxels obj = (Object3DVoxels)this.objects3DPopulation.getObject(indexes[i]);
            obj0.addVoxels(obj.getVoxels());
        }
        for (i = le - 1; i > 0; --i) {
            this.delete(indexes[i]);
        }
        this.buildHash();
        this.list.updateUI();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Merge");
        }
        return true;
    }

    private boolean split() {
        ImagePlus plus = this.getImage();
        if (this.list.isSelectionEmpty()) {
            IJ.log((String)"Select an object to split");
            return false;
        }
        int[] indexes = this.list.getSelectedIndices();
        int i0 = indexes[0];
        Object3D obj0 = this.objects3DPopulation.getObject(i0);
        Calibration cal = Object3D_IJUtils.getCalibration((Object3D)obj0);
        int val0 = obj0.getValue();
        int nb = this.objectsModel.size();
        if (!(obj0 instanceof Object3DVoxels)) {
            IJ.log((String)"Cannot split object");
            return false;
        }
        boolean res = false;
        int dist = (int)Prefs.get((String)"RoiManager3D-Options_splitDist.double", (double)5.0);
        IJ.log((String)"Splitting");
        Object3DVoxels[] objslist = Segment3DSpotsOld.splitSpotWatershed((Object3D)obj0, (float)2.0f, (float)dist);
        IJ.log((String)"split complete");
        if (objslist != null && objslist[0].getVolumePixels() > 0 && objslist[1].getVolumePixels() > 0) {
            res = true;
            Object3DVoxels obj1 = objslist[0];
            Object3D_IJUtils.setCalibration((Object3D)obj1, (Calibration)cal);
            obj1.setValue(val0);
            obj1.setName(obj0.getName() + "-split1");
            Object3DVoxels obj2 = objslist[1];
            Object3D_IJUtils.setCalibration((Object3D)obj2, (Calibration)cal);
            obj2.setValue(val0);
            obj2.setName(obj0.getName() + "-split2");
            this.delete(i0);
            this.addObject3D((Object3D)obj1);
            this.addObject3D((Object3D)obj2);
            this.buildHash();
            this.list.updateUI();
        } else {
            IJ.log((String)"Object was not splitted");
        }
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Split");
        }
        return res;
    }

    public boolean updateName(int index) {
        this.hashNames.remove(this.getModelNameFromObject(index));
        String name2 = this.getModelNameFromObject(index);
        this.objectsModel.set(index, name2);
        this.list.updateUI();
        this.hashNames.put(name2, index);
        return true;
    }

    boolean rename(String name2) {
        int[] indices = this.list.getSelectedIndices();
        if (indices.length == 0) {
            return this.error("One or more items in the list must be selected.");
        }
        if (name2 == null) {
            name2 = IJ.getString((String)"New name", (String)"Name");
        }
        if (indices.length == 1) {
            this.objects3DPopulation.getObject(indices[0]).setName(name2);
            this.updateName(indices[0]);
            this.list.updateUI();
            return true;
        }
        int c = 1;
        for (int i : indices) {
            this.objects3DPopulation.getObject(i).setName(name2 + c);
            this.updateName(i);
            ++c;
        }
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Rename", (String)name2);
        }
        this.list.updateUI();
        return true;
    }

    boolean delete(boolean erase) {
        int count = this.objectsModel.getSize();
        if (count == 0) {
            return false;
        }
        int[] index = this.list.getSelectedIndices();
        if (index.length == 0 || index.length == this.list.getModel().getSize()) {
            String msg = "Delete all items on the list?";
            this.canceled = false;
            if (!IJ.macroRunning() && !IJ.isMacro()) {
                YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "ROIManager3D", msg);
                if (d.cancelPressed()) {
                    this.canceled = true;
                    return false;
                }
                if (!d.yesPressed()) {
                    return false;
                }
            }
            index = this.getAllIndexes();
        }
        this.setLiveMode(false);
        if (erase && !IJ.macroRunning() && !IJ.isMacro() && !IJ.showMessageWithCancel((String)"Erase ?", (String)"Erase will delete the objects in the current image, are you sure ?")) {
            return false;
        }
        for (int i = count - 1; i >= 0; --i) {
            boolean delete = false;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] != i) continue;
                delete = true;
                break;
            }
            if (!delete) continue;
            if (erase) {
                this.fill3D(0, 0, 0);
            }
            this.delete(i);
        }
        this.buildHash();
        if (Recorder.record) {
            if (!erase) {
                Recorder.record((String)"Ext.Manager3D_Delete");
            } else {
                Recorder.record((String)"Ext.Manager3D_Erase");
            }
        }
        this.buildHash();
        if (IJ.macroRunning() || !IJ.isMacro()) {
            // empty if block
        }
        return true;
    }

    void delete(int i) {
        this.objectsModel.remove(i);
        this.objects3DPopulation.removeObject(i);
    }

    private void segmentation3D() {
        GenericDialog gd = new GenericDialog("Threshold 3D");
        gd.addNumericField("Low_Threshold", 128.0, 0);
        gd.addNumericField("High_Threshold", 255.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int low = (int)gd.getNextNumber();
        int high = (int)gd.getNextNumber();
        this.segmentation3D(low, high);
    }

    private void fill3D(int r, int g, int b) {
        ImagePlus ima;
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if ((ima = WindowManager.getCurrentImage()).isHyperStack()) {
            IJ.log((String)"3D filling does not work with hyperstack");
            return;
        }
        if (ima == null) {
            return;
        }
        ImageStack stack = ima.getStack();
        ImageProcessor processor = stack.getProcessor(1);
        double rr = r;
        double gg = g;
        double bb = b;
        boolean color = processor instanceof ColorProcessor;
        boolean gray = processor instanceof ByteProcessor || processor instanceof ShortProcessor || processor instanceof FloatProcessor;
        int intensity = 0;
        if (gray) {
            intensity = (int)Math.round(rr * 0.3 + gg * 0.6 + bb * 0.1);
        }
        if (!gray && !color) {
            IJ.log((String)"Image Type not supported for fill 3D");
            return;
        }
        for (int i = 0; i < indexes.length; ++i) {
            this.fill3DImage(stack, indexes[i], r, g, b, gray);
        }
        ima.updateAndDraw();
        if (Recorder.record) {
            if (gray) {
                Recorder.record((String)"Ext.Manager3D_FillStack", (int)intensity, (int)intensity, (int)intensity);
            } else if (color) {
                Recorder.record((String)"Ext.Manager3D_FillStack", (int)r, (int)g, (int)b);
            }
        }
    }

    private void fill3D(int sel, int r, int g, int b) {
        ImagePlus ima = WindowManager.getCurrentImage();
        if (ima.isHyperStack()) {
            IJ.log((String)"3D filling does not work with hyperstack");
            return;
        }
        if (ima == null) {
            return;
        }
        ImageStack stack = ima.getStack();
        ImageProcessor processor = stack.getProcessor(1);
        boolean gray = processor instanceof ByteProcessor || processor instanceof ShortProcessor || processor instanceof FloatProcessor;
        this.fill3DImage(stack, sel, r, g, b, gray);
    }

    private void fill3DImage(ImageStack stack, int sel, int r, int g, int b, boolean gray) {
        Object3D obj = this.objects3DPopulation.getObject(sel);
        if (gray) {
            int intensity = (int)Math.round((double)r * 0.3 + (double)g * 0.6 + (double)b * 0.1);
            Object3D_IJUtils.draw((Object3D)obj, (ImageStack)stack, (int)intensity);
        } else {
            Object3D_IJUtils.draw((Object3D)obj, (ImageStack)stack, (int)r, (int)g, (int)b);
        }
    }

    private void fill3D() {
        Color col = Toolbar.getForegroundColor();
        this.fill3D(col.getRed(), col.getGreen(), col.getBlue());
    }

    private void fill3DViewer() {
        Color col = Toolbar.getForegroundColor();
        this.fill3DViewer(col.getRed(), col.getGreen(), col.getBlue());
    }

    private void fill3DViewer(int r, int g, int b) {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (this.universe == null || this.universe.getWindow() == null || this.universe.getCanvas() == null) {
            this.universe = new Image3DUniverse();
            this.universe.show();
        }
        for (int i = 0; i < indexes.length; ++i) {
            Object3D obj = this.objects3DPopulation.getObject(indexes[i]);
            this.add3DViewer(obj, (String)this.objectsModel.get(indexes[i]), new Color3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f));
        }
        ImageCanvas3D canvas = (ImageCanvas3D)this.universe.getCanvas();
        canvas.render();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Fill3DViewer", (int)r, (int)g, (int)b);
        }
    }

    private void fill3DViewer(int sel, int r, int g, int b) {
        if (this.universe == null || this.universe.getWindow() == null || this.universe.getCanvas() == null) {
            this.universe = new Image3DUniverse();
            this.universe.show();
        }
        Object3D obj = this.objects3DPopulation.getObject(sel);
        this.add3DViewer(obj, (String)this.objectsModel.get(sel), new Color3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f));
        ImageCanvas3D canvas = (ImageCanvas3D)this.universe.getCanvas();
        canvas.render();
    }

    private void add3DViewer(Object3D obj, String name, Color3f col) {
        if (obj.getAreaPixels() > 0.0) {
            if (!this.universe.contains(name)) {
                ImageHandler labelImage = obj.getMaxLabelImage(1);
                ImageByte imageByte = ((ImageShort)labelImage).convertToByte(false);
                ImagePlus imagePlus = imageByte.getImagePlus();
                Content c = ContentCreator.createContent((String)name, (ImagePlus)imagePlus, (int)2, (int)1, (int)0, (Color3f)col, (int)0, (boolean[])new boolean[]{true, true, true});
                this.universe.addContentLater(c);
                c.setLocked(true);
            } else {
                System.out.println("Recoloring obj " + name);
                Content surface = this.universe.getContent(name);
                surface.setColor(col);
            }
        }
    }

    private void getUniverse() {
        System.out.println("Getting universes");
        IJ.log((String)ImageJ_3D_Viewer.getJava3DVersion());
        ArrayList Viewers3D = Image3DUniverse.universes;
        System.out.println("Universes opened " + Viewers3D.size());
        if (!Viewers3D.isEmpty()) {
            this.universe = (Image3DUniverse)Viewers3D.get(0);
        } else {
            this.universe = new Image3DUniverse(512, 512);
            IJ.wait((int)100);
        }
        System.out.println("Universe " + this.universe + " " + this.universe.allContentsString());
    }

    private void segmentation3D(int low, int high) {
        ImagePlus plus = this.getImage();
        plus.killRoi();
        String title = plus.getTitle();
        Calibration cal = plus.getCalibration();
        ImageHandler ima = ImageHandler.wrap((ImagePlus)plus);
        ima = ima.threshold((float)low, false, false);
        ImageLabeller labels = new ImageLabeller();
        Object seg = Prefs.get((String)"RoiManager3D-Options_Seg32.boolean", (boolean)false) ? labels.getLabelsFloat(ima) : labels.getLabels(ima);
        if (cal != null) {
            seg.setScale(cal.pixelWidth, cal.pixelDepth, cal.getUnits());
        }
        seg.show(title + "-3Dseg");
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Segment", (int)low, (int)high);
        }
    }

    private void angle() {
        int[] indexes = this.list.getSelectedIndices();
        int i1 = indexes[0];
        int i2 = indexes[1];
        int i3 = indexes[2];
        Object3D ob1 = this.objects3DPopulation.getObject(i1);
        Object3D ob2 = this.objects3DPopulation.getObject(i2);
        Object3D ob3 = this.objects3DPopulation.getObject(i3);
        IJ.log((String)("\nObjects : " + this.objectsModel.get(i1) + " " + this.objectsModel.get(i2) + " " + this.objectsModel.get(i3)));
        IJ.log((String)("Angle 1 (213) : " + ob1.angle(ob2, ob3)));
        IJ.log((String)("Angle 2 (123) : " + ob2.angle(ob1, ob3)));
        IJ.log((String)("Angle 3 (132) : " + ob3.angle(ob1, ob2)));
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Angle");
        }
    }

    private void coloc() {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        int nb = indexes.length;
        double distmax = Prefs.get((String)"RoiManager3D-Options_surfDist.double", (double)1.0);
        boolean sc = Prefs.get((String)"RoiManager3D-Options_SurfContact.boolean", (boolean)true);
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Obj1");
        headings.add("Obj2");
        headings.add("Type1");
        headings.add("Type2");
        headings.add("Label1");
        headings.add("Label2");
        headings.add("coloc");
        headings.add("PcColoc");
        if (sc) {
            headings.add("SurfCont pos");
            headings.add("SurfCont neg");
            headings.add("SurfCont t");
        }
        Object[][] data = new Object[indexes.length * (indexes.length - 1)][headings.size()];
        int count = 0;
        for (int i1 = 0; i1 < nb; ++i1) {
            Object3D ob1 = this.objects3DPopulation.getObject(indexes[i1]);
            for (int i2 = i1 + 1; i2 < nb; ++i2) {
                IJ.showStatus((String)("Coloc " + (indexes[i1] + 1) + "-" + (indexes[i2] + 1)));
                Object3D ob2 = this.objects3DPopulation.getObject(indexes[i2]);
                int h1 = 0;
                int h2 = 0;
                data[count][h1++] = count;
                data[count][h1++] = indexes[i1] + 1;
                data[count][h1++] = indexes[i2] + 1;
                data[count][h1++] = ob1.getType();
                data[count][h1++] = ob2.getType();
                data[count][h1++] = this.objectsModel.get(indexes[i1]);
                data[count][h1++] = this.objectsModel.get(indexes[i2]);
                data[count + 1][h2++] = count + 1;
                data[count + 1][h2++] = indexes[i2] + 1;
                data[count + 1][h2++] = indexes[i1] + 1;
                data[count + 1][h2++] = ob2.getType();
                data[count + 1][h2++] = ob1.getType();
                data[count + 1][h2++] = this.objectsModel.get(indexes[i2]);
                data[count + 1][h2++] = this.objectsModel.get(indexes[i1]);
                data[count][h1++] = ob1.getColoc(ob2);
                data[count + 1][h2++] = ob2.getColoc(ob1);
                data[count][h1++] = ob1.pcColoc(ob2);
                data[count + 1][h2++] = ob2.pcColoc(ob1);
                if (sc) {
                    int[] surfc = ob1.surfaceContact(ob2, distmax);
                    data[count][h1++] = surfc[0];
                    data[count][h1++] = surfc[1];
                    data[count][h1++] = surfc[0] + surfc[1];
                    surfc = ob2.surfaceContact(ob1, distmax);
                    data[count + 1][h2++] = surfc[0];
                    data[count + 1][h2++] = surfc[1];
                    data[count + 1][h2++] = surfc[0] + surfc[1];
                }
                count += 2;
            }
        }
        String[] heads = new String[headings.size()];
        heads = headings.toArray(heads);
        this.tableResultsColoc = new ResultsFrame("3D Coloc", heads, data, this, 2);
        this.tableResultsColoc.showFrame();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Coloc");
        }
    }

    private ArrayList<Object3D> getObjects3DList() {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        if (indexes.length == 0) {
            return null;
        }
        ArrayList<Object3D> object3DS = new ArrayList<Object3D>(indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            object3DS.add(this.objects3DPopulation.getObject(indexes[i]));
        }
        return object3DS;
    }

    private boolean measure3D() {
        this.tableResultsMeasure = Manager3DMeasurements.measurements3D(this.getObjects3DList());
        if (this.tableResultsMeasure == null) {
            return false;
        }
        if (Prefs.get((String)"RoiManager3D-Options_UseResultsTable.boolean", (boolean)false)) {
            ResultsTable rt = this.tableResultsMeasure.getResultsTable();
            System.out.println("RT " + rt);
            rt.show("MeasureTable");
        } else {
            this.tableResultsMeasure.setManager(this);
            this.tableResultsMeasure.showFrame();
        }
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Measure");
        }
        return true;
    }

    private boolean quantif3D() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            IJ.error((String)"Error : No image opened.");
            return false;
        }
        this.tableResultsQuantif = Manager3DMeasurements.quantif3D(this.getObjects3DList(), this.getImage3D());
        if (this.tableResultsQuantif == null) {
            return false;
        }
        if (Prefs.get((String)"RoiManager3D-Options_UseResultsTable.boolean", (boolean)false)) {
            ResultsTable rt = this.tableResultsQuantif.getResultsTable();
            System.out.println("RT " + rt);
            rt.show("QuantifTable");
        } else {
            this.tableResultsQuantif.setManager(this);
            this.tableResultsQuantif.showFrame();
        }
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Quantif");
        }
        return true;
    }

    private boolean listVoxels() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            IJ.error((String)"Error : No image opened.");
            return false;
        }
        this.tableResultsVoxels = Manager3DMeasurements.listVoxels(this.getObjects3DList(), this.getImage3D());
        if (this.tableResultsVoxels == null) {
            return false;
        }
        this.tableResultsVoxels.setManager(this);
        this.tableResultsVoxels.showFrame();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_List");
        }
        return true;
    }

    private boolean listVoxelsOld() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            IJ.error((String)"Error : No window opened ?");
            return false;
        }
        int[] indexes = this.list.getSelectedIndices();
        String title = imp.getShortTitle();
        ImageHandler image = this.getImage3D();
        if (image == null) {
            IJ.log((String)("Error, cannot list voxels for this image : " + imp.getTitle()));
            return false;
        }
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Obj");
        headings.add("Type");
        headings.add("Label");
        headings.add("X");
        headings.add("Y");
        headings.add("Z");
        headings.add("Value");
        int vol = 0;
        for (int idx : indexes) {
            vol += this.objects3DPopulation.getObject(idx).getVolumePixels();
        }
        Object[][] data = new Object[vol][headings.size()];
        int count = 0;
        for (int ob = 0; ob < indexes.length; ++ob) {
            int nbObj = indexes[ob] + 1;
            Object nameObj = this.objectsModel.get(indexes[ob]);
            Object3D obj = this.objects3DPopulation.getObject(indexes[ob]);
            List voxel3DS = obj.listVoxels(image);
            if (voxel3DS == null) {
                IJ.log((String)("No voxels to display for " + this.objectsModel.get(indexes[ob])));
                return false;
            }
            for (int i = 0; i < voxel3DS.size(); ++i) {
                int h = 0;
                data[count][h++] = count;
                data[count][h++] = nbObj;
                data[count][h++] = obj.getType();
                data[count][h++] = nameObj;
                Voxel3D voxel = (Voxel3D)voxel3DS.get(i);
                data[count][h++] = voxel.getX();
                data[count][h++] = voxel.getY();
                data[count][h++] = voxel.getZ();
                data[count][h++] = voxel.getValue();
                ++count;
            }
        }
        String[] heads = new String[headings.size()];
        heads = headings.toArray(heads);
        this.tableResultsVoxels = new ResultsFrame("3D Voxels", heads, data, this, 0);
        this.tableResultsVoxels.showFrame();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_List");
        }
        return true;
    }

    private void loadObjects() {
        OpenDialog op = new OpenDialog("Open RoiSet3D", "");
        this.loadObjects(op.getDirectory() + op.getFileName());
    }

    private void loadObjects(String path) {
        Objects3DPopulation popTmp = new Objects3DPopulation();
        popTmp.loadObjects(path);
        this.addObjects3DPopulation(popTmp);
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Load", (String)path);
        }
        this.label = null;
    }

    private boolean saveObjects() {
        SaveDialog op = new SaveDialog("Save RoiSet3D", "Roi3D.zip", ".zip");
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Save", (String)(op.getDirectory() + op.getFileName()));
        }
        return this.saveObjects(op.getDirectory() + op.getFileName());
    }

    private boolean saveObjects(String path) {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        return this.objects3DPopulation.saveObjects(path, indexes);
    }

    private void distance() {
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        int nb = indexes.length;
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Nb");
        headings.add("Obj1");
        headings.add("Obj2");
        headings.add("Type1");
        headings.add("Type2");
        headings.add("Label1");
        headings.add("Label2");
        headings.add("cen-cen");
        headings.add("cen-bor");
        headings.add("bor-bor");
        if (Prefs.get((String)"RoiManager3D-Options_RadDist.boolean", (boolean)true)) {
            headings.add("radiusCen");
            headings.add("excen");
            headings.add("bor-rad");
            headings.add("periph");
        }
        if (Prefs.get((String)"RoiManager3D-Options_Closest.boolean", (boolean)true)) {
            headings.add("closest_cen_i");
            headings.add("closest_bor_i");
            headings.add("closest_cen_n");
            headings.add("closest_bor_n");
        }
        Object[][] data = new Object[indexes.length * (indexes.length - 1)][headings.size()];
        int count = 0;
        for (int i1 = 0; i1 < nb; ++i1) {
            Object3D ob1 = this.objects3DPopulation.getObject(indexes[i1]);
            for (int i2 = i1 + 1; i2 < nb; ++i2) {
                Object3D ob2 = this.objects3DPopulation.getObject(indexes[i2]);
                IJ.showStatus((String)("Distance " + (indexes[i1] + 1) + "-" + (indexes[i2] + 1)));
                int h1 = 0;
                int h2 = 0;
                data[count][h1++] = count;
                data[count][h1++] = indexes[i1] + 1;
                data[count][h1++] = indexes[i2] + 1;
                data[count][h1++] = ob1.getType();
                data[count][h1++] = ob2.getType();
                data[count][h1++] = this.objectsModel.get(indexes[i1]);
                data[count][h1++] = this.objectsModel.get(indexes[i2]);
                data[count + 1][h2++] = count + 1;
                data[count + 1][h2++] = indexes[i2] + 1;
                data[count + 1][h2++] = indexes[i1] + 1;
                data[count + 1][h2++] = ob2.getType();
                data[count + 1][h2++] = ob1.getType();
                data[count + 1][h2++] = this.objectsModel.get(indexes[i2]);
                data[count + 1][h2++] = this.objectsModel.get(indexes[i1]);
                double d1 = ob1.distCenterUnit(ob2);
                data[count][h1++] = d1;
                data[count][h1++] = ob1.distCenterBorderUnit(ob2);
                data[count][h1++] = ob1.distBorderUnit(ob2);
                data[count + 1][h2++] = d1;
                data[count + 1][h2++] = ob2.distCenterBorderUnit(ob1);
                data[count + 1][h2++] = ob2.distBorderUnit(ob1);
                if (Prefs.get((String)"RoiManager3D-Options_RadDist.boolean", (boolean)true)) {
                    double d2 = ob1.radiusCenter(ob2);
                    data[count][h1++] = d2;
                    data[count][h1++] = d1 / d2;
                    double dist1 = ob1.distBorderUnit(ob1.getCenterAsPoint(), ob2, ob2.getCenterAsPoint(), false);
                    double dist2 = ob1.distBorderUnit(ob1.getCenterAsPoint(), ob2, ob2.getCenterAsPoint(), true);
                    double dist = Math.min(dist1, dist2);
                    data[count][h1++] = dist;
                    data[count][h1++] = dist / d2;
                    d2 = ob2.radiusCenter(ob1);
                    data[count + 1][h2++] = d2;
                    data[count + 1][h2++] = d1 / d2;
                    data[count + 1][h2++] = dist;
                    data[count + 1][h2++] = dist / d2;
                }
                if (Prefs.get((String)"RoiManager3D-Options_Closest.boolean", (boolean)true)) {
                    int closest = this.objects3DPopulation.getIndexOf(this.objects3DPopulation.closestCenter(ob1, true));
                    String name1 = (String)this.objectsModel.get(closest);
                    data[count][h1++] = closest + 1;
                    closest = this.objects3DPopulation.getIndexOf(this.objects3DPopulation.closestBorder(ob1));
                    String name2 = (String)this.objectsModel.get(closest);
                    data[count][h1++] = closest + 1;
                    data[count][h1++] = name1;
                    data[count][h1++] = name2;
                    closest = this.objects3DPopulation.getIndexOf(this.objects3DPopulation.closestCenter(ob2, true));
                    name1 = (String)this.objectsModel.get(closest);
                    data[count + 1][h2++] = closest + 1;
                    closest = this.objects3DPopulation.getIndexOf(this.objects3DPopulation.closestBorder(ob2));
                    name2 = (String)this.objectsModel.get(closest);
                    data[count + 1][h2++] = closest + 1;
                    data[count + 1][h2++] = name1;
                    data[count + 1][h2++] = name2;
                }
                count += 2;
            }
        }
        String[] heads = new String[headings.size()];
        heads = headings.toArray(heads);
        this.tableResultsDistance = new ResultsFrame("3D Distance", heads, data, this, 2);
        this.tableResultsDistance.showFrame();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Distance");
        }
    }

    ImagePlus getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return null;
        }
        if (imp.isHyperStack()) {
            int channel = imp.getChannel();
            int frame = imp.getFrame();
            IJ.log((String)("Duplicating HyperStack : C-" + channel + " T-" + frame));
            Roi roi = imp.getRoi();
            imp.killRoi();
            Duplicator duplicator = new Duplicator();
            ImagePlus duplicate = duplicator.run(imp, channel, channel, 1, imp.getNSlices(), frame, frame);
            duplicate.setRoi(roi);
            return duplicate;
        }
        return imp;
    }

    ImageHandler getImage3D() {
        ImagePlus imp = this.getImage();
        if (imp == null) {
            return null;
        }
        return ImageHandler.wrap((ImagePlus)imp);
    }

    private void removeScrollListener(ImagePlus img, AdjustmentListener al, MouseWheelListener ml) {
        if (img.getWindow() != null && img.getWindow().getComponents() != null) {
            for (Component c : img.getWindow().getComponents()) {
                if (c instanceof Scrollbar) {
                    ((Scrollbar)c).removeAdjustmentListener(al);
                    continue;
                }
                if (!(c instanceof Container)) continue;
                for (Component c2 : ((Container)c).getComponents()) {
                    if (!(c2 instanceof Scrollbar)) continue;
                    ((Scrollbar)c2).removeAdjustmentListener(al);
                }
            }
            img.getWindow().removeMouseWheelListener(ml);
        }
    }

    private void addScrollListener(ImagePlus img, AdjustmentListener al, MouseWheelListener ml) {
        if (!this.live) {
            return;
        }
        for (Component c : img.getWindow().getComponents()) {
            if (c instanceof Scrollbar) {
                ((Scrollbar)c).addAdjustmentListener(al);
                continue;
            }
            if (!(c instanceof Container)) continue;
            for (Component c2 : ((Container)c).getComponents()) {
                if (!(c2 instanceof Scrollbar)) continue;
                ((Scrollbar)c2).addAdjustmentListener(al);
            }
        }
        img.getWindow().addMouseWheelListener(ml);
    }

    private void registerActiveImage() {
        ImagePlus activeImage = WindowManager.getCurrentImage();
        if (activeImage != null && activeImage.getProcessor() != null && activeImage.getImageStackSize() > 1) {
            if (this.currentImage != null && this.currentImage.getWindow() != null && this.currentImage != activeImage) {
                this.removeScrollListener(this.currentImage, this, this);
                this.currentImage.killRoi();
                this.currentImage.updateAndDraw();
                this.currentImage = null;
            }
            if (this.currentImage != activeImage) {
                this.addScrollListener(activeImage, this, this);
                this.currentImage = activeImage;
            }
        }
    }

    int[] getAllIndexes() {
        int count = this.objectsModel.getSize();
        int[] indexes = new int[count];
        for (int i = 0; i < count; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    void computeRois() {
        Object3D obj;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        this.registerActiveImage();
        int zmin = imp.getNSlices() + 1;
        int zmax = -1;
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        this.arrayRois = new Roi[imp.getNSlices()];
        for (int i = 0; i < indexes.length; ++i) {
            obj = this.objects3DPopulation.getObject(indexes[i]);
            if (obj.getZmin() < zmin) {
                zmin = obj.getZmin();
            }
            if (obj.getZmax() <= zmax) continue;
            zmax = obj.getZmax();
        }
        this.currentZmin = zmin;
        this.currentZmax = zmax;
        if (this.label == null) {
            this.label = new ImageByte("rois", imp.getWidth(), imp.getHeight(), imp.getNSlices());
        } else {
            this.label.fill(0.0);
        }
        ObjectCreator3D creator3D = new ObjectCreator3D((ImageHandler)this.label);
        int roi = (int)Prefs.get((String)"RoiManager3D-Options_roi.double", (double)0.0);
        block7: for (int i = 0; i < indexes.length; ++i) {
            obj = this.objects3DPopulation.getObject(indexes[i]);
            switch (roi) {
                case 0: {
                    creator3D.drawObject(obj);
                    continue block7;
                }
                case 1: {
                    Point3D point3D = obj.getCenterAsPoint();
                    creator3D.createEllipsoid(point3D.getRoundX(), point3D.getRoundY(), point3D.getRoundZ(), 2.0, 2.0, 1.0, 255.0f, false);
                    continue block7;
                }
                case 2: {
                    Point3D centre = obj.getCenterAsPoint();
                    creator3D.createPixel(centre.getRoundX(), centre.getRoundY(), centre.getRoundZ(), 255);
                    continue block7;
                }
                case 3: {
                    int[] bb = obj.getBoundingBox();
                    int x0 = bb[0];
                    int x1 = bb[1];
                    int y0 = bb[2];
                    int y1 = bb[3];
                    int z0 = bb[4];
                    int z1 = bb[5];
                    for (int z = bb[4]; z <= bb[5]; ++z) {
                        creator3D.createBrick((int)Math.round(0.5 * (double)(x0 + x1)), (int)Math.round(0.5 * (double)(y0 + y1)), (int)Math.round(0.5 * (double)(z0 + z1)), 0.5 * (double)(x1 - x0), 0.5 * (double)(y1 - y0), 0.5 * (double)(z1 - z0), 255.0f);
                    }
                    continue block7;
                }
                default: {
                    Point3D centre2 = obj.getCenterAsPoint();
                    creator3D.createPixel(centre2.getRoundX(), centre2.getRoundY(), centre2.getRoundZ(), 255);
                }
            }
        }
        this.arrayRois = new Roi[imp.getNSlices()];
        for (int zz = zmin; zz <= zmax; ++zz) {
            ByteProcessor mask = new ByteProcessor(imp.getWidth(), imp.getHeight(), (byte[])this.label.getArray1D(zz));
            mask.setThreshold(1.0, 255.0, 2);
            ImagePlus maskPlus = new ImagePlus("mask " + zz, (ImageProcessor)mask);
            ThresholdToSelection tts = new ThresholdToSelection();
            tts.setup("", maskPlus);
            tts.run((ImageProcessor)mask);
            this.arrayRois[zz] = maskPlus.getRoi();
        }
        int middle = (int)(0.5 * (double)zmin + 0.5 * (double)zmax);
        imp.setZ(middle + 1);
        imp.setRoi(this.arrayRois[middle]);
        imp.updateAndDraw();
    }

    void computeRoisOld() {
        Object3D obj;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        this.registerActiveImage();
        int zmin = imp.getNSlices() + 1;
        int zmax = -1;
        int[] indexes = this.list.getSelectedIndices();
        if (indexes.length == 0) {
            indexes = this.getAllIndexes();
        }
        this.arrayRois = new Roi[imp.getNSlices()];
        for (int i = 0; i < indexes.length; ++i) {
            obj = this.objects3DPopulation.getObject(indexes[i]);
            if (obj.getZmin() < zmin) {
                zmin = obj.getZmin();
            }
            if (obj.getZmax() <= zmax) continue;
            zmax = obj.getZmax();
        }
        this.currentZmin = zmin;
        this.currentZmax = zmax;
        for (int zz = zmin; zz <= zmax; ++zz) {
            ByteProcessor mask = new ByteProcessor(imp.getWidth(), imp.getHeight());
            boolean ok = false;
            for (int i = 0; i < indexes.length; ++i) {
                obj = this.objects3DPopulation.getObject(indexes[i]);
                ok |= Object3D_IJUtils.draw((Object3D)obj, (ByteProcessor)mask, (int)zz, (int)255);
            }
            if (!ok) {
                this.arrayRois[zz] = null;
                continue;
            }
            mask.setThreshold(1.0, 255.0, 2);
            ImagePlus maskPlus = new ImagePlus("mask " + zz, (ImageProcessor)mask);
            ThresholdToSelection tts = new ThresholdToSelection();
            tts.setup("", maskPlus);
            tts.run((ImageProcessor)mask);
            this.arrayRois[zz] = maskPlus.getRoi();
        }
        int middle = (int)(0.5 * (double)zmin + 0.5 * (double)zmax);
        imp.setSlice(middle + 1);
        imp.setRoi(this.arrayRois[middle]);
        imp.updateAndDraw();
    }

    private void updateRois() {
        this.updateRois(-1);
    }

    private void updateRois(int slice) {
        ImagePlus plus = WindowManager.getCurrentImage();
        if (plus != null) {
            int sl = plus.getZ() - 1;
            if (slice >= 0) {
                sl = slice;
            }
            if (sl >= this.currentZmin && sl <= this.currentZmax) {
                plus.setRoi(this.arrayRois[sl]);
            } else {
                plus.killRoi();
            }
            plus.updateAndDraw();
        }
    }

    private void label() {
        int[] idx = this.list.getSelectedIndices();
        if (idx.length == 0) {
            idx = this.getAllIndexes();
        }
        ImagePlus plus = this.getImage();
        Overlay over = new Overlay();
        over.drawLabels(false);
        Font font = new Font("Dialog", 0, 10);
        for (int i = 0; i < idx.length; ++i) {
            Object3D obj = this.objects3DPopulation.getObject(idx[i]);
            String name = (String)this.objectsModel.get(idx[i]);
            TextRoi roi = new TextRoi((int)(obj.getCenterX() - (double)(name.length() * font.getSize() / 4)), obj.getYmax() + font.getSize() / 2, name, font);
            roi.setPosition((int)(obj.getCenterZ() + 1.0));
            over.add((Roi)roi);
        }
        plus.setOverlay(over);
        plus.updateAndDraw();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_Label");
        }
    }

    boolean error(String msg) {
        new MessageDialog((Frame)this, "ROI Manager", msg);
        Macro.abort();
        return false;
    }

    public void itemStateChanged(ItemEvent ie) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseClicked(MouseEvent me) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mousePressed(MouseEvent me) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseReleased(MouseEvent me) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseEntered(MouseEvent me) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mouseExited(MouseEvent me) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.live) {
            this.updateRois();
        }
    }

    public void transformationStarted(View view) {
    }

    public void transformationUpdated(View view) {
    }

    public void transformationFinished(View view) {
    }

    public void contentAdded(Content c) {
    }

    public void contentRemoved(Content c) {
    }

    public void contentChanged(Content c) {
    }

    public void contentSelected(Content c) {
        if (c == null || !Prefs.get((String)"RoiManager3D-Options_sync3DViewer.boolean", (boolean)false)) {
            return;
        }
        this.selectByName(c.getName());
    }

    public void canvasResized() {
    }

    public void universeClosed() {
        this.universe = null;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        if (!this.live) {
            return;
        }
        IJ.wait((int)1);
        this.updateRois();
    }

    public void run(String arg) {
        boolean multiple = Prefs.get((String)"RoiManager3D-Options_UseMultiple.boolean", (boolean)false);
        if (manager3d == null || multiple) {
            if (manager3d == null) {
                IJ.log((String)"First instance of 3D Manager");
            }
            if (multiple) {
                IJ.log((String)"Multiple instances of 3D Manager allowed, check options");
            }
            this.create3DManager();
            manager3d = this;
        }
        if (IJ.macroRunning()) {
            Functions.registerExtensions((MacroExtension)manager3d);
        }
    }

    private void selectAll() {
        this.list.setSelectionInterval(0, this.objectsModel.getSize() - 1);
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_SelectAll");
        }
    }

    private void deselect() {
        this.list.clearSelection();
        this.list.updateUI();
        if (Recorder.record) {
            Recorder.record((String)"Ext.Manager3D_DeselectAll");
        }
    }

    public void selectByName(String name) {
        Integer sel = this.hashNames.get(name);
        if (sel != null && sel >= 0) {
            this.list.setSelectedIndex(sel);
        }
    }

    public void selectByNumber(int se) {
        int sel = se;
        if (sel >= 0) {
            this.list.setSelectedIndex(sel);
        }
    }

    public void selectByNames(String[] names) {
        int[] sels = new int[names.length];
        int c = 0;
        for (String na : names) {
            sels[c++] = this.hashNames.get(na);
        }
        this.selectByNumbers(sels);
    }

    public void selectByNumbers(int[] se) {
        this.list.clearSelection();
        int[] sel = se;
        if (sel.length > 0) {
            for (int c = 0; c < sel.length; ++c) {
                int i = sel[c];
                this.list.addSelectionInterval(i, i);
            }
        }
        this.list.updateUI();
    }

    private void setLiveMode(boolean mode) {
        if (this.live == mode) {
            return;
        }
        this.live = mode;
        if (this.live) {
            this.buttonLiveRoi.setText("Live Roi : ON ");
        } else {
            this.buttonLiveRoi.setText("Live Roi : OFF");
        }
        this.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        IJ.showStatus((String)"<< Reading 3D roi >>");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] flavors;
        dtde.acceptDrop(1);
        try {
            Transferable t = dtde.getTransferable();
            for (DataFlavor flavor : flavors = t.getTransferDataFlavors()) {
                String tmp;
                Object ob;
                if (flavor.isFlavorJavaFileListType()) break;
                if (!flavor.isFlavorTextType() || !((ob = t.getTransferData(flavor)) instanceof String)) continue;
                String s = ob.toString().trim();
                BufferedReader br = new BufferedReader(new StringReader(s));
                while (null != (tmp = br.readLine())) {
                    if ((tmp = URLDecoder.decode(tmp.replaceAll("\\+", "%2b"), "UTF-8")).startsWith("file://")) {
                        tmp = tmp.substring(7);
                    }
                    this.loadObjects(tmp);
                    if (!tmp.startsWith("http://")) continue;
                }
                break;
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.dropComplete(false);
            return;
        }
        catch (IOException e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
        if (flavors == null || flavors.length == 0) {
            if (IJ.isMacOSX()) {
                IJ.error((String)"First drag and drop ignored. Please try again. .");
            } else {
                IJ.error((String)"Drag and drop failed");
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        IJ.log((String)"Closing 3DManager");
        this.closing();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void rotateUniverse(int a, int b, int c) {
        this.universe.rotateX((double)a);
        this.universe.rotateY((double)b);
        this.universe.rotateZ((double)c);
    }

    private void loadView3D(String S) {
        try {
            IJ.log((String)("Loading view " + S));
            this.universe.loadView(S);
        }
        catch (IOException ex) {
            IJ.log((String)("View " + S + " does not exists"));
        }
    }

    private void closeResult(String win) {
        if ((win.startsWith("A") || win.startsWith("M")) && this.tableResultsMeasure != null) {
            this.tableResultsMeasure.dispose();
        }
        if ((win.startsWith("A") || win.startsWith("Q")) && this.tableResultsQuantif != null) {
            this.tableResultsQuantif.dispose();
        }
        if ((win.startsWith("A") || win.startsWith("D")) && this.tableResultsDistance != null) {
            this.tableResultsDistance.dispose();
        }
        if ((win.startsWith("A") || win.startsWith("C")) && this.tableResultsColoc != null) {
            this.tableResultsColoc.dispose();
        }
        if ((win.startsWith("A") || win.startsWith("L") || win.startsWith("V")) && this.tableResultsVoxels != null) {
            this.tableResultsVoxels.dispose();
        }
    }

    private void saveResult(String win, String file) {
        String name;
        String dir;
        File fi = new File(file);
        if (fi.isDirectory()) {
            dir = file;
            name = "Manager3DResults.csv";
        } else {
            dir = fi.getParent();
            name = fi.getName();
        }
        String fs = File.separator;
        if ((win.startsWith("A") || win.startsWith("M")) && this.tableResultsMeasure != null) {
            IJ.log((String)("Saving 3D Measure in " + dir + fs + "M_" + name));
            if (!this.tableResultsMeasure.getModel().writeData(dir + fs + "M_" + name)) {
                IJ.log((String)("Pb saving " + dir + fs + "M_" + name));
            } else {
                IJ.log((String)"Saved 3D Measure");
            }
        }
        if ((win.startsWith("A") || win.startsWith("Q")) && this.tableResultsQuantif != null) {
            IJ.log((String)("Saving 3D Quantif in " + dir + fs + "Q_" + name));
            if (!this.tableResultsQuantif.getModel().writeData(dir + fs + "Q_" + name)) {
                IJ.log((String)("Pb saving " + dir + fs + "Q_" + name));
            }
        }
        if ((win.startsWith("A") || win.startsWith("D")) && this.tableResultsDistance != null) {
            IJ.log((String)("Saving 3D Distance in " + dir + fs + "D_" + name));
            if (!this.tableResultsDistance.getModel().writeData(dir + fs + "D_" + name)) {
                IJ.log((String)("Pb saving " + dir + fs + "D_" + name));
            }
        }
        if ((win.startsWith("A") || win.startsWith("C")) && this.tableResultsColoc != null) {
            IJ.log((String)("Saving 3D Coloc in " + dir + fs + "C_" + name));
            if (!this.tableResultsColoc.getModel().writeData(dir + fs + "C_" + name)) {
                IJ.log((String)("Pb saving " + dir + fs + "C_" + name));
            }
        }
        if ((win.startsWith("A") || win.startsWith("L") || win.startsWith("V")) && this.tableResultsVoxels != null) {
            IJ.log((String)("Saving 3D List Voxels in " + dir + fs + "L_" + name));
            if (!this.tableResultsVoxels.getModel().writeData(dir + fs + "V_" + name)) {
                IJ.log((String)("Pb saving " + dir + fs + "V_" + name));
            }
        }
    }
}

