/*
 * Decompiled with CFR 0.152.
 */
package mcib_plugins.tools;

import customnode.CustomMesh;
import customnode.MeshLoader;
import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.List;
import java.util.Map;
import mcib3d.geom2.BoundingBox;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib_plugins.tools.Voxelizer;
import org.scijava.vecmath.Point3f;

public class Voxelizer_
implements PlugIn {
    boolean scaleToImage = false;
    String file = "";
    private int imaX = 256;
    private int imaY = 256;
    private int imaZ = 256;

    public void run(String s) {
        if (this.dialog()) {
            IJ.log((String)("Loading mesh file " + this.file));
            Map meshMap = MeshLoader.loadSTL((String)this.file);
            ImageShort draw = new ImageShort("voxels", this.imaX, this.imaY, this.imaZ);
            for (String me : meshMap.keySet()) {
                List mesh = ((CustomMesh)meshMap.get(me)).getMesh();
                BoundingBox box = Voxelizer.boundingBox(mesh);
                if (box.xmin < 0) {
                    for (Point3f point3f : mesh) {
                        point3f.x -= (float)box.xmin;
                    }
                }
                if (box.ymin < 0) {
                    for (Point3f point3f : mesh) {
                        point3f.y -= (float)box.ymin;
                    }
                }
                if (box.zmin < 0) {
                    for (Point3f point3f : mesh) {
                        point3f.z -= (float)box.zmin;
                    }
                }
                box = Voxelizer.boundingBox(mesh);
                float scaleX = (float)draw.sizeX / (float)box.xmax;
                float scaleY = (float)draw.sizeY / (float)box.ymax;
                float scaleZ = (float)draw.sizeZ / (float)box.zmax;
                float scale = Math.min(scaleX, Math.min(scaleY, scaleZ));
                if (this.scaleToImage) {
                    for (Point3f point3f : mesh) {
                        point3f.x *= scale;
                        point3f.y *= scale;
                        point3f.z *= scale;
                    }
                }
                new Voxelizer(mesh).voxelize((ImageHandler)draw, true);
                draw.show("Voxels");
                System.out.println("DONE!");
            }
        }
    }

    private boolean dialog() {
        GenericDialog dialog = new GenericDialog("Voxelizer");
        dialog.addFileField("Choose mesh file", IJ.getDirectory((String)"home"));
        dialog.addNumericField("Image_sizeX", (double)this.imaX);
        dialog.addNumericField("Image_sizeY", (double)this.imaY);
        dialog.addNumericField("Image_sizeZ", (double)this.imaZ);
        dialog.addCheckbox("Scale to image", this.scaleToImage);
        dialog.showDialog();
        this.file = dialog.getNextString();
        this.imaX = (int)dialog.getNextNumber();
        this.imaY = (int)dialog.getNextNumber();
        this.imaZ = (int)dialog.getNextNumber();
        this.scaleToImage = dialog.getNextBoolean();
        return dialog.wasOKed();
    }
}

