/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.scijava.ItemIO;
import org.scijava.Named;
import org.scijava.batch.BatchService;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.log.Logger;
import org.scijava.module.Module;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.Column;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.Table;

@Plugin(type=Command.class, label="Choose batch processing parameters", initializer="initInputChoice")
public class ModuleBatchProcessor<T>
extends DynamicCommand {
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private BatchService batchService;
    @Parameter
    private Logger log;
    @Parameter
    private ModuleInfo moduleInfo;
    @Parameter(label="Which input parameter to batch?", persist=false)
    private String inputChoice;
    @Parameter(label="Input files")
    private File[] inputFileList;
    @Parameter(type=ItemIO.OUTPUT)
    private Table outputTable;

    protected void initInputChoice() {
        MutableModuleItem choiceInput = this.getInfo().getMutableInput("inputChoice", String.class);
        List<ModuleItem<?>> compatibleInputs = this.batchService.batchableInputs(this.moduleInfo);
        if (compatibleInputs.size() == 1) {
            choiceInput.setValue((Module)this, (Object)compatibleInputs.get(0).getName());
            this.resolveInput("inputChoice");
        } else if (compatibleInputs.size() > 1) {
            choiceInput.setChoices(compatibleInputs.stream().map(Named::getName).collect(Collectors.toList()));
        } else {
            this.log.error((Object)"No compatible inputs found. Unable to initialize input choice.");
        }
    }

    public void run() {
        ModuleItem inputModuleItem = this.moduleInfo.getInput(this.inputChoice);
        Module scriptModule = this.moduleService.createModule(this.moduleInfo);
        scriptModule.resolveInput(this.inputChoice);
        this.outputTable = new DefaultGenericTable();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String outputKey : scriptModule.getOutputs().keySet()) {
            columns.add(this.outputTable.appendColumn(outputKey));
            scriptModule.resolveOutput(outputKey);
        }
        for (File file : this.inputFileList) {
            if (this.processFile(scriptModule, inputModuleItem, file)) continue;
            this.log.warn((Object)"Terminating batch process.");
            break;
        }
    }

    private boolean processFile(Module module, ModuleItem<?> inputModuleItem, File file) {
        this.batchService.fillInput(module, inputModuleItem, file);
        this.outputTable.appendRow(file.getName());
        Future instance = this.moduleService.run(module, true, new Object[0]);
        try {
            Map outputs = ((Module)instance.get()).getOutputs();
            for (Map.Entry output : outputs.entrySet()) {
                this.outputTable.set((String)output.getKey(), this.outputTable.getRowCount() - 1, output.getValue());
            }
            return true;
        }
        catch (InterruptedException exc) {
            this.log.error((Object)"Error: interrupted module execution", (Throwable)exc);
            return false;
        }
        catch (ExecutionException exc) {
            this.log.error((Object)"Error during module execution", (Throwable)exc);
            return true;
        }
    }
}

