/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.Contextual;
import org.scijava.Disposable;
import org.scijava.plugin.PluginIndex;
import org.scijava.service.Service;
import org.scijava.service.ServiceHelper;
import org.scijava.service.ServiceIndex;
import org.scijava.util.CheckSezpoz;

public class Context
implements Disposable {
    private static boolean sezpozNeedsToRun = true;
    private final ServiceIndex serviceIndex;
    private final PluginIndex pluginIndex;

    public Context() {
        this(false);
    }

    public Context(boolean empty) {
        this(empty ? Collections.emptyList() : null);
    }

    public Context(Class ... serviceClasses) {
        this(serviceClasses != null ? Arrays.asList(serviceClasses) : null);
    }

    public Context(Collection<Class<? extends Service>> serviceClasses) {
        this(serviceClasses, new PluginIndex());
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, PluginIndex pluginIndex) {
        if (sezpozNeedsToRun) {
            try {
                if (!CheckSezpoz.check(false)) {
                    System.err.println("SezPoz generated annotations.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sezpozNeedsToRun = false;
        }
        this.serviceIndex = new ServiceIndex();
        this.pluginIndex = pluginIndex;
        pluginIndex.discover();
        ServiceHelper serviceHelper = new ServiceHelper(this, serviceClasses);
        serviceHelper.loadServices();
    }

    public ServiceIndex getServiceIndex() {
        return this.serviceIndex;
    }

    public PluginIndex getPluginIndex() {
        return this.pluginIndex;
    }

    public <S extends Service> S getService(Class<S> c) {
        return this.serviceIndex.getService(c);
    }

    public Service getService(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = loader.loadClass(className);
            return this.getService(serviceClass);
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
    }

    public boolean inject(Object o) {
        if (!(o instanceof Contextual)) {
            return false;
        }
        Contextual c = (Contextual)o;
        if (c.getContext() == this) {
            return true;
        }
        c.setContext(this);
        return true;
    }

    @Override
    public void dispose() {
        List services = this.serviceIndex.getAll();
        for (int s = services.size() - 1; s >= 0; --s) {
            ((Service)services.get(s)).dispose();
        }
    }
}

