/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.bushe.swing.event.CleanupEvent;
import org.bushe.swing.event.ThreadSafeEventService;
import org.scijava.log.LogService;
import org.scijava.thread.ThreadService;

public class DefaultEventBus
extends ThreadSafeEventService {
    private final ThreadService threadService;
    private final LogService log;

    public DefaultEventBus(ThreadService threadService, LogService log) {
        super(Long.valueOf(200L), false, null, null, null);
        this.threadService = threadService;
        this.log = log;
    }

    public void publishNow(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publishNow(event, null, null, this.getSubscribers(event.getClass()), this.getVetoSubscribers(event.getClass()), null);
    }

    public void publishNow(Type genericType, Object event) {
        if (genericType == null) {
            throw new IllegalArgumentException("genericType must not be null.");
        }
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publishNow(event, null, null, this.getSubscribers(genericType), null, null);
    }

    public void publishNow(String topicName, Object eventObj) {
        this.publishNow(null, topicName, eventObj, this.getSubscribers(topicName), this.getVetoEventListeners(topicName), null);
    }

    public void publishLater(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publishLater(event, null, null, this.getSubscribers(event.getClass()), this.getVetoSubscribers(event.getClass()), null);
    }

    public void publishLater(Type genericType, Object event) {
        if (genericType == null) {
            throw new IllegalArgumentException("genericType must not be null.");
        }
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publishLater(event, null, null, this.getSubscribers(genericType), null, null);
    }

    public void publishLater(String topicName, Object eventObj) {
        this.publishLater(null, topicName, eventObj, this.getSubscribers(topicName), this.getVetoEventListeners(topicName), null);
    }

    public void publish(Object event) {
        if (event instanceof CleanupEvent) {
            this.publishLater(event);
            return;
        }
        this.publishNow(event);
    }

    public void publish(Type genericType, Object event) {
        this.publishNow(genericType, event);
    }

    public void publish(String topicName, Object eventObj) {
        this.publishNow(topicName, eventObj);
    }

    protected void publish(Object event, String topic, Object eventObj, List subscribers, List vetoSubscribers, StackTraceElement[] callingStack) {
        this.publishNow(event, topic, eventObj, subscribers, vetoSubscribers, callingStack);
    }

    private void publishNow(final Object event, final String topic, final Object eventObj, final List subscribers, final List vetoSubscribers, final StackTraceElement[] callingStack) {
        try {
            this.threadService.invoke(new Runnable(){

                @Override
                public void run() {
                    DefaultEventBus.this.log.debug("publish(" + event + "," + topic + "," + eventObj + "), called from non-EDT Thread:" + Arrays.toString(callingStack));
                    DefaultEventBus.super.publish(event, topic, eventObj, subscribers, vetoSubscribers, callingStack);
                }
            });
        }
        catch (InterruptedException exc) {
            this.log.error(exc);
        }
        catch (InvocationTargetException exc) {
            this.log.error(exc);
        }
    }

    private void publishLater(final Object event, final String topic, final Object eventObj, final List subscribers, final List vetoSubscribers, final StackTraceElement[] callingStack) {
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                DefaultEventBus.this.log.debug("publish(" + event + "," + topic + "," + eventObj + "), called from non-EDT Thread:" + Arrays.toString(callingStack));
                DefaultEventBus.super.publish(event, topic, eventObj, subscribers, vetoSubscribers, callingStack);
            }
        });
    }
}

