/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scijava.util.ClassUtils;

public class ObjectIndex<E>
implements Collection<E> {
    protected final Map<Class<?>, List<E>> hoard = new ConcurrentHashMap();
    private final Class<E> baseClass;

    public ObjectIndex(Class<E> baseClass) {
        this.baseClass = baseClass;
    }

    public Class<E> getBaseClass() {
        return this.baseClass;
    }

    public List<E> getAll() {
        return this.get(All.class);
    }

    public List<E> get(Class<?> type) {
        List<E> list = this.retrieveList(type);
        list = new ArrayList<E>(list);
        return list;
    }

    @Override
    public int size() {
        return this.getAll().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.get(o.getClass()).contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.add(o, false);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, false);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getAll().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E o : c) {
            boolean result = this.add(o, true);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean result = this.remove(o, true);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.hoard.clear();
    }

    public String toString() {
        ArrayList classes = new ArrayList(this.hoard.keySet());
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return ClassUtils.compare(c1, c2);
            }
        });
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName() + ": {");
            List<E> list = this.hoard.get(clazz);
            boolean first = true;
            for (E element : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(element);
            }
            sb.append("}" + nl);
        }
        return sb.toString();
    }

    protected boolean add(E o, boolean batch) {
        return this.add(o, o.getClass(), batch);
    }

    protected boolean remove(Object o, boolean batch) {
        return this.remove(o, o.getClass(), batch);
    }

    protected boolean add(E o, Class<?> type, boolean batch) {
        boolean result = false;
        HashSet<Class<?>> types = this.getTypes(type);
        for (Class clazz : types) {
            if (!this.addToList(o, this.retrieveList(clazz), batch)) continue;
            result = true;
        }
        return result;
    }

    protected boolean remove(Object o, Class<?> type, boolean batch) {
        boolean result = false;
        HashSet<Class<?>> types = this.getTypes(type);
        for (Class clazz : types) {
            if (!this.removeFromList(o, this.retrieveList(clazz), batch)) continue;
            result = true;
        }
        return result;
    }

    protected boolean addToList(E obj, List<E> list, boolean batch) {
        return list.add(obj);
    }

    protected boolean removeFromList(Object obj, List<E> list, boolean batch) {
        return list.remove(obj);
    }

    private HashSet<Class<?>> getTypes(Class<?> type) {
        HashSet types = new HashSet();
        types.add(All.class);
        this.getTypes(type, types);
        return types;
    }

    private void getTypes(Class<?> type, HashSet<Class<?>> types) {
        if (type == null) {
            return;
        }
        types.add(type);
        this.getTypes(type.getSuperclass(), types);
        for (Class<?> iface : type.getInterfaces()) {
            this.getTypes(iface, types);
        }
    }

    private List<E> retrieveList(Class<?> type) {
        List<E> list = this.hoard.get(type);
        if (list == null) {
            list = new ArrayList();
            this.hoard.put(type, list);
        }
        return list;
    }

    private static class All {
        private All() {
        }
    }
}

