/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.object.ObjectIndex;

public class SortedObjectIndex<E extends Comparable<? super E>>
extends ObjectIndex<E> {
    public SortedObjectIndex(Class<E> baseClass) {
        super(baseClass);
    }

    @Override
    public boolean contains(Object o) {
        int index = this.findInList(o, this.getAll());
        return index < 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() == 1) {
            return this.add(c.iterator().next());
        }
        boolean changed = super.addAll(c);
        if (changed) {
            this.sort();
        }
        return changed;
    }

    @Override
    protected boolean addToList(E obj, List<E> list, boolean batch) {
        if (batch) {
            return super.addToList(obj, list, batch);
        }
        int result = Collections.binarySearch(list, obj);
        int index = result < 0 ? -result - 1 : result;
        list.add(index, obj);
        return true;
    }

    private void sort() {
        for (List list : this.hoard.values()) {
            Collections.sort(list);
        }
    }

    private int findInList(Object o, List<E> list) {
        if (!this.getBaseClass().isAssignableFrom(o.getClass())) {
            return list.size();
        }
        Comparable typedObj = (Comparable)o;
        return Collections.binarySearch(list, typedObj);
    }
}

