/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.scijava.util.FileUtils;
import org.scijava.util.IteratorPlus;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckSezpoz {
    public static boolean verbose;
    public static final String FILE_NAME = "latest-sezpoz-check.txt";
    private static MessageDigest digest;

    public static boolean check(boolean checkJars) throws IOException {
        boolean upToDate = true;
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!checkJars && path.endsWith(".jar") || CheckSezpoz.check(new File(path))) continue;
            upToDate = false;
        }
        return upToDate;
    }

    public static boolean check(File file) throws IOException {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            return CheckSezpoz.checkDirectory(file);
        }
        if (file.isFile() && file.getName().endsWith(".jar")) {
            CheckSezpoz.checkJar(file);
        } else {
            System.err.println("WARN: Skipping SezPoz check of " + file);
        }
        return true;
    }

    public static boolean checkDirectory(File classes) throws IOException {
        if (!classes.isDirectory()) {
            return false;
        }
        String path = FileUtils.getPath(classes);
        if (!path.endsWith("target/classes") && !path.endsWith("target/test-classes")) {
            System.err.println("WARN: Ignoring non-Maven build directory: " + classes.getPath());
            return true;
        }
        String type = path.endsWith("target/classes") ? "main" : "test";
        for (File file : classes.listFiles()) {
            if (!file.isFile() || !file.getName().startsWith(".netbeans_")) continue;
            System.err.println("WARN: Ignoring NetBeans build directory: " + classes.getPath());
            return true;
        }
        File projectRoot = classes.getParentFile().getParentFile();
        File source = new File(projectRoot, "src/" + type + "/java");
        if (!source.isDirectory()) {
            System.err.println("WARN: No src/main/java found for " + classes);
            return true;
        }
        long latestCheck = CheckSezpoz.getLatestCheck(classes.getParentFile());
        boolean upToDate = CheckSezpoz.checkDirectory(classes, source, latestCheck);
        if (!upToDate) {
            CheckSezpoz.fixEclipseConfiguration(projectRoot);
            return !CheckSezpoz.fix(classes, source);
        }
        return true;
    }

    protected static long getLatestCheck(File targetDirectory) {
        try {
            File file = new File(targetDirectory, FILE_NAME);
            if (!file.exists()) {
                return -1L;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String firstLine = reader.readLine();
            reader.close();
            if (firstLine == null) {
                return -1L;
            }
            if (firstLine.endsWith("\n")) {
                firstLine = firstLine.substring(0, firstLine.length() - 1);
            }
            return Long.parseLong(firstLine);
        }
        catch (IOException e) {
            return -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    protected static long getLatestCheck(JarFile jar) {
        return -1L;
    }

    private static void setLatestCheck(File targetDirectory) {
        File file = new File(targetDirectory, FILE_NAME);
        try {
            Date date = new Date();
            String content = "" + date.getTime() + "\n" + DateFormat.getDateTimeInstance().format(date) + "\n";
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(content.getBytes());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("ERROR: Failure updating the Sezpoz check timestamp");
        }
    }

    public static boolean checkDirectory(File classes, File source, long youngerThan) throws IOException {
        if (classes.getName().equals("META-INF") || !source.isDirectory()) {
            return true;
        }
        File[] list = classes.listFiles();
        if (list == null) {
            return true;
        }
        for (File file : list) {
            String name = file.getName();
            if (!(file.isDirectory() ? !CheckSezpoz.checkDirectory(file, new File(source, name), youngerThan) : file.isFile() && file.lastModified() > youngerThan && name.endsWith(".class") && CheckSezpoz.hasAnnotation(new File(source, name.substring(0, name.length() - 5) + "java")))) continue;
            return false;
        }
        return true;
    }

    public static void checkJar(File file) throws IOException {
        JarFile jar = new JarFile(file);
        long mtime = CheckSezpoz.getLatestCheck(jar);
        if (mtime < 0L) {
            return;
        }
        for (JarEntry entry : new IteratorPlus<JarEntry>(jar.entries())) {
            if (entry.getTime() <= mtime) continue;
            throw new IOException("Annotations for " + entry + " in " + file + " are out-of-date!");
        }
    }

    protected static boolean hasAnnotation(File file) {
        if (!file.getName().endsWith(".java")) {
            return false;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            boolean inComment = false;
            block2: while ((line = reader.readLine()) != null) {
                int offset = 0;
                if (inComment) {
                    offset = line.indexOf("*/");
                    if (offset < 0) continue;
                    offset += 2;
                    inComment = false;
                }
                int eol = line.length();
                while (offset < eol) {
                    int lineCommentStart;
                    int commentStart = line.indexOf("/*", offset);
                    int end = Math.min(eol, Math.min(commentStart < 0 ? Integer.MAX_VALUE : commentStart, (lineCommentStart = line.indexOf("//", offset)) < 0 ? Integer.MAX_VALUE : lineCommentStart));
                    if (offset < end) {
                        int at = line.indexOf("@", offset);
                        int clazz = offset;
                        while ((clazz = line.indexOf("class", clazz)) >= 0 && (clazz != 0 && Character.isJavaIdentifierPart(line.charAt(clazz - 1)) || clazz + 4 < end && Character.isJavaIdentifierPart(line.charAt(clazz + 5)))) {
                            clazz += 4;
                        }
                        if (at >= 0 && at < end && (clazz < 0 || at < clazz)) {
                            reader.close();
                            return true;
                        }
                        if (clazz >= 0 && clazz < end) {
                            reader.close();
                            return false;
                        }
                    }
                    if (end != commentStart) continue block2;
                    offset = line.indexOf("*/", commentStart + 2);
                    if (offset > 0) {
                        offset += 2;
                        continue;
                    }
                    inComment = true;
                    continue block2;
                }
            }
            reader.close();
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean fix(File classes, File sources) {
        if (!sources.exists()) {
            System.err.println("ERROR: Sources are not in the expected place: " + sources);
            return false;
        }
        ArrayList<String> aptArgs = new ArrayList<String>();
        if (verbose) {
            aptArgs.add("-verbose");
        }
        aptArgs.add("-d");
        aptArgs.add(classes.getPath());
        int count = aptArgs.size();
        CheckSezpoz.addJavaPathsRecursively(aptArgs, sources);
        if (count == aptArgs.size()) {
            return false;
        }
        File[] annotationsBefore = new File(classes, "META-INF/annotations").listFiles();
        Map<String, byte[]> checksumsBefore = CheckSezpoz.checksum(annotationsBefore);
        if (annotationsBefore != null) {
            for (File annotation : annotationsBefore) {
                annotation.delete();
            }
        }
        String[] args = aptArgs.toArray(new String[aptArgs.size()]);
        try {
            System.err.println("WARN: Updating the annotation index in " + classes);
            CheckSezpoz.runApt(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("WARN: Could not fix " + sources + ": apt failed");
            return false;
        }
        boolean result = true;
        File[] annotationsAfter = new File(classes, "META-INF/annotations").listFiles();
        Map<String, byte[]> checksumsAfter = CheckSezpoz.checksum(annotationsAfter);
        if (checksumsAfter.size() == checksumsBefore.size()) {
            result = false;
            for (String key : checksumsAfter.keySet()) {
                byte[] before = checksumsBefore.get(key);
                if (before != null && Arrays.equals(before, checksumsAfter.get(key))) continue;
                result = true;
            }
        }
        CheckSezpoz.setLatestCheck(classes.getParentFile());
        return result;
    }

    private static void runApt(String[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler != null) {
            ArrayList<String> aptArgs = new ArrayList<String>();
            aptArgs.add("-proc:only");
            aptArgs.add("-processor");
            aptArgs.add("net.java.sezpoz.impl.Indexer6");
            aptArgs.addAll(Arrays.asList(args));
            compiler.run(null, null, null, aptArgs.toArray(new String[aptArgs.size()]));
            return;
        }
        System.err.println("WARN: falling back to calling the 'apt' Main class directly");
        ArrayList<String> aptArgs = new ArrayList<String>();
        aptArgs.add("-nocompile");
        aptArgs.add("-factory");
        aptArgs.add("net.java.sezpoz.impl.IndexerFactory");
        aptArgs.addAll(Arrays.asList(args));
        Class<?> aptClass = ToolProvider.getSystemToolClassLoader().loadClass("com.sun.tools.apt.Main");
        Method aptProcess = aptClass.getMethod("process", String[].class);
        aptProcess.invoke(null, new Object[]{aptArgs.toArray(new String[aptArgs.size()])});
    }

    protected static Map<String, byte[]> checksum(File[] files) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (files != null && files.length != 0) {
            for (File file : files) {
                result.put(file.getName(), CheckSezpoz.checksum(file));
            }
        }
        return result;
    }

    protected static synchronized byte[] checksum(File file) {
        try {
            if (digest == null) {
                digest = MessageDigest.getInstance("SHA-1");
            } else {
                digest.reset();
            }
            byte[] buffer = new byte[65536];
            DigestInputStream digestStream = new DigestInputStream(new FileInputStream(file), digest);
            while (digestStream.read(buffer) >= 0) {
            }
            digestStream.close();
            return digest.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static void addJavaPathsRecursively(List<String> list, File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CheckSezpoz.addJavaPathsRecursively(list, file);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".java")) continue;
            list.add(file.getPath());
        }
    }

    protected static void touch(File file) throws IOException {
        new FileOutputStream(file, true).close();
    }

    protected static void fixEclipseConfiguration(File directory) {
        if (!new File(directory, ".settings").isDirectory()) {
            return;
        }
        CheckSezpoz.fixFactoryPath(directory);
        CheckSezpoz.fixAnnotationProcessingSettings(directory);
    }

    protected static void fixFactoryPath(File directory) {
        File factoryPath = new File(directory, ".factorypath");
        try {
            Document xml;
            if (factoryPath.exists()) {
                xml = CheckSezpoz.readXMLFile(factoryPath);
            } else {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                xml.appendChild(xml.createElement("factorypath"));
            }
            if (!CheckSezpoz.containsSezpozId(xml.getElementsByTagName("factorypathentry"))) {
                Element element = xml.createElement("factorypathentry");
                element.setAttribute("enabled", "true");
                element.setAttribute("id", "M2_REPO/net/java/sezpoz/sezpoz/1.9-imagej/sezpoz-1.9-imagej.jar");
                element.setAttribute("kind", "VARJAR");
                element.setAttribute("runInBatchMode", "true");
                xml.getDocumentElement().appendChild(element);
                CheckSezpoz.writeXMLFile(xml, factoryPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR: Could not modify " + factoryPath);
        }
    }

    private static boolean containsSezpozId(NodeList elements) {
        if (elements == null) {
            return false;
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            NamedNodeMap attributes = elements.item(i).getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr attribute = (Attr)attributes.item(j);
                if (!attribute.getName().equals("id") || attribute.getValue().indexOf("sezpoz") < 0) continue;
                return true;
            }
        }
        return false;
    }

    protected static Document readXMLFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        builder = builderFactory.newDocumentBuilder();
        return builder.parse(file);
    }

    public static void writeXMLFile(Document xml, File file) throws TransformerException {
        DOMSource source = new DOMSource(xml);
        StreamResult result = new StreamResult(file);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
    }

    protected static void fixAnnotationProcessingSettings(File directory) {
        File jdtSettings = new File(directory, ".settings/org.eclipse.jdt.apt.core.prefs");
        try {
            Properties properties = new Properties();
            if (jdtSettings.exists()) {
                properties.load(new FileInputStream(jdtSettings));
            }
            boolean changed = false;
            for (String pair : new String[]{"aptEnabled=true", "genSrcDir=target/classes", "reconcileEnabled=false"}) {
                int equals = pair.indexOf(61);
                String key = "org.eclipse.jdt.apt." + pair.substring(0, equals);
                String value = pair.substring(equals + 1);
                if (value.equals(properties.get(key))) continue;
                properties.put(key, value);
                changed = true;
            }
            if (changed) {
                properties.store(new FileOutputStream(jdtSettings), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR: Could not edit " + jdtSettings);
        }
    }

    protected static void write(File file, String contents) throws IOException, UnsupportedEncodingException {
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(contents.getBytes("UTF-8"));
        ((OutputStream)out).close();
    }
}

