/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.scijava.util.MiscUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static <T> T convert(Object value, Class<T> type) {
        if (value == null) {
            return ClassUtils.getNullValue(type);
        }
        Class<T> saneType = ClassUtils.getNonprimitiveType(type);
        if (ClassUtils.canCast(value, saneType)) {
            return ClassUtils.cast(value, saneType);
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.isEmpty()) {
                return ClassUtils.getNullValue(type);
            }
            if (saneType == Character.class) {
                Character c;
                Character result = c = new Character(s.charAt(0));
                return (T)result;
            }
        }
        if (saneType == String.class) {
            String sValue;
            String result = sValue = value.toString();
            return (T)result;
        }
        try {
            Constructor<T> ctor = saneType.getConstructor(value.getClass());
            return ctor.newInstance(value);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static boolean canConvert(Class<?> c, Class<?> type) {
        Class<?> saneType = ClassUtils.getNonprimitiveType(type);
        if (ClassUtils.canCast(c, saneType)) {
            return true;
        }
        if (saneType == String.class) {
            return true;
        }
        if (String.class.isAssignableFrom(c) && saneType == Character.class) {
            return true;
        }
        try {
            saneType.getConstructor(c);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean canConvert(Object value, Class<?> type) {
        if (value == null) {
            return true;
        }
        return ClassUtils.canConvert(value.getClass(), type);
    }

    public static <T> T cast(Object obj, Class<T> type) {
        if (!ClassUtils.canCast(obj, type)) {
            return null;
        }
        Object result = obj;
        return (T)result;
    }

    public static boolean canCast(Class<?> c, Class<?> type) {
        return type.isAssignableFrom(c);
    }

    public static boolean canCast(Object obj, Class<?> type) {
        return ClassUtils.canCast(obj.getClass(), type);
    }

    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T getNullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static Class<?> loadClass(String className) {
        return ClassUtils.loadClass(className, null);
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean hasClass(String className) {
        return ClassUtils.hasClass(className, null);
    }

    public static boolean hasClass(String className, ClassLoader classLoader) {
        return ClassUtils.loadClass(className, classLoader) != null;
    }

    public static URL getLocation(String className) {
        return ClassUtils.getLocation(className, null);
    }

    public static URL getLocation(String className, ClassLoader classLoader) {
        Class<?> c = ClassUtils.loadClass(className, classLoader);
        return ClassUtils.getLocation(c);
    }

    public static URL getLocation(Class<?> c) {
        String suffix;
        if (c == null) {
            return null;
        }
        try {
            URL codeSourceLocation = c.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return codeSourceLocation;
            }
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            return null;
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Class<?> c, Class<A> annotationClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtils.getAnnotatedFields(c, annotationClass, fields);
        return fields;
    }

    public static <A extends Annotation> void getAnnotatedFields(Class<?> c, Class<A> annotationClass, List<Field> fields) {
        if (c == null) {
            return;
        }
        ClassUtils.getAnnotatedFields(c.getSuperclass(), annotationClass, fields);
        for (Class<?> clazz : c.getInterfaces()) {
            ClassUtils.getAnnotatedFields(clazz, annotationClass, fields);
        }
        for (AnnotatedElement annotatedElement : c.getDeclaredFields()) {
            A ann = ((Field)annotatedElement).getAnnotation(annotationClass);
            if (ann == null) continue;
            fields.add((Field)annotatedElement);
        }
    }

    public static Field getField(String className, String fieldName) {
        return ClassUtils.getField(ClassUtils.loadClass(className), fieldName);
    }

    public static Field getField(Class<?> c, String fieldName) {
        if (c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Object getValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void setValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, ClassUtils.convert(value, field.getType()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No access to field: " + field.getName(), e);
        }
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.TYPE || Byte.class.isAssignableFrom(type);
    }

    public static boolean isCharacter(Class<?> type) {
        return type == Character.TYPE || Character.class.isAssignableFrom(type);
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || Double.class.isAssignableFrom(type);
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    public static boolean isInteger(Class<?> type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.TYPE || Long.class.isAssignableFrom(type);
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    public static boolean isText(Class<?> type) {
        return String.class.isAssignableFrom(type) || ClassUtils.isCharacter(type);
    }

    public static int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        String name1 = c1 == null ? null : c1.getName();
        String name2 = c2 == null ? null : c2.getName();
        return MiscUtils.compare(name1, name2);
    }
}

