/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML {
    private final Document doc;
    private final XPath xpath;

    public XML(File file) throws ParserConfigurationException, SAXException, IOException {
        this(XML.loadXML(file));
    }

    public XML(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        this(XML.loadXML(in));
    }

    public XML(String s) throws ParserConfigurationException, SAXException, IOException {
        this(XML.loadXML(s));
    }

    public XML(Document doc) {
        this.doc = doc;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public Document getDocument() {
        return this.doc;
    }

    public String cdata(String expression) {
        NodeList nodes = this.xpath(expression);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return XML.getCData(nodes.item(0));
    }

    public NodeList xpath(String expression) {
        Object result;
        try {
            result = this.xpath.evaluate(expression, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return (NodeList)result;
    }

    public String toString() {
        try {
            return XML.dumpXML(this.doc);
        }
        catch (TransformerException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            return out.toString();
        }
    }

    private static Document loadXML(File file) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(file.getAbsolutePath());
    }

    protected static Document loadXML(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(in);
    }

    protected static Document loadXML(String s) throws ParserConfigurationException, SAXException, IOException {
        return XML.createBuilder().parse(new ByteArrayInputStream(s.getBytes()));
    }

    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private static String getCData(Node item) {
        NodeList children = item.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    private static String dumpXML(Document doc) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }
}

