/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.scijava.Disposable;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginIndex;
import org.scijava.service.Service;
import org.scijava.service.ServiceHelper;
import org.scijava.service.ServiceIndex;
import org.scijava.util.CheckSezpoz;
import org.scijava.util.ClassUtils;

public class Context
implements Disposable {
    private static boolean sezpozNeedsToRun = true;
    private final ServiceIndex serviceIndex;
    private final PluginIndex pluginIndex;

    public Context() {
        this(false);
    }

    public Context(boolean empty) {
        this(empty ? Collections.emptyList() : Arrays.asList(Service.class));
    }

    public Context(Class ... serviceClasses) {
        this(serviceClasses != null ? Arrays.asList(serviceClasses) : Arrays.asList(Service.class));
    }

    public Context(Collection<Class<? extends Service>> serviceClasses) {
        this(serviceClasses, new PluginIndex());
    }

    public Context(PluginIndex pluginIndex) {
        this(Arrays.asList(Service.class), pluginIndex);
    }

    public Context(Collection<Class<? extends Service>> serviceClasses, PluginIndex pluginIndex) {
        if (sezpozNeedsToRun) {
            try {
                if (!CheckSezpoz.check(false)) {
                    System.err.println("SezPoz generated annotations.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sezpozNeedsToRun = false;
        }
        this.serviceIndex = new ServiceIndex();
        this.pluginIndex = pluginIndex;
        pluginIndex.discover();
        ServiceHelper serviceHelper = new ServiceHelper(this, serviceClasses);
        serviceHelper.loadServices();
    }

    public ServiceIndex getServiceIndex() {
        return this.serviceIndex;
    }

    public PluginIndex getPluginIndex() {
        return this.pluginIndex;
    }

    public <S extends Service> S getService(Class<S> c) {
        return this.serviceIndex.getService(c);
    }

    public Service getService(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = loader.loadClass(className);
            return this.getService(serviceClass);
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
    }

    public void inject(Object o) {
        List<Field> fields = ClassUtils.getAnnotatedFields(o.getClass(), Parameter.class);
        for (Field f : fields) {
            f.setAccessible(true);
            Class<?> type = f.getType();
            if (Service.class.isAssignableFrom(type)) {
                Service existingService = (Service)ClassUtils.getValue(f, o);
                if (existingService != null) {
                    throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
                }
                Class<?> serviceType = type;
                Object service = this.getService(serviceType);
                if (service == null && f.getAnnotation(Parameter.class).required()) {
                    throw new IllegalArgumentException("Required service is missing: " + serviceType.getName());
                }
                ClassUtils.setValue(f, o, service);
                continue;
            }
            if (!type.isAssignableFrom(this.getClass())) continue;
            Context existingContext = (Context)ClassUtils.getValue(f, o);
            if (existingContext != null) {
                throw new IllegalStateException("Context already injected: " + f.getDeclaringClass().getName() + "#" + f.getName());
            }
            ClassUtils.setValue(f, o, this);
        }
        EventService eventService = this.getService(EventService.class);
        if (eventService != null) {
            eventService.subscribe(o);
        }
    }

    @Override
    public void dispose() {
        List services = this.serviceIndex.getAll();
        for (int s = services.size() - 1; s >= 0; --s) {
            ((Service)services.get(s)).dispose();
        }
    }
}

