/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.thread;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public final class DefaultThreadService
extends AbstractService
implements ThreadService {
    @Parameter
    private LogService log;
    private ExecutorService executor;
    private int nextThread = 0;

    @Override
    public <V> Future<V> run(Callable<V> code) {
        return this.executor().submit(code);
    }

    @Override
    public Future<?> run(Runnable code) {
        return this.executor().submit(code);
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void invoke(Runnable code) throws InterruptedException, InvocationTargetException {
        if (this.isDispatchThread()) {
            code.run();
        } else {
            EventQueue.invokeAndWait(code);
        }
    }

    @Override
    public void queue(Runnable code) {
        EventQueue.invokeLater(code);
    }

    @Override
    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        String contextHash = Integer.toHexString(this.getContext().hashCode());
        String threadName = "SciJava-" + contextHash + "-Thread-" + this.nextThread++;
        return new Thread(r, threadName);
    }

    private ExecutorService executor() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool(this);
        }
        return this.executor;
    }
}

