/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import org.scijava.util.AbstractPrimitiveArray;
import org.scijava.util.ClassUtils;

public class ObjectArray<E>
extends AbstractPrimitiveArray<E[], E> {
    private E[] array;
    private Class<E> objectClass;

    public ObjectArray(Class<E> arrayType) {
        super(arrayType);
        this.objectClass = arrayType;
    }

    public ObjectArray(Class<E> arrayType, int size) {
        super(arrayType, size);
        this.objectClass = arrayType;
    }

    public ObjectArray(E[] array) {
        super(array.getClass().getComponentType(), array);
        this.objectClass = array.getClass().getComponentType();
    }

    public void addValue(E value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(E value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public E getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public E setValue(int index, E value) {
        this.checkBounds(index);
        E oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, E value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    @Override
    public E[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(E[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public E get(int index) {
        return this.getValue(index);
    }

    @Override
    public E set(int index, E element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, E element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!this.compatibleClass(o)) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!this.compatibleClass(o)) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        if (!this.compatibleClass(o)) {
            return false;
        }
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean remove(Object o) {
        if (!this.compatibleClass(o)) {
            return false;
        }
        E value = ClassUtils.cast(o, this.objectClass);
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.compatibleClass(o)) {
                return false;
            }
            if (this.indexOf(o) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        for (E e : c) {
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            E value;
            boolean result;
            if (!this.compatibleClass(o) || !(result = this.removeValue(value = ClassUtils.cast(o, this.objectClass)))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public E defaultValue() {
        return null;
    }

    private boolean compatibleClass(Object o) {
        return o != null && this.objectClass.isAssignableFrom(o.getClass());
    }
}

