/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ReadInto
extends Thread {
    protected BufferedReader reader;
    protected PrintStream out;
    protected StringBuilder buffer = new StringBuilder();
    protected boolean done;
    protected boolean closeOnEOF;

    public ReadInto(InputStream in, PrintStream out) {
        this(in, out, false);
    }

    public ReadInto(InputStream in, PrintStream out, boolean closeOnEOF) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.out = out;
        this.closeOnEOF = closeOnEOF;
        if (out == null && closeOnEOF) {
            throw new IllegalArgumentException("Cannot close null output");
        }
        this.start();
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (this.out != null) {
                    this.out.println(line);
                } else {
                    this.buffer.append(line).append("\n");
                }
                if (!this.done) {
                    Thread.sleep(0L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.closeOnEOF) {
            this.out.close();
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void interrupt() {
        try {
            this.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.interrupt();
    }

    public void done() throws IOException {
        if (this.done) {
            return;
        }
        this.done = true;
        this.reader.close();
    }

    @Override
    public String toString() {
        if (this.out != null) {
            return "ReadInto " + this.out;
        }
        return this.buffer.toString();
    }
}

