/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.scijava.util.Sizable;

public class SizableArrayList<E>
extends ArrayList<E>
implements Sizable {
    private static final long serialVersionUID = 1L;

    public SizableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SizableArrayList() {
    }

    public SizableArrayList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public void setSize(int size) {
        int oldSize = this.size();
        if (oldSize == size) {
            return;
        }
        if (size < oldSize) {
            this.removeRange(size, oldSize);
        } else {
            this.ensureCapacity(size);
            try {
                Field sizeField = ArrayList.class.getDeclaredField("size");
                sizeField.setAccessible(true);
                sizeField.set(this, size);
            }
            catch (NoSuchFieldException exc) {
                throw new IllegalStateException(exc);
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalStateException(exc);
            }
            catch (IllegalAccessException exc) {
                throw new IllegalStateException(exc);
            }
        }
    }
}

