/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.HashMap;
import java.util.List;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginFinder;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class DefaultPluginFinder
implements PluginFinder {
    private final ClassLoader customClassLoader;

    public DefaultPluginFinder() {
        this(null);
    }

    public DefaultPluginFinder(ClassLoader classLoader) {
        this.customClassLoader = classLoader;
    }

    public HashMap<String, Throwable> findPlugins(List<PluginInfo<?>> plugins) {
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        ClassLoader classLoader = this.getClassLoader();
        Index sezPozIndex = Index.load(Plugin.class, SciJavaPlugin.class, (ClassLoader)classLoader);
        for (IndexItem item : sezPozIndex) {
            try {
                PluginInfo<SciJavaPlugin> info = this.createInfo((IndexItem<Plugin, SciJavaPlugin>)item, classLoader);
                plugins.add(info);
            }
            catch (Throwable t) {
                exceptions.put(item.className(), t);
            }
        }
        return exceptions;
    }

    private PluginInfo<SciJavaPlugin> createInfo(IndexItem<Plugin, SciJavaPlugin> item, ClassLoader classLoader) {
        String className = item.className();
        Plugin plugin = (Plugin)item.annotation();
        Class<? extends SciJavaPlugin> pluginType = plugin.type();
        return new PluginInfo<SciJavaPlugin>(className, pluginType, plugin, classLoader);
    }

    private ClassLoader getClassLoader() {
        if (this.customClassLoader != null) {
            return this.customClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

