/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.scijava.util.AppUtils;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.XML;
import org.xml.sax.SAXException;

public class POM
extends XML {
    public POM(File file) throws ParserConfigurationException, SAXException, IOException {
        super(file);
    }

    public POM(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        super(in);
    }

    public POM(String s) throws ParserConfigurationException, SAXException, IOException {
        super(s);
    }

    public String getGroupId() {
        String groupId = this.cdata("//project/groupId");
        if (groupId != null) {
            return groupId;
        }
        return this.cdata("//project/parent/groupId");
    }

    public String getArtifactId() {
        return this.cdata("//project/artifactId");
    }

    public String getVersion() {
        String version = this.cdata("//project/version");
        if (version != null) {
            return version;
        }
        return this.cdata("//project/parent/version");
    }

    public static POM getPOM(Class<?> c, String groupId, String artifactId) {
        try {
            URL location = ClassUtils.getLocation(c);
            if (!location.getProtocol().equals("file") || location.toString().endsWith(".jar")) {
                String pomPath = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml";
                URL pomURL = new URL("jar:" + location.toString() + "!/" + pomPath);
                InputStream pomStream = pomURL.openStream();
                return new POM(pomStream);
            }
            File file = FileUtils.urlToFile(location);
            File baseDir = AppUtils.getBaseDirectory(file, null);
            File pomFile = new File(baseDir, "pom.xml");
            return new POM(pomFile);
        }
        catch (IOException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }
}

