/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.input;

import java.util.regex.Pattern;
import org.scijava.input.InputModifiers;
import org.scijava.input.KeyCode;

public class Accelerator {
    private final KeyCode keyCode;
    private final InputModifiers modifiers;

    public Accelerator(KeyCode keyCode, InputModifiers modifiers) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
    }

    public KeyCode getKeyCode() {
        return this.keyCode;
    }

    public InputModifiers getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Accelerator)) {
            return false;
        }
        Accelerator acc = (Accelerator)o;
        if (!this.getModifiers().equals(acc.getModifiers())) {
            return false;
        }
        return this.getKeyCode().equals((Object)acc.getKeyCode());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String modString = this.modifiers.toString();
        String keyString = this.keyCode.name();
        if (modString.length() == 0) {
            return keyString;
        }
        return modString + " " + keyString;
    }

    public static Accelerator create(String acc) {
        if (acc == null || acc.isEmpty()) {
            return null;
        }
        String a = acc.replaceAll(Pattern.quote("^"), "control ");
        String[] components = a.split(" ");
        boolean alt = false;
        boolean altGr = false;
        boolean ctrl = false;
        boolean meta = false;
        boolean shift = false;
        for (int i = 0; i < components.length - 1; ++i) {
            if (components[i].equalsIgnoreCase("alt")) {
                alt = true;
                continue;
            }
            if (components[i].equalsIgnoreCase("altGr") || components[i].equalsIgnoreCase("altGraph")) {
                altGr = true;
                continue;
            }
            if (components[i].equalsIgnoreCase("control") || components[i].equalsIgnoreCase("ctrl")) {
                ctrl = true;
                continue;
            }
            if (components[i].equalsIgnoreCase("meta")) {
                meta = true;
                continue;
            }
            if (!components[i].equalsIgnoreCase("shift")) continue;
            shift = true;
        }
        if (ctrl && !meta && Accelerator.isCtrlReplacedWithMeta()) {
            ctrl = false;
            meta = true;
        }
        InputModifiers modifiers = new InputModifiers(alt, altGr, ctrl, meta, shift, false, false, false);
        String code = components[components.length - 1].toUpperCase();
        KeyCode keyCode = KeyCode.get(code);
        return new Accelerator(keyCode, modifiers);
    }

    public static boolean isCtrlReplacedWithMeta() {
        return System.getProperty("os.name").startsWith("Mac");
    }
}

