/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.java.sezpoz.impl.SerAnnotatedElement;

public class CombineAnnotations {
    private static final String PREFIX = "META-INF/annotations";
    private static final String OUTPUT_DIR = "src/main/assembly/all";
    private final Set<String> annotationFiles = this.getAnnotationFiles();

    public void combine() throws IOException, ClassNotFoundException {
        HashSet<SerAnnotatedElement> annotations = new HashSet<SerAnnotatedElement>();
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        this.log("");
        this.log("Writing annotations to " + new File(OUTPUT_DIR).getAbsolutePath());
        new File(OUTPUT_DIR, PREFIX).mkdirs();
        for (String annotationFile : this.annotationFiles) {
            annotations.clear();
            Enumeration<URL> resources = loader.getResources(annotationFile);
            while (resources.hasMoreElements()) {
                SerAnnotatedElement el;
                URL resource = resources.nextElement();
                ObjectInputStream ois = new ObjectInputStream(resource.openStream());
                while ((el = (SerAnnotatedElement)ois.readObject()) != null) {
                    annotations.add(el);
                }
                ois.close();
            }
            File outputFile = new File(OUTPUT_DIR, annotationFile);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outputFile));
            for (SerAnnotatedElement el : annotations) {
                oos.writeObject(el);
            }
            oos.writeObject(null);
            oos.close();
            this.log(outputFile.getName() + ": " + annotations.size() + " items");
        }
    }

    public Set<String> getAnnotationFiles() throws IOException {
        String[] pathItems;
        HashSet<String> files = new HashSet<String>();
        String classpath = System.getProperty("java.class.path");
        for (String pathItem : pathItems = classpath.split(File.pathSeparator)) {
            File[] annItems;
            this.log("Scanning " + pathItem);
            if (pathItem.toLowerCase().endsWith(".jar")) {
                ZipEntry zipEntry;
                ZipInputStream zis = new ZipInputStream(new FileInputStream(pathItem));
                while ((zipEntry = zis.getNextEntry()) != null) {
                    String name = zipEntry.getName();
                    if (!name.matches(Pattern.quote("META-INF/annotations/") + ".+")) continue;
                    this.add(files, name);
                }
                zis.close();
                continue;
            }
            File annDir = new File(pathItem + "/" + PREFIX);
            if (!annDir.exists() || !annDir.isDirectory()) continue;
            for (File annItem : annItems = annDir.listFiles()) {
                this.add(files, "META-INF/annotations/" + annItem.getName());
            }
        }
        return files;
    }

    public static void main(String[] args) throws Exception {
        new CombineAnnotations().combine();
    }

    private void add(HashSet<String> set, String item) {
        this.log("\t" + item);
        set.add(item);
    }

    private void log(String msg) {
        System.out.println(msg);
    }
}

