/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.scijava.object.LazyObjects;
import org.scijava.util.ClassUtils;

public class ObjectIndex<E>
implements Collection<E> {
    protected final Map<Class<?>, List<E>> hoard = new ConcurrentHashMap();
    private final Class<E> baseClass;
    private final List<LazyObjects<? extends E>> pending = new LinkedList<LazyObjects<? extends E>>();
    private Map<Class<?>, List<E>[]> type2Lists = new HashMap();
    private static Map<Class<?>, Class<?>[]> typeMap = new HashMap();

    public ObjectIndex(Class<E> baseClass) {
        this.baseClass = baseClass;
    }

    public Class<E> getBaseClass() {
        return this.baseClass;
    }

    public List<E> getAll() {
        return this.get(All.class);
    }

    public List<E> get(Class<?> type) {
        if (!this.pending.isEmpty()) {
            this.resolvePending();
        }
        List<E> list = this.retrieveList(type);
        list = new ArrayList<E>(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLater(LazyObjects<? extends E> c) {
        List<LazyObjects<? extends E>> list = this.pending;
        synchronized (list) {
            this.pending.add(c);
        }
    }

    @Override
    public int size() {
        return this.getAll().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getAll().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.getBaseClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Object typedObj = o;
        Class<?> type = this.getType(typedObj);
        return this.get(type).contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.add(o, false);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, false);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getAll().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E o : c) {
            boolean result = this.add(o, true);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            boolean result = this.remove(o, true);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.hoard.clear();
    }

    public String toString() {
        ArrayList classes = new ArrayList(this.hoard.keySet());
        Collections.sort(classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return ClassUtils.compare(c1, c2);
            }
        });
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName() + ": {");
            List<E> list = this.hoard.get(clazz);
            boolean first = true;
            for (E element : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(element);
            }
            sb.append("}" + nl);
        }
        return sb.toString();
    }

    protected boolean add(E o, boolean batch) {
        return this.add(o, this.getType(o), batch);
    }

    protected Class<?> getType(E o) {
        return o.getClass();
    }

    protected boolean remove(Object o, boolean batch) {
        if (!this.getBaseClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Object e = o;
        return this.remove(o, this.getType(e), batch);
    }

    protected synchronized List<E>[] retrieveListsForType(Class<?> type) {
        List[] arrayOfRawLists;
        List<E>[] lists = this.type2Lists.get(type);
        if (lists != null) {
            return lists;
        }
        ArrayList<List<E>> listOfLists = new ArrayList<List<E>>();
        for (Class<?> c : ObjectIndex.getTypes(type)) {
            listOfLists.add(this.retrieveList(c));
        }
        List[] arrayOfLists = arrayOfRawLists = listOfLists.toArray(new List[listOfLists.size()]);
        this.type2Lists.put(type, arrayOfLists);
        return arrayOfLists;
    }

    protected boolean add(E o, Class<?> type, boolean batch) {
        boolean result = false;
        for (List<E> list : this.retrieveListsForType(type)) {
            if (!this.addToList(o, list, batch)) continue;
            result = true;
        }
        return result;
    }

    protected boolean remove(Object o, Class<?> type, boolean batch) {
        boolean result = false;
        for (List<E> list : this.retrieveListsForType(type)) {
            if (!this.removeFromList(o, list, batch)) continue;
            result = true;
        }
        return result;
    }

    protected boolean addToList(E obj, List<E> list, boolean batch) {
        return list.add(obj);
    }

    protected boolean removeFromList(Object obj, List<E> list, boolean batch) {
        return list.remove(obj);
    }

    protected static synchronized Class<?>[] getTypes(Class<?> type) {
        Class<?>[] types = typeMap.get(type);
        if (types != null) {
            return types;
        }
        LinkedHashSet set = new LinkedHashSet();
        set.add(All.class);
        ObjectIndex.getTypes(type, set);
        types = set.toArray(new Class[set.size()]);
        typeMap.put(type, types);
        return types;
    }

    private static synchronized void getTypes(Class<?> type, Set<Class<?>> types) {
        if (type == null) {
            return;
        }
        types.add(type);
        ObjectIndex.getTypes(type.getSuperclass(), types);
        for (Class<?> iface : type.getInterfaces()) {
            ObjectIndex.getTypes(iface, types);
        }
    }

    protected List<E> retrieveList(Class<?> type) {
        List<E> list = this.hoard.get(type);
        if (list == null) {
            list = new ArrayList();
            this.hoard.put(type, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolvePending() {
        List<LazyObjects<? extends E>> list = this.pending;
        synchronized (list) {
            while (!this.pending.isEmpty()) {
                LazyObjects<E> c = this.pending.remove(0);
                this.addAll(c.get());
            }
        }
    }

    private static class All {
        private All() {
        }
    }
}

