/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.scijava.util.ReadInto;

public final class ProcessUtils {
    private ProcessUtils() {
    }

    public static String exec(File workingDirectory, PrintStream err, PrintStream out, String ... args) {
        return ProcessUtils.exec(workingDirectory, null, err, out, args);
    }

    public static String exec(File workingDirectory, InputStream in, PrintStream err, PrintStream out, String ... args) {
        try {
            ReadInto inThread;
            Process process = Runtime.getRuntime().exec(args, null, workingDirectory);
            if (in == null) {
                inThread = null;
                process.getOutputStream().close();
            } else {
                PrintStream print = new PrintStream(process.getOutputStream());
                inThread = new ReadInto(in, print, true);
            }
            ReadInto errThread = new ReadInto(process.getErrorStream(), err);
            ReadInto outThread = new ReadInto(process.getInputStream(), out);
            try {
                process.waitFor();
                if (inThread != null) {
                    inThread.done();
                    inThread.join();
                }
                errThread.join();
                outThread.join();
            }
            catch (InterruptedException e) {
                process.destroy();
                if (inThread != null) {
                    inThread.interrupt();
                }
                errThread.done();
                errThread.interrupt();
                outThread.done();
                outThread.interrupt();
                err.println("Interrupted!");
                throw new RuntimeException(e);
            }
            if (process.exitValue() != 0) {
                throw new RuntimeException("exit status " + process.exitValue() + ": " + Arrays.toString(args) + "\n" + err);
            }
            return outThread.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

