/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.scijava.annotations.IndexReader;

public abstract class AbstractIndexWriter {
    private final Map<String, Map<String, Object>> map = new TreeMap<String, Map<String, Object>>();

    protected synchronized void add(Map<String, Object> annotationValues, String annotationName, String className) {
        Map<String, Object> list = this.map.get(annotationName);
        if (list == null) {
            list = new LinkedHashMap<String, Object>();
            this.map.put(annotationName, list);
        }
        TreeMap<String, Object> o = new TreeMap<String, Object>();
        o.put("class", className);
        o.put("values", annotationValues);
        list.put(className, o);
    }

    protected synchronized void write(StreamFactory factory) throws IOException {
        for (Map.Entry<String, Map<String, Object>> entry : this.map.entrySet()) {
            String annotationName = entry.getKey();
            this.merge(annotationName, factory);
            PrintStream out = new PrintStream(factory.openOutput(annotationName));
            for (Object o : entry.getValue().values()) {
                this.writeObject(out, this.adapt(o));
            }
            out.close();
        }
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void merge(String annotationName, StreamFactory factory) throws IOException {
        InputStream in = factory.openInput(annotationName);
        if (in == null) {
            return;
        }
        Map<String, Object> map = this.map.get(annotationName);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.map.put(annotationName, map);
        }
        int changedCount = map.size();
        boolean hasObsoletes = false;
        IndexReader reader = new IndexReader(in);
        try {
            Map entry;
            while ((entry = (Map)reader.next()) != null) {
                String className = (String)entry.get("class");
                if (factory.isClassObsolete(className)) {
                    hasObsoletes = true;
                    continue;
                }
                if (map.containsKey(className)) {
                    if (hasObsoletes || !entry.equals(map.get(className))) continue;
                    --changedCount;
                    continue;
                }
                map.put(className, entry);
            }
        }
        finally {
            reader.close();
        }
        if (changedCount == 0 && !hasObsoletes) {
            this.map.remove(annotationName);
        }
    }

    protected Object adapt(Object o) {
        if (o instanceof Annotation) {
            return this.adapt((Annotation)o);
        }
        if (o instanceof Enum) {
            return AbstractIndexWriter.adapt((Enum)o);
        }
        return o;
    }

    protected <A extends Annotation> Map<String, Object> adapt(A annotation) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Method method : annotation.annotationType().getMethods()) {
            try {
                if (method.getDeclaringClass() != annotation.annotationType()) continue;
                result.put(method.getName(), this.adapt(method.invoke(annotation, new Object[0])));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Map<String, Object> adapt(Enum<?> e) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("enum", e.getClass().getName());
        result.put("value", e.name());
        return result;
    }

    private void writeObject(PrintStream out, Object o) throws IOException {
        if (o == null) {
            out.print("null");
        } else if (o instanceof Boolean) {
            out.print((Boolean)o != false ? "true" : "false");
        } else if (o instanceof Byte) {
            out.print(((Byte)o).byteValue());
        } else if (o instanceof Short) {
            out.print(((Short)o).shortValue());
        } else if (o instanceof Integer) {
            out.print((Integer)o);
        } else if (o instanceof Long) {
            out.print((Long)o);
        } else if (o instanceof Float) {
            out.print(((Float)o).floatValue());
        } else if (o instanceof Double) {
            out.print((Double)o);
        } else if (o instanceof Character) {
            Character c = (Character)o;
            this.writeString(out, "" + c.charValue());
        } else if (o instanceof String) {
            this.writeString(out, (String)o);
        } else if (o instanceof Class) {
            this.writeString(out, ((Class)o).getName());
        } else if (o instanceof List) {
            this.writeArray(out, (List)o);
        } else if (o.getClass().isArray()) {
            this.writeArray(out, o);
        } else if (o instanceof Map) {
            this.writeMap(out, (Map)o);
        } else {
            throw new IOException("Cannot handle object of type " + o.getClass());
        }
    }

    protected void writeMap(PrintStream out, Object ... pairs) throws IOException {
        if (pairs.length % 2 != 0) {
            throw new IOException("Key without value!");
        }
        out.write(123);
        for (int i = 0; i < pairs.length; i += 2) {
            if (i > 0) {
                out.write(44);
            }
            this.writeString(out, (String)pairs[i]);
            out.write(58);
            this.writeObject(out, pairs[i + 1]);
        }
        out.write(125);
    }

    private void writeMap(PrintStream out, Map<?, ?> map) throws IOException {
        out.write(123);
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            this.writeString(out, entry.getKey().toString());
            out.write(58);
            this.writeObject(out, entry.getValue());
        }
        out.write(125);
    }

    private void writeArray(PrintStream out, List<?> list) throws IOException {
        out.write(91);
        boolean first = true;
        for (Object o : list) {
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            o = this.adapt(o);
            this.writeObject(out, o);
        }
        out.write(93);
    }

    private void writeArray(PrintStream out, Object o) throws IOException {
        out.write(91);
        int length = Array.getLength(o);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                out.write(44);
            }
            this.writeObject(out, this.adapt(Array.get(o, i)));
        }
        out.write(93);
    }

    private void writeString(PrintStream out, String string) {
        out.write(34);
        for (char c : string.toCharArray()) {
            if (c == '\"' || c == '\\') {
                out.write(92);
                out.write(c);
                continue;
            }
            if (c >= ' ' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            String hex = Integer.toHexString(c);
            out.print("\\u");
            if (hex.length() < 4) {
                out.print("0000".substring(hex.length()));
            }
            out.print(hex);
        }
        out.write(34);
    }

    public static interface StreamFactory {
        public InputStream openInput(String var1) throws IOException;

        public OutputStream openOutput(String var1) throws IOException;

        public boolean isClassObsolete(String var1);
    }
}

