/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scijava.log.LogService;
import org.scijava.object.LazyObjects;
import org.scijava.object.ObjectService;
import org.scijava.plugin.AbstractPTService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.plugin.SingletonService;

public abstract class AbstractSingletonService<PT extends SingletonPlugin>
extends AbstractPTService<PT>
implements SingletonService<PT> {
    @Parameter
    private LogService log;
    @Parameter
    private ObjectService objectService;
    private List<PT> instances;

    @Override
    public List<PT> getInstances() {
        if (this.instances == null) {
            this.createInstances();
        }
        return this.instances;
    }

    @Override
    public <P extends PT> P getInstance(Class<P> pluginClass) {
        List<P> objects = this.objectService.getObjects(pluginClass);
        return (P)(objects == null || objects.isEmpty() ? null : (SingletonPlugin)objects.get(0));
    }

    @Override
    public void initialize() {
        this.objectService.getIndex().addLater(new LazyObjects<Object>(){

            @Override
            public ArrayList<Object> get() {
                return new ArrayList<Object>(AbstractSingletonService.this.getInstances());
            }
        });
    }

    private void createInstances() {
        this.instances = Collections.unmodifiableList(this.filterInstances(this.getPluginService().createInstancesOfType(this.getPluginType())));
        this.log.info("Found " + this.instances.size() + " " + this.getPluginType().getSimpleName() + " plugins.");
        for (SingletonPlugin instance : this.instances) {
            this.objectService.addObject(instance);
        }
    }

    protected List<? extends PT> filterInstances(List<PT> list) {
        return list;
    }
}

