/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.util.Iterator;
import org.scijava.display.AbstractDisplay;
import org.scijava.display.Display;
import org.scijava.plugin.Plugin;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.DoubleColumn;
import org.scijava.table.DoubleTable;
import org.scijava.table.GenericTable;
import org.scijava.table.Table;
import org.scijava.table.TableDisplay;

@Plugin(type=Display.class)
public class DefaultTableDisplay
extends AbstractDisplay<Table<?, ?>>
implements TableDisplay {
    public DefaultTableDisplay() {
        super(Table.class);
    }

    public boolean canDisplay(Class<?> c) {
        if (c == double[].class || c == double[][].class) {
            return true;
        }
        return super.canDisplay(c);
    }

    public void display(Object o) {
        if (o instanceof double[]) {
            this.display(this.wrapArrayAsTable(new double[][]{(double[])o}));
            return;
        }
        if (o instanceof double[][]) {
            this.display(this.wrapArrayAsTable((double[][])o));
            return;
        }
        super.display(o);
    }

    public boolean isDisplaying(Object o) {
        if (super.isDisplaying(o)) {
            return true;
        }
        if (o instanceof double[]) {
            this.arrayEqualsTable(new double[][]{(double[])o});
        }
        if (o instanceof double[][]) {
            this.arrayEqualsTable((double[][])o);
        }
        return false;
    }

    private GenericTable wrapArrayAsTable(double[][] array) {
        DefaultGenericTable table = new DefaultGenericTable();
        int rowCount = 0;
        for (int d = 0; d < array.length; ++d) {
            DoubleColumn column = new DoubleColumn();
            column.setArray(array[d]);
            table.add(column);
            if (rowCount >= array[d].length) continue;
            rowCount = array[d].length;
        }
        table.setRowCount(rowCount);
        return table;
    }

    private boolean arrayEqualsTable(double[][] array) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DoubleTable resultsTable;
            Table table = (Table)iterator.next();
            if (!(table instanceof DoubleTable) || array.length != (resultsTable = (DoubleTable)table).getColumnCount()) continue;
            boolean equal = true;
            for (int c = 0; c < array.length; ++c) {
                if (array[c] == ((DoubleColumn)resultsTable.get(c)).getArray()) continue;
                equal = false;
                break;
            }
            return equal;
        }
        return false;
    }
}

