/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.scijava.table.Column;
import org.scijava.table.Table;

public final class Tables {
    private Tables() {
    }

    public static <T> Table<Column<T>, T> wrap(final List<? extends Map<?, T>> data, final List<String> rowHeaders) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Cannot wrap an empty list");
        }
        return new ReadOnlyTable<T>(){

            @Override
            public int getRowCount() {
                return data.size();
            }

            @Override
            public String getRowHeader(int row) {
                if (rowHeaders == null || rowHeaders.size() < row) {
                    return null;
                }
                return (String)rowHeaders.get(row);
            }

            @Override
            public int size() {
                return ((Map)data.get(0)).size();
            }

            @Override
            public Column<T> get(final int col) {
                class ColumnAccessor
                implements ReadOnlyColumn<T> {
                    private final Object tableData;
                    private boolean initialized;
                    private String colHeader;

                    ColumnAccessor() {
                        this.tableData = data;
                    }

                    @Override
                    public String getHeader() {
                        if (!this.initialized) {
                            int c = 0;
                            for (Object key : ((Map)data.get(0)).keySet()) {
                                if (col != c++) continue;
                                this.colHeader = key == null ? null : key.toString();
                                break;
                            }
                            this.initialized = true;
                        }
                        return this.colHeader;
                    }

                    @Override
                    public int size() {
                        return data.size();
                    }

                    @Override
                    public Class<T> getType() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public T get(int index) {
                        return ((Map)data.get(index)).get(this.getHeader());
                    }

                    @Override
                    public int hashCode() {
                        return this.getHeader().hashCode();
                    }

                    @Override
                    public boolean equals(Object obj) {
                        if (!(obj instanceof ColumnAccessor)) {
                            return false;
                        }
                        ColumnAccessor other = (ColumnAccessor)obj;
                        if (data != other.tableData) {
                            return false;
                        }
                        return Objects.equals(this.getHeader(), other.getHeader());
                    }
                }
                return new ColumnAccessor();
            }
        };
    }

    static int colIndex(Table<?, ?> table, String colHeader) {
        int colIndex = table.getColumnIndex(colHeader);
        if (colIndex < 0) {
            throw new IllegalArgumentException("No such column: " + colHeader);
        }
        return colIndex;
    }

    static void checkCol(Table<?, ?> table, int col, int count) {
        Tables.check("column", col, count, table.getColumnCount());
    }

    static void checkRow(Table<?, ?> table, int row, int count) {
        Tables.check("row", row, count, table.getRowCount());
    }

    static <U> void assign(Column<U> column, int row, Object value) {
        if (value != null && !column.getType().isInstance(value)) {
            throw new IllegalArgumentException("value of type " + value.getClass() + " is not a " + column.getType());
        }
        Object typedValue = value;
        column.set(row, typedValue);
    }

    private static void check(String name, int index, int count, int bound) {
        int last = index + count - 1;
        if (index >= 0 && last < bound) {
            return;
        }
        if (count <= 1) {
            throw new IndexOutOfBoundsException("Invalid " + name + ": " + index);
        }
        throw new IndexOutOfBoundsException("Invalid " + name + "s: " + index + " - " + last);
    }

    private static UnsupportedOperationException readOnlyException() {
        return new UnsupportedOperationException("Wrapped table is read-only");
    }

    private static interface ReadOnlyColumn<T>
    extends Column<T> {
        @Override
        default public boolean add(T e) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean remove(Object o) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean addAll(Collection<? extends T> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean addAll(int index, Collection<? extends T> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void clear() {
            throw Tables.readOnlyException();
        }

        @Override
        default public T set(int index, T element) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void add(int index, T element) {
            throw Tables.readOnlyException();
        }

        @Override
        default public T remove(int index) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void setHeader(String header) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void setSize(int size) {
            throw Tables.readOnlyException();
        }
    }

    private static interface ReadOnlyTable<T>
    extends Table<Column<T>, T> {
        @Override
        default public void setColumnCount(int colCount) {
            throw Tables.readOnlyException();
        }

        @Override
        default public List<Column<T>> insertColumns(int col, int count) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void setRowCount(int rowCount) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void removeRows(int row, int count) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void setRowHeader(int row, String header) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void set(String colHeader, int row, T value) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean add(Column<T> column) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean remove(Object column) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean addAll(Collection<? extends Column<T>> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean addAll(int col, Collection<? extends Column<T>> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean removeAll(Collection<?> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public boolean retainAll(Collection<?> c) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void clear() {
            throw Tables.readOnlyException();
        }

        @Override
        default public Column<T> set(int col, Column<T> column) {
            throw Tables.readOnlyException();
        }

        @Override
        default public void add(int col, Column<T> column) {
            throw Tables.readOnlyException();
        }

        @Override
        default public Column<T> remove(int col) {
            throw Tables.readOnlyException();
        }
    }
}

