/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.io;

import java.io.IOException;
import org.scijava.io.IOPlugin;
import org.scijava.io.IOService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.table.Table;
import org.scijava.table.io.TableIOService;

@Plugin(type=Service.class)
public class DefaultTableIOService
extends AbstractService
implements TableIOService {
    @Parameter
    private IOService ioService;

    @Override
    public boolean canOpen(String source) {
        IOPlugin opener = this.ioService.getOpener(source);
        if (opener == null) {
            return false;
        }
        return Table.class.isAssignableFrom(opener.getDataType());
    }

    @Override
    public boolean canSave(Table<?, ?> table, String destination) {
        IOPlugin saver = this.ioService.getSaver(table, destination);
        if (saver == null) {
            return false;
        }
        return saver.supportsSave(destination);
    }

    @Override
    public Table<?, ?> open(String source) throws IOException {
        IOPlugin opener = this.ioService.getOpener(source);
        if (opener != null && Table.class.isAssignableFrom(opener.getDataType())) {
            return (Table)opener.open(source);
        }
        throw new UnsupportedOperationException("No compatible opener found.");
    }

    @Override
    public void save(Table<?, ?> table, String destination) throws IOException {
        IOPlugin saver = this.ioService.getSaver(table, destination);
        if (saver == null) {
            throw new UnsupportedOperationException("No compatible saver found.");
        }
        saver.save(table, destination);
    }
}

