/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.io;

import java.io.File;
import java.io.IOException;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.Table;
import org.scijava.table.TableDisplay;
import org.scijava.table.io.TableIOService;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Export"), @Menu(label="Table...")})
public class ExportTableCommand
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private TableDisplay tableDisplay;
    @Parameter
    private TableIOService tableIO;
    @Parameter
    private UIService uiService;
    @Parameter(label="File to save", style="save", persist=false)
    private File outputFile;

    public void run() {
        try {
            this.tableIO.save((Table)this.tableDisplay.get(0), this.outputFile.getAbsolutePath());
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.uiService.showDialog(exc.getMessage(), "Error Saving Table");
            return;
        }
    }
}

