/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.io;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.scijava.optional.AbstractOptions;
import org.scijava.table.io.ColumnTableIOOptions;

public class TableIOOptions
extends AbstractOptions<TableIOOptions> {
    public final Values values = new Values();
    private final Map<Integer, ColumnTableIOOptions> columnOptions = new HashMap<Integer, ColumnTableIOOptions>();
    private static final String readColHeadersKey = "readColHeaders";
    private static final String columnOptionsKey = "columnOptions";
    private static final String writeColHeadersKey = "writeColHeaders";
    private static final String readRowHeadersKey = "readRowHeaders";
    private static final String writeRowHeadersKey = "writeRowHeaders";
    private static final String columnDelimiterKey = "columnDelimiter";
    private static final String rowDelimiterKey = "rowDelimiter";
    private static final String quoteKey = "quote";
    private static final String cornerTextKey = "cornerText";
    private static final String guessParserKey = "guessParser";
    private static final String parserKey = "parser";
    private static final String formatterKey = "formatter";

    public TableIOOptions() {
        this.setValue(columnOptionsKey, this.columnOptions);
    }

    public static TableIOOptions options() {
        return new TableIOOptions();
    }

    public TableIOOptions readColumnHeaders(boolean readColHeaders) {
        return (TableIOOptions)this.setValue(readColHeadersKey, readColHeaders);
    }

    public TableIOOptions writeColumnHeaders(boolean writeColHeaders) {
        return (TableIOOptions)this.setValue(writeColHeadersKey, writeColHeaders);
    }

    public TableIOOptions readRowHeaders(boolean readRowHeaders) {
        return (TableIOOptions)this.setValue(readRowHeadersKey, readRowHeaders);
    }

    public TableIOOptions writeRowHeaders(boolean writeRowHeaders) {
        return (TableIOOptions)this.setValue(writeRowHeadersKey, writeRowHeaders);
    }

    public TableIOOptions columnDelimiter(char columnDelimiter) {
        return (TableIOOptions)this.setValue(columnDelimiterKey, Character.valueOf(columnDelimiter));
    }

    public TableIOOptions rowDelimiter(String rowDelimiter) {
        return (TableIOOptions)this.setValue(rowDelimiterKey, rowDelimiter);
    }

    public TableIOOptions quote(char quote) {
        return (TableIOOptions)this.setValue(quoteKey, Character.valueOf(quote));
    }

    public TableIOOptions cornerText(String cornerText) {
        return (TableIOOptions)this.setValue(cornerTextKey, cornerText);
    }

    public TableIOOptions guessParser(boolean guessParser) {
        return (TableIOOptions)this.setValue(guessParserKey, guessParser);
    }

    public TableIOOptions parser(Function<String, ?> parser) {
        this.guessParser(false);
        return (TableIOOptions)this.setValue(parserKey, parser);
    }

    public TableIOOptions formatter(Function<Object, String> formatter) {
        return (TableIOOptions)this.setValue(formatterKey, formatter);
    }

    public TableIOOptions type(Class<?> type) {
        return this.parser(this.getParser(type));
    }

    public TableIOOptions columnType(int column, Class<?> type) {
        ColumnTableIOOptions options = new ColumnTableIOOptions();
        this.columnOptions.putIfAbsent(column, options);
        options.formatter(String::valueOf).parser(this.getParser(type));
        return (TableIOOptions)this.setValue(columnOptionsKey, this.columnOptions);
    }

    public TableIOOptions columnParser(int column, Function<String, Object> parser) {
        this.columnOptions.putIfAbsent(column, new ColumnTableIOOptions());
        this.columnOptions.get(column).parser(parser);
        return this;
    }

    public TableIOOptions columnFormatter(int column, Function<Object, String> formatter) {
        this.columnOptions.putIfAbsent(column, new ColumnTableIOOptions());
        this.columnOptions.get(column).formatter(formatter);
        return this;
    }

    private Function<String, ?> getParser(Class<?> type) {
        if (type.equals(String.class)) {
            return String::valueOf;
        }
        if (type.equals(Double.class)) {
            return Double::valueOf;
        }
        if (type.equals(Float.class)) {
            return Float::valueOf;
        }
        if (type.equals(Integer.class)) {
            return Integer::valueOf;
        }
        if (type.equals(Long.class)) {
            return Long::valueOf;
        }
        if (type.equals(Boolean.class)) {
            return Boolean::valueOf;
        }
        return this.values.parser();
    }

    public class Values
    extends AbstractOptions.AbstractValues {
        public Values() {
            super((AbstractOptions)TableIOOptions.this);
        }

        public boolean readColumnHeaders() {
            return (Boolean)this.getValueOrDefault(TableIOOptions.readColHeadersKey, true);
        }

        public boolean writeColumnHeaders() {
            return (Boolean)this.getValueOrDefault(TableIOOptions.writeColHeadersKey, true);
        }

        public boolean readRowHeaders() {
            return (Boolean)this.getValueOrDefault(TableIOOptions.readRowHeadersKey, true);
        }

        public boolean writeRowHeaders() {
            return (Boolean)this.getValueOrDefault(TableIOOptions.writeRowHeadersKey, true);
        }

        public char columnDelimiter() {
            return ((Character)this.getValueOrDefault(TableIOOptions.columnDelimiterKey, Character.valueOf(','))).charValue();
        }

        public String rowDelimiter() {
            return (String)this.getValueOrDefault(TableIOOptions.rowDelimiterKey, System.lineSeparator());
        }

        public char quote() {
            return ((Character)this.getValueOrDefault(TableIOOptions.quoteKey, Character.valueOf('\"'))).charValue();
        }

        public String cornerText() {
            return (String)this.getValueOrDefault(TableIOOptions.cornerTextKey, "\\");
        }

        public boolean guessParser() {
            return (Boolean)this.getValueOrDefault(TableIOOptions.guessParserKey, true);
        }

        public Function<String, ?> parser() {
            return (Function)this.getValueOrDefault(TableIOOptions.parserKey, String::valueOf);
        }

        public Function<Object, String> formatter() {
            return (Function)this.getValueOrDefault(TableIOOptions.formatterKey, String::valueOf);
        }

        public ColumnTableIOOptions.Values column(int column) {
            ColumnTableIOOptions columnOptions = (ColumnTableIOOptions)((Object)((HashMap)this.getValueOrDefault(TableIOOptions.columnOptionsKey, new HashMap())).get(column));
            if (columnOptions == null) {
                return null;
            }
            return columnOptions.values;
        }
    }
}

