/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptHeaderService;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.ui.swing.script.Bookmark;
import org.scijava.ui.swing.script.LanguageSupportService;
import org.scijava.ui.swing.script.TextEditorTab;
import org.scijava.ui.swing.script.TokenFunctions;
import org.scijava.util.FileUtils;

public class EditorPane
extends RSyntaxTextArea
implements DocumentListener {
    private String fallBackBaseName;
    private File curFile;
    private File gitDirectory;
    private long fileLastModified;
    private ScriptLanguage currentLanguage;
    private Gutter gutter;
    private IconGroup iconGroup;
    private int modifyCount;
    private boolean undoInProgress;
    private boolean redoInProgress;
    @Parameter
    Context context;
    @Parameter
    private LanguageSupportService languageSupportService;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ScriptHeaderService scriptHeaderService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private LogService log;
    private boolean autoCompletionEnabled = true;
    public static final String FONT_SIZE_PREFS = "script.editor.FontSize";
    public static final String LINE_WRAP_PREFS = "script.editor.WrapLines";
    public static final String TAB_SIZE_PREFS = "script.editor.TabSize";
    public static final String TABS_EMULATED_PREFS = "script.editor.TabsEmulated";
    public static final String FOLDERS_PREFS = "script.editor.folders";
    public static final int DEFAULT_TAB_SIZE = 4;

    public EditorPane() {
        this.setLineWrap(false);
        this.setTabSize(8);
        this.getActionMap().put("caret-next-word", (Action)this.wordMovement(1, false));
        this.getActionMap().put("selection-next-word", (Action)this.wordMovement(1, true));
        this.getActionMap().put("caret-previous-word", (Action)this.wordMovement(-1, false));
        this.getActionMap().put("selection-previous-word", (Action)this.wordMovement(-1, true));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.getDocument().addDocumentListener(this);
    }

    public void setTabSize(int width) {
        if (this.getTabSize() != width) {
            super.setTabSize(width);
        }
    }

    public void embedWithScrollbars(Container container) {
        container.add((Component)this.wrappedInScrollbars());
    }

    public RTextScrollPane wrappedInScrollbars() {
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this);
        sp.setPreferredSize(new Dimension(600, 350));
        sp.setIconRowHeaderEnabled(true);
        this.gutter = sp.getGutter();
        this.iconGroup = new IconGroup("bullets", "images/", null, "png", null);
        this.gutter.setBookmarkIcon(this.iconGroup.getIcon("var"));
        this.gutter.setBookmarkingEnabled(true);
        return sp;
    }

    RecordableTextAction wordMovement(final int direction, final boolean select) {
        final String id = "WORD_MOVEMENT_" + select + direction;
        return new RecordableTextAction(id){

            public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
                int pos;
                int end;
                int n = end = direction < 0 ? 0 : textArea.getDocument().getLength();
                for (pos = textArea.getCaretPosition(); pos != end && !this.isWordChar(textArea, pos); pos += direction) {
                }
                while (pos != end && this.isWordChar(textArea, pos)) {
                    pos += direction;
                }
                if (select) {
                    textArea.moveCaretPosition(pos);
                } else {
                    textArea.setCaretPosition(pos);
                }
            }

            public String getMacroID() {
                return id;
            }

            boolean isWordChar(RTextArea textArea, int pos) {
                try {
                    char c = textArea.getText(pos + (direction < 0 ? -1 : 0), 1).charAt(0);
                    return c > '\u007f' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_';
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
        };
    }

    public void undoLastAction() {
        this.undoInProgress = true;
        super.undoLastAction();
        this.undoInProgress = false;
    }

    public void redoLastAction() {
        this.redoInProgress = true;
        super.redoLastAction();
        this.redoInProgress = false;
    }

    public boolean fileChanged() {
        return this.modifyCount != 0;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.modified();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.modified();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    protected void modified() {
        this.modifyCount = this.undoInProgress ? --this.modifyCount : (this.redoInProgress || this.modifyCount >= 0 ? ++this.modifyCount : Integer.MIN_VALUE);
    }

    public boolean isNew() {
        return !this.fileChanged() && this.curFile == null && this.fallBackBaseName == null && this.getDocument().getLength() == 0;
    }

    public boolean wasChangedOutside() {
        return this.curFile != null && this.curFile.exists() && this.curFile.lastModified() != this.fileLastModified;
    }

    public void write(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory: " + dir);
        }
        BufferedWriter outFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        outFile.write(this.getText());
        outFile.close();
        this.modifyCount = 0;
        this.fileLastModified = file.lastModified();
    }

    public void open(File file) throws IOException {
        File oldFile = this.curFile;
        this.curFile = null;
        if (file == null) {
            this.setText("");
        } else {
            int count;
            int line = 0;
            try {
                if (file.getCanonicalPath().equals(oldFile.getCanonicalPath())) {
                    line = this.getCaretLineNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!file.exists()) {
                this.modifyCount = Integer.MIN_VALUE;
                this.setFileName(file);
                return;
            }
            StringBuffer string = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            char[] buffer = new char[16384];
            while ((count = reader.read(buffer)) >= 0) {
                string.append(buffer, 0, count);
            }
            reader.close();
            this.setText(string.toString());
            this.curFile = file;
            if (line > this.getLineCount()) {
                line = this.getLineCount() - 1;
            }
            try {
                this.setCaretPosition(this.getLineStartOffset(line));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.discardAllEdits();
        this.modifyCount = 0;
        this.fileLastModified = file == null || !file.exists() ? 0L : file.lastModified();
    }

    public void setFileName(String baseName) {
        this.fallBackBaseName = baseName;
        if (this.currentLanguage == null) {
            return;
        }
        for (String extension : this.currentLanguage.getExtensions()) {
            extension = "." + extension;
            if (!baseName.endsWith(extension)) continue;
            this.fallBackBaseName = this.fallBackBaseName.substring(0, this.fallBackBaseName.length() - extension.length());
            break;
        }
        if (this.currentLanguage.getLanguageName().equals("Java")) {
            new TokenFunctions(this).setClassName(this.fallBackBaseName);
        }
    }

    public void setFileName(File file) {
        this.curFile = file;
        if (file != null) {
            this.setLanguageByFileName(file.getName());
            this.fallBackBaseName = null;
        }
        this.fileLastModified = file == null || !file.exists() ? 0L : file.lastModified();
    }

    public File getGitDirectory() {
        return this.gitDirectory;
    }

    public void setGitDirectory(File dir) {
        this.gitDirectory = dir;
    }

    protected String getFileName() {
        if (this.curFile != null) {
            return this.curFile.getName();
        }
        String extension = "";
        if (this.currentLanguage != null) {
            String name;
            List extensions = this.currentLanguage.getExtensions();
            if (extensions.size() > 0) {
                extension = "." + (String)extensions.get(0);
            }
            if (this.currentLanguage.getLanguageName().equals("Java") && (name = new TokenFunctions(this).getClassName()) != null) {
                return name + extension;
            }
        }
        return (this.fallBackBaseName == null ? "New_" : this.fallBackBaseName) + extension;
    }

    protected void setLanguageByFileName(String name) {
        this.setLanguage(this.scriptService.getLanguageByExtension(FileUtils.getExtension((String)name)));
    }

    protected void setLanguage(ScriptLanguage language) {
        this.setLanguage(language, false);
    }

    protected void setLanguage(ScriptLanguage language, boolean addHeader) {
        String defaultExtension;
        String languageName;
        LanguageSupport support = this.languageSupportService.getLanguageSupport(this.currentLanguage);
        if (support != null) {
            support.uninstall((RSyntaxTextArea)this);
        }
        if (language == null) {
            languageName = "None";
            defaultExtension = ".txt";
        } else {
            languageName = language.getLanguageName();
            List extensions = language.getExtensions();
            String string = defaultExtension = extensions.size() == 0 ? "" : "." + (String)extensions.get(0);
        }
        if (this.fallBackBaseName != null && this.fallBackBaseName.endsWith(".txt")) {
            this.fallBackBaseName = this.fallBackBaseName.substring(0, this.fallBackBaseName.length() - 4);
        }
        if (this.curFile != null) {
            String name = this.curFile.getName();
            String ext = "." + FileUtils.getExtension((String)name);
            if (!defaultExtension.equals(ext)) {
                name = name.substring(0, name.length() - ext.length());
                this.curFile = new File(this.curFile.getParentFile(), name + defaultExtension);
                this.modifyCount = Integer.MIN_VALUE;
            }
        }
        String header = null;
        if (addHeader && this.currentLanguage == null) {
            header = this.scriptHeaderService.getHeader(language);
        }
        this.currentLanguage = language;
        String styleName = "text/" + languageName.toLowerCase().replace(' ', '-');
        try {
            this.setSyntaxEditingStyle(styleName);
        }
        catch (NullPointerException exc) {
            this.log.debug((Throwable)exc);
        }
        if (header != null) {
            header = header + this.getText();
            this.setText(header);
        }
        if ((support = this.languageSupportService.getLanguageSupport(this.currentLanguage)) != null && this.autoCompletionEnabled) {
            support.install((RSyntaxTextArea)this);
        }
    }

    public void setAutoCompletionEnabled(boolean value) {
        this.autoCompletionEnabled = value;
        this.setLanguage(this.currentLanguage);
    }

    public File getFile() {
        return this.curFile;
    }

    public ScriptLanguage getCurrentLanguage() {
        return this.currentLanguage;
    }

    public float getFontSize() {
        return this.getFont().getSize2D();
    }

    public void setFontSize(float size) {
        this.increaseFontSize(size / this.getFontSize());
    }

    public void increaseFontSize(float factor) {
        if (factor == 1.0f) {
            return;
        }
        SyntaxScheme scheme = this.getSyntaxScheme();
        for (int i = 0; i < scheme.getStyleCount(); ++i) {
            Style style = scheme.getStyle(i);
            if (style == null || style.font == null) continue;
            float size = Math.max(5.0f, style.font.getSize2D() * factor);
            style.font = style.font.deriveFont(size);
        }
        Font font = this.getFont();
        float size = Math.max(5.0f, font.getSize2D() * factor);
        this.setFont(font.deriveFont(size));
        this.setSyntaxScheme(scheme);
        Container parent = this.getParent();
        if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
            parent.repaint();
        }
        parent.repaint();
    }

    protected RSyntaxDocument getRSyntaxDocument() {
        return (RSyntaxDocument)this.getDocument();
    }

    public void toggleBookmark() {
        this.toggleBookmark(this.getCaretLineNumber());
    }

    public void toggleBookmark(int line) {
        if (this.gutter != null) {
            try {
                this.gutter.toggleBookmark(line);
            }
            catch (BadLocationException e) {
                this.log.error((Object)"Cannot toggle bookmark at this location.");
            }
        }
    }

    public void getBookmarks(TextEditorTab tab, Collection<Bookmark> result) {
        if (this.gutter == null) {
            return;
        }
        for (GutterIconInfo info : this.gutter.getBookmarks()) {
            result.add(new Bookmark(tab, info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int zapGremlins() {
        char[] chars = this.getText().toCharArray();
        int count = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!inQuotes) {
                if (c == '\"' || c == '\'') {
                    inQuotes = true;
                    quoteChar = c;
                    continue;
                }
                if (c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
                ++count;
                chars[i] = 32;
                continue;
            }
            if (c != quoteChar && c != '\n') continue;
            inQuotes = false;
        }
        if (count > 0) {
            this.beginAtomicEdit();
            try {
                this.setText(new String(chars));
            }
            catch (Throwable t) {
                this.log.error(t);
            }
            finally {
                this.endAtomicEdit();
            }
        }
        return count;
    }

    public void convertTabsToSpaces() {
        this.beginAtomicEdit();
        try {
            super.convertTabsToSpaces();
        }
        catch (Throwable t) {
            this.log.error(t);
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public void convertSpacesToTabs() {
        this.beginAtomicEdit();
        try {
            super.convertSpacesToTabs();
        }
        catch (Throwable t) {
            this.log.error(t);
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public void loadPreferences() {
        this.resetTabSize();
        this.setFontSize(this.prefService.getFloat(this.getClass(), FONT_SIZE_PREFS, this.getFontSize()));
        this.setLineWrap(this.prefService.getBoolean(this.getClass(), LINE_WRAP_PREFS, this.getLineWrap()));
        this.setTabsEmulated(this.prefService.getBoolean(this.getClass(), TABS_EMULATED_PREFS, this.getTabsEmulated()));
    }

    public String loadFolders() {
        return this.prefService.get(this.getClass(), FOLDERS_PREFS, System.getProperty("user.home"));
    }

    public void savePreferences(String top_folders) {
        this.prefService.put(this.getClass(), TAB_SIZE_PREFS, this.getTabSize());
        this.prefService.put(this.getClass(), FONT_SIZE_PREFS, this.getFontSize());
        this.prefService.put(this.getClass(), LINE_WRAP_PREFS, this.getLineWrap());
        this.prefService.put(this.getClass(), TABS_EMULATED_PREFS, this.getTabsEmulated());
        if (null != top_folders) {
            this.prefService.put(this.getClass(), FOLDERS_PREFS, top_folders);
        }
    }

    public void resetTabSize() {
        this.setTabSize(this.prefService.getInt(this.getClass(), TAB_SIZE_PREFS, 4));
    }
}

