/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Font;
import java.io.OutputStream;
import java.io.Writer;
import javax.swing.JTextArea;
import org.scijava.log.LogService;
import org.scijava.ui.swing.script.JTextAreaOutputStream;
import org.scijava.ui.swing.script.JTextAreaWriter;

public class OutputPane
extends JTextArea {
    private final LogService log;
    private OutputStream out;
    private Writer writer;

    public OutputPane(LogService log) {
        this.log = log;
        Font font = new Font("Courier", 0, 12);
        this.setFont(font);
        this.setEditable(false);
        this.setFocusable(true);
        this.setLineWrap(true);
    }

    public synchronized OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new JTextAreaOutputStream(this);
        }
        return this.out;
    }

    public synchronized Writer getOutputWriter() {
        if (this.writer == null) {
            this.writer = new JTextAreaWriter(this, this.log);
        }
        return this.writer;
    }

    public void close() {
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }
}

