/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.TextEditor;

public class TextEditorTab
extends JSplitPane {
    private static final String DOWN_ARROW = "\u25bc";
    private static final String RIGHT_ARROW = "\u25b6";
    protected final EditorPane editorPane;
    protected final JTextArea screen = new JTextArea();
    protected final JTextArea prompt = new JTextArea();
    private final JLabel prompt_title = new JLabel();
    protected final JCheckBox updownarrows = new JCheckBox("Use arrow keys");
    protected final JScrollPane scroll;
    protected boolean showingErrors;
    private TextEditor.Executer executer;
    private final JButton runit;
    private final JButton batchit;
    private final JButton killit;
    private final JButton toggleErrors;
    private final JButton switchSplit;
    private final JCheckBox incremental;
    private final JSplitPane screenAndPromptSplit;
    private final TextEditor textEditor;
    private DropTarget dropTarget;
    private DropTargetListener dropTargetListener;

    public TextEditorTab(final TextEditor textEditor) {
        super(0);
        super.setResizeWeight(0.813953488372093);
        this.setOneTouchExpandable(true);
        this.textEditor = textEditor;
        this.editorPane = new EditorPane();
        this.dropTargetListener = new DropTargetListener(){

            @Override
            public void dropActionChanged(DropTargetDragEvent arg0) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                if (e.getDropAction() != 1) {
                    e.rejectDrop();
                    return;
                }
                Transferable t = e.getTransferable();
                if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return;
                }
                try {
                    String path;
                    Object o = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (!(o instanceof List)) {
                        return;
                    }
                    List list = (List)o;
                    if (list.isEmpty()) {
                        return;
                    }
                    Object first = list.get(0);
                    if (first instanceof String) {
                        path = (String)first;
                    } else if (first instanceof File) {
                        path = ((File)first).getAbsolutePath();
                    } else {
                        return;
                    }
                    TextEditorTab.this.editorPane.getRSyntaxDocument().insertString(TextEditorTab.this.editorPane.getCaretPosition(), path, null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                if (e.getDropAction() != 1) {
                    e.rejectDrag();
                }
            }

            @Override
            public void dragExit(DropTargetEvent e) {
            }

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                if (e.getDropAction() != 1) {
                    e.rejectDrag();
                }
            }
        };
        this.dropTarget = new DropTarget((Component)((Object)this.editorPane), 1, this.dropTargetListener);
        this.screen.setEditable(false);
        this.screen.setLineWrap(true);
        this.screen.setFont(new Font("Courier", 0, 12));
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridx = 0;
        bc.gridy = 0;
        bc.weightx = 0.0;
        bc.weighty = 0.0;
        bc.anchor = 18;
        bc.fill = 0;
        this.runit = new JButton("Run");
        this.runit.setToolTipText("control + R");
        this.runit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                textEditor.runText();
            }
        });
        bottom.add((Component)this.runit, bc);
        bc.gridx = 1;
        this.batchit = new JButton("Batch");
        this.batchit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                textEditor.runBatch();
            }
        });
        bottom.add((Component)this.batchit, bc);
        bc.gridx = 2;
        this.killit = new JButton("Kill");
        this.killit.setEnabled(false);
        this.killit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextEditorTab.this.kill();
            }
        });
        bottom.add((Component)this.killit, bc);
        bc.gridx = 3;
        this.incremental = new JCheckBox("persistent");
        this.incremental.setEnabled(true);
        this.incremental.setSelected(false);
        bottom.add((Component)this.incremental, bc);
        bc.gridx = 4;
        bc.fill = 2;
        bc.weightx = 1.0;
        bottom.add((Component)new JPanel(), bc);
        bc.gridx = 5;
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.anchor = 12;
        this.toggleErrors = new JButton("Show Errors");
        this.toggleErrors.addActionListener(e -> this.toggleErrors());
        bottom.add((Component)this.toggleErrors, bc);
        bc.gridx = 6;
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.anchor = 12;
        JButton clear = new JButton("Clear");
        clear.addActionListener(ae -> this.getScreen().setText(""));
        bottom.add((Component)clear, bc);
        bc.gridx = 7;
        this.switchSplit = new JButton(RIGHT_ARROW);
        this.switchSplit.setToolTipText("Switch location");
        this.switchSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextEditorTab.DOWN_ARROW.equals(TextEditorTab.this.switchSplit.getText())) {
                    TextEditorTab.this.setOrientation(0);
                } else {
                    TextEditorTab.this.setOrientation(1);
                }
                if (!TextEditorTab.this.incremental.isSelected()) {
                    SwingUtilities.invokeLater(() -> TextEditorTab.this.screenAndPromptSplit.setDividerLocation(1.0));
                }
            }
        });
        bottom.add((Component)this.switchSplit, bc);
        bc.gridx = 0;
        bc.gridy = 1;
        bc.anchor = 18;
        bc.fill = 1;
        bc.weightx = 1.0;
        bc.weighty = 1.0;
        bc.gridwidth = 8;
        this.screen.setEditable(false);
        this.screen.setLineWrap(true);
        Font font = new Font("Courier", 0, 12);
        this.screen.setFont(font);
        this.scroll = new JScrollPane(this.screen);
        bottom.add((Component)this.scroll, bc);
        this.prompt.setEnabled(false);
        JPanel prompt_panel = new JPanel();
        prompt_panel.setMinimumSize(new Dimension(0, 0));
        prompt_panel.setVisible(false);
        prompt_panel.setLayout(new GridBagLayout());
        bc.gridx = 0;
        bc.gridy = 0;
        bc.anchor = 18;
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.weighty = 0.0;
        bc.gridwidth = 1;
        bc.gridheight = 1;
        prompt_panel.add((Component)this.prompt_title, bc);
        bc.gridx = 1;
        bc.fill = 2;
        bc.weightx = 1.0;
        prompt_panel.add((Component)new JPanel(), bc);
        bc.gridx = 2;
        bc.anchor = 12;
        bc.weightx = 0.0;
        bc.fill = 0;
        prompt_panel.add((Component)this.updownarrows, bc);
        bc.gridx = 3;
        JButton prompt_help = new JButton("?");
        prompt_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                String msg = "This REPL (read-evaluate-print-loop) parses " + textEditor.getCurrentLanguage().getLanguageName() + " code.\n\nKey bindings:\n* enter: evaluate code\n* shift+enter: add line break (also alt-enter and meta-enter)\n* page UP or ctrl+p: show previous entry in the history\n* page DOWN or ctrl+n: show next entry in the history\n\nIf 'Use arrow keys' is checked, then up/down arrows work like page UP/DOWN,\nand shift+up/down arrow work like arrow keys before for caret movement\nwithin a multi-line prompt.";
                JOptionPane.showMessageDialog(textEditor, msg, "REPL help", 1);
            }
        });
        prompt_panel.add((Component)prompt_help, bc);
        bc.gridx = 0;
        bc.gridy = 1;
        bc.anchor = 18;
        bc.fill = 1;
        bc.weightx = 1.0;
        bc.weighty = 1.0;
        bc.gridwidth = 4;
        prompt_panel.add((Component)this.prompt, bc);
        this.incremental.addActionListener(ae -> {
            if (this.incremental.isSelected() && null == textEditor.getCurrentLanguage()) {
                this.incremental.setSelected(false);
                JOptionPane.showMessageDialog(this, "Select a language first!");
                return;
            }
            textEditor.setIncremental(this.incremental.isSelected());
            this.prompt_title.setText(this.incremental.isSelected() ? "REPL: " + textEditor.getCurrentLanguage().getLanguageName() : "");
            this.prompt.setEnabled(this.incremental.isSelected());
            prompt_panel.setVisible(this.incremental.isSelected());
        });
        this.screenAndPromptSplit = new JSplitPane(0, bottom, prompt_panel);
        super.setLeftComponent((Component)this.editorPane.wrappedInScrollbars());
        super.setRightComponent(this.screenAndPromptSplit);
        this.screenAndPromptSplit.setDividerLocation(600);
        this.screenAndPromptSplit.setDividerLocation(1.0);
        this.addPropertyChangeListener(evt -> {
            if ("dividerLocation".equals(evt.getPropertyName())) {
                textEditor.saveWindowSizeToPrefs();
            }
        });
    }

    JSplitPane getScreenAndPromptSplit() {
        return this.screenAndPromptSplit;
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.switchSplit.setText(orientation == 0 ? RIGHT_ARROW : DOWN_ARROW);
    }

    void destroy() {
        this.dropTarget.removeDropTargetListener(this.dropTargetListener);
        this.dropTarget = null;
        this.dropTargetListener = null;
    }

    public void prepare() {
        this.editorPane.setEditable(false);
        this.runit.setEnabled(false);
        this.killit.setEnabled(true);
    }

    public void restore() {
        SwingUtilities.invokeLater(() -> {
            this.editorPane.setEditable(true);
            this.runit.setEnabled(true);
            this.killit.setEnabled(false);
            this.setExecutor(null);
        });
    }

    public void toggleErrors() {
        boolean bl = this.showingErrors = !this.showingErrors;
        if (this.showingErrors) {
            this.toggleErrors.setText("Show Output");
            this.scroll.setViewportView(this.textEditor.getErrorScreen());
        } else {
            this.toggleErrors.setText("Show Errors");
            this.scroll.setViewportView(this.screen);
        }
    }

    public void showErrors() {
        if (!this.showingErrors) {
            this.toggleErrors();
        } else if (this.scroll.getViewport().getView() == null) {
            this.scroll.setViewportView(this.textEditor.getErrorScreen());
        }
    }

    public void showOutput() {
        if (this.showingErrors) {
            this.toggleErrors();
        }
    }

    public JTextArea getScreen() {
        return this.showingErrors ? this.textEditor.getErrorScreen() : this.screen;
    }

    public JTextArea getPrompt() {
        return this.prompt;
    }

    public JTextArea getScreenInstance() {
        return this.screen;
    }

    boolean isExecuting() {
        return null != this.getExecuter();
    }

    public final String getTitle() {
        return (this.editorPane.fileChanged() ? "*" : "") + this.editorPane.getFileName() + (this.isExecuting() ? " (Running)" : "");
    }

    protected void kill() {
        if (null == this.getExecuter()) {
            return;
        }
        this.getExecuter().interrupt();
        final long now = System.currentTimeMillis();
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                while (System.currentTimeMillis() - now < 3000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (null != TextEditorTab.this.getExecuter()) {
                    TextEditorTab.this.getExecuter().obliterate();
                }
                TextEditorTab.this.restore();
            }
        }.start();
    }

    public TextEditor.Executer getExecuter() {
        return this.executer;
    }

    public void setExecutor(TextEditor.Executer executer) {
        this.executer = executer;
    }

    public JTextComponent getEditorPane() {
        return this.editorPane;
    }
}

