/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.groovy;

import groovy.lang.GroovySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripting.groovy.GroovyScriptEngine;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptLanguage;

@Plugin(type=ScriptLanguage.class, name="Groovy", priority=100.0)
public class GroovyScriptLanguage
extends AbstractScriptLanguage {
    private static String VERSION = "1.5.6";
    private static List<String> names = new ArrayList<String>(1);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    public String getEngineName() {
        return "groovy";
    }

    public String getEngineVersion() {
        return GroovySystem.getVersion();
    }

    public String getLanguageVersion() {
        return VERSION;
    }

    public List<String> getExtensions() {
        return extensions;
    }

    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    public List<String> getNames() {
        return names;
    }

    public Object getParameter(String key) {
        if ("javax.script.name".equals(key)) {
            return "Groovy";
        }
        if ("javax.script.engine".equals(key)) {
            return "Groovy Script Engine";
        }
        if ("javax.script.engine_version".equals(key)) {
            return GroovySystem.getVersion();
        }
        if ("javax.script.language".equals(key)) {
            return "Groovy";
        }
        if ("javax.script.language_version".equals(key)) {
            return VERSION;
        }
        if ("THREADING".equals(key)) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    public ScriptEngine getScriptEngine() {
        return new GroovyScriptEngine();
    }

    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = obj + "." + method + "(";
        int len = args.length;
        if (len == 0) {
            ret = ret + ")";
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + args[i];
            ret = i != len - 1 ? ret + "," : ret + ")";
        }
        return ret;
    }

    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("println(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")");
        return buf.toString();
    }

    public String getProgram(String ... statements) {
        StringBuilder ret = new StringBuilder();
        int len = statements.length;
        for (int i = 0; i < len; ++i) {
            ret.append(statements[i]);
            ret.append('\n');
        }
        return ret.toString();
    }

    static {
        names.add("groovy");
        names = Collections.unmodifiableList(names);
        extensions = names;
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

