/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft2;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFT;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class FFTConvolution<R extends RealType<R>> {
    Img<ComplexFloatType> fftImg;
    Img<ComplexFloatType> fftKernel;
    ImgFactory<ComplexFloatType> fftFactory;
    RandomAccessible<R> img;
    RandomAccessible<R> kernel;
    Interval imgInterval;
    Interval kernelInterval;
    RandomAccessibleInterval<R> output;
    boolean complexConjugate = false;
    boolean keepImgFFT = false;
    private ExecutorService service;

    public FFTConvolution(Img<R> img, Img<R> kernel) {
        this(img, kernel, (RandomAccessibleInterval<R>)img, (ExecutorService)null);
    }

    public FFTConvolution(Img<R> img, Img<R> kernel, ExecutorService service) {
        this(img, kernel, (RandomAccessibleInterval<R>)img, service);
    }

    public FFTConvolution(Img<R> img, Img<R> kernel, RandomAccessibleInterval<R> output) {
        this((RandomAccessibleInterval<R>)img, (RandomAccessibleInterval<R>)kernel, output, FFTConvolution.getFFTFactory(img), null);
    }

    public FFTConvolution(Img<R> img, Img<R> kernel, RandomAccessibleInterval<R> output, ExecutorService service) {
        this((RandomAccessibleInterval<R>)img, (RandomAccessibleInterval<R>)kernel, output, FFTConvolution.getFFTFactory(img), service);
    }

    public FFTConvolution(RandomAccessibleInterval<R> img, RandomAccessibleInterval<R> kernel, ImgFactory<ComplexFloatType> factory) {
        this(img, kernel, img, factory, null);
    }

    public FFTConvolution(RandomAccessibleInterval<R> img, RandomAccessibleInterval<R> kernel, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        this(img, kernel, img, factory, service);
    }

    public FFTConvolution(RandomAccessibleInterval<R> img, RandomAccessibleInterval<R> kernel, RandomAccessibleInterval<R> output, ImgFactory<ComplexFloatType> factory) {
        this((RandomAccessible<R>)Views.extendMirrorSingle(img), (Interval)img, (RandomAccessible<R>)Views.extendValue(kernel, (Type)((RealType)Util.getTypeFromInterval(kernel)).createVariable()), (Interval)kernel, output, factory, null);
    }

    public FFTConvolution(RandomAccessibleInterval<R> img, RandomAccessibleInterval<R> kernel, RandomAccessibleInterval<R> output, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        this((RandomAccessible<R>)Views.extendMirrorSingle(img), (Interval)img, (RandomAccessible<R>)Views.extendValue(kernel, (Type)((RealType)Util.getTypeFromInterval(kernel)).createVariable()), (Interval)kernel, output, factory, service);
    }

    public FFTConvolution(RandomAccessible<R> img, Interval imgInterval, RandomAccessible<R> kernel, Interval kernelInterval, ImgFactory<ComplexFloatType> factory) {
        this(img, imgInterval, kernel, kernelInterval, (RandomAccessibleInterval<R>)Views.interval(img, (Interval)imgInterval), factory, null);
    }

    public FFTConvolution(RandomAccessible<R> img, Interval imgInterval, RandomAccessible<R> kernel, Interval kernelInterval, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        this(img, imgInterval, kernel, kernelInterval, (RandomAccessibleInterval<R>)Views.interval(img, (Interval)imgInterval), factory, service);
    }

    public FFTConvolution(RandomAccessible<R> img, Interval imgInterval, RandomAccessible<R> kernel, Interval kernelInterval, RandomAccessibleInterval<R> output, ImgFactory<ComplexFloatType> factory) {
        this(img, imgInterval, kernel, kernelInterval, output, factory, null);
    }

    public FFTConvolution(RandomAccessible<R> img, Interval imgInterval, RandomAccessible<R> kernel, Interval kernelInterval, RandomAccessibleInterval<R> output, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        this.img = img;
        this.imgInterval = imgInterval;
        this.kernel = kernel;
        this.kernelInterval = kernelInterval;
        this.output = output;
        this.fftFactory = factory;
        this.setExecutorService(service);
    }

    public void setImg(RandomAccessibleInterval<R> img) {
        this.img = Views.extendMirrorSingle(img);
        this.imgInterval = img;
        this.fftImg = null;
    }

    public void setImg(RandomAccessible<R> img, Interval imgInterval) {
        this.img = img;
        this.imgInterval = imgInterval;
        this.fftImg = null;
    }

    public void setKernel(RandomAccessibleInterval<R> kernel) {
        this.kernel = Views.extendValue(kernel, (Type)((RealType)Util.getTypeFromInterval(kernel)).createVariable());
        this.kernelInterval = kernel;
        this.fftKernel = null;
    }

    public void setKernel(RandomAccessible<R> kernel, Interval kernelInterval) {
        this.kernel = kernel;
        this.kernelInterval = kernelInterval;
        this.fftKernel = null;
    }

    public void setOutput(RandomAccessibleInterval<R> output) {
        this.output = output;
    }

    public void setComputeComplexConjugate(boolean complexConjugate) {
        this.complexConjugate = complexConjugate;
        this.fftKernel = null;
    }

    public boolean getComplexConjugate() {
        return this.complexConjugate;
    }

    public void setKeepImgFFT(boolean keep) {
        this.keepImgFFT = keep;
    }

    public boolean keepImgFFT() {
        return this.keepImgFFT;
    }

    public void setFFTImgFactory(ImgFactory<ComplexFloatType> factory) {
        this.fftFactory = factory;
    }

    public ImgFactory<ComplexFloatType> fftImgFactory() {
        return this.fftFactory;
    }

    public Img<ComplexFloatType> imgFFT() {
        return this.fftImg;
    }

    public Img<ComplexFloatType> kernelFFT() {
        return this.fftKernel;
    }

    public void setKernelFFT(Img<ComplexFloatType> fftKernel) {
        this.fftKernel = fftKernel;
    }

    public void setImgFFT(Img<ComplexFloatType> fftImg) {
        this.fftImg = fftImg;
    }

    public void convolve() {
        long[] min = new long[this.img.numDimensions()];
        long[] max = new long[this.img.numDimensions()];
        Pair<Interval, Interval> fftIntervals = FFTConvolution.setupFFTs(this.imgInterval, this.kernelInterval, min, max);
        if (this.fftImg == null) {
            this.fftImg = FFTConvolution.computeImgFFT((Interval)fftIntervals.getA(), this.img, this.fftFactory, this.service);
        }
        if (this.fftKernel == null) {
            this.fftKernel = FFTConvolution.computeKernelFFT((Interval)fftIntervals.getB(), min, max, this.complexConjugate, this.kernel, this.fftFactory, this.service);
        }
        FFTConvolution.computeConvolution(this.fftImg, this.fftKernel, this.output, this.keepImgFFT, this.service);
    }

    public static Pair<Interval, Interval> setupFFTs(Interval imgInterval, Interval kernelInterval, long[] min, long[] max) {
        int numDimensions = imgInterval.numDimensions();
        long[] newDimensions = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            newDimensions[d] = (int)imgInterval.dimension(d) + (int)kernelInterval.dimension(d) - 1;
        }
        long[] paddedDimensions = new long[numDimensions];
        long[] fftDimensions = new long[numDimensions];
        FFTMethods.dimensionsRealToComplexFast((Dimensions)FinalDimensions.wrap((long[])newDimensions), (long[])paddedDimensions, (long[])fftDimensions);
        Interval imgConvolutionInterval = FFTMethods.paddingIntervalCentered((Interval)imgInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        Interval kernelConvolutionInterval = FFTMethods.paddingIntervalCentered((Interval)kernelInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        for (int d = 0; d < numDimensions; ++d) {
            min[d] = kernelInterval.min(d) + kernelInterval.dimension(d) / 2L;
            max[d] = min[d] + kernelConvolutionInterval.dimension(d) - 1L;
        }
        return new ValuePair((Object)imgConvolutionInterval, (Object)kernelConvolutionInterval);
    }

    public static <R extends RealType<R>> Img<ComplexFloatType> computeImgFFT(Interval imgConvolutionInterval, RandomAccessible<R> img, ImgFactory<ComplexFloatType> fftFactory, ExecutorService service) {
        IntervalView imgInput = Views.interval(img, (Interval)imgConvolutionInterval);
        return FFT.realToComplex((RandomAccessibleInterval)imgInput, fftFactory, (ExecutorService)service);
    }

    public static <R extends RealType<R>> Img<ComplexFloatType> computeKernelFFT(Interval kernelConvolutionInterval, long[] min, long[] max, boolean complexConjugate, RandomAccessible<R> kernel, ImgFactory<ComplexFloatType> fftFactory, ExecutorService service) {
        IntervalView kernelInput = Views.interval((RandomAccessible)Views.extendPeriodic((RandomAccessibleInterval)Views.interval(kernel, (Interval)kernelConvolutionInterval)), (Interval)new FinalInterval(min, max));
        Img fftKernel = FFT.realToComplex((RandomAccessibleInterval)kernelInput, fftFactory, (ExecutorService)service);
        if (complexConjugate) {
            FFTMethods.complexConjugate((RandomAccessibleInterval)fftKernel);
        }
        return fftKernel;
    }

    public static <R extends RealType<R>> void computeConvolution(Img<ComplexFloatType> fftImg, Img<ComplexFloatType> fftKernel, RandomAccessibleInterval<R> output, boolean keepImgFFT, ExecutorService service) {
        Img fftconvolved = keepImgFFT ? fftImg.copy() : fftImg;
        FFTConvolution.multiplyComplex((Img<ComplexFloatType>)fftconvolved, fftKernel);
        FFT.complexToRealUnpad((RandomAccessibleInterval)fftconvolved, output, (ExecutorService)service);
    }

    public static final <R extends RealType<R>> void convolve(RandomAccessible<R> img, Interval imgInterval, RandomAccessible<R> kernel, Interval kernelInterval, RandomAccessibleInterval<R> output, ImgFactory<ComplexFloatType> factory, int numThreads) {
        int numDimensions = imgInterval.numDimensions();
        long[] newDimensions = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            newDimensions[d] = (int)imgInterval.dimension(d) + (int)kernelInterval.dimension(d) - 1;
        }
        long[] paddedDimensions = new long[numDimensions];
        long[] fftDimensions = new long[numDimensions];
        FFTMethods.dimensionsRealToComplexFast((Dimensions)FinalDimensions.wrap((long[])newDimensions), (long[])paddedDimensions, (long[])fftDimensions);
        Interval imgConvolutionInterval = FFTMethods.paddingIntervalCentered((Interval)imgInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        Interval kernelConvolutionInterval = FFTMethods.paddingIntervalCentered((Interval)kernelInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            min[d] = kernelInterval.min(d) + kernelInterval.dimension(d) / 2L;
            max[d] = min[d] + kernelConvolutionInterval.dimension(d) - 1L;
        }
        IntervalView kernelInput = Views.interval((RandomAccessible)Views.extendPeriodic((RandomAccessibleInterval)Views.interval(kernel, (Interval)kernelConvolutionInterval)), (Interval)new FinalInterval(min, max));
        IntervalView imgInput = Views.interval(img, (Interval)imgConvolutionInterval);
        Img fftImg = FFT.realToComplex((RandomAccessibleInterval)imgInput, factory, (int)numThreads);
        Img fftKernel = FFT.realToComplex((RandomAccessibleInterval)kernelInput, factory, (int)numThreads);
        FFTConvolution.multiplyComplex((Img<ComplexFloatType>)fftImg, (Img<ComplexFloatType>)fftKernel);
        FFT.complexToRealUnpad((RandomAccessibleInterval)fftImg, output, (int)numThreads);
    }

    public static final void multiplyComplex(Img<ComplexFloatType> img, Img<ComplexFloatType> kernel) {
        Cursor cursorA = img.cursor();
        Cursor cursorB = kernel.cursor();
        while (cursorA.hasNext()) {
            ((ComplexFloatType)cursorA.next()).mul((ComplexFloatType)cursorB.next());
        }
    }

    protected static ImgFactory<ComplexFloatType> getFFTFactory(Img<? extends RealType<?>> img) {
        try {
            return img.factory().imgFactory((Object)new ComplexFloatType());
        }
        catch (IncompatibleTypeException e) {
            if (img.size() > 0x3FFFFFFFL) {
                return new CellImgFactory(new int[]{1024});
            }
            return new ArrayImgFactory();
        }
    }

    public void setExecutorService(ExecutorService service) {
        this.service = service == null ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()) : service;
    }

    public static final ExecutorService createExecutorService() {
        return FFTConvolution.createExecutorService(Runtime.getRuntime().availableProcessors());
    }

    public static final ExecutorService createExecutorService(int nThreads) {
        return Executors.newFixedThreadPool(nThreads);
    }
}

