/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public abstract class ExplicitDiffusionScheme<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm {
    private static final String BASE_ERROR_MESSAGE = "[" + ExplicitDiffusionScheme.class.getSimpleName() + "] ";
    protected RandomAccessibleInterval<FloatType> D;
    protected final RandomAccessibleInterval<T> input;
    protected Img<FloatType> increment;
    protected ImgFactory<FloatType> imgFactory;
    private final float maxVal;
    private final float minVal;
    protected final int tensorComponentDimension;

    public ExplicitDiffusionScheme(Img<T> input, Img<FloatType> D) {
        this((RandomAccessibleInterval<T>)input, (RandomAccessibleInterval<FloatType>)D, (ImgFactory<FloatType>)D.factory());
    }

    public ExplicitDiffusionScheme(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D) {
        this(input, D, (ImgFactory<FloatType>)(Views.iterable(input).size() >= Integer.MAX_VALUE ? new CellImgFactory() : new ArrayImgFactory()));
    }

    public ExplicitDiffusionScheme(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory) {
        this.input = input;
        this.D = D;
        this.increment = imgFactory.create(input, (Object)new FloatType());
        this.minVal = (float)((RealType)Views.iterable(input).firstElement()).getMinValue();
        this.maxVal = (float)((RealType)Views.iterable(input).firstElement()).getMaxValue();
        this.tensorComponentDimension = input.numDimensions();
        this.processingTime = 0L;
        this.imgFactory = imgFactory;
    }

    protected abstract float[] initDensityArray();

    protected abstract float[][] initDiffusionTensorArray();

    public boolean process() {
        Chunk chunk;
        long start = System.currentTimeMillis();
        Vector chunks = SimpleMultiThreading.divideIntoChunks((long)Views.iterable(this.input).size(), (int)this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.numThreads);
        for (int i = 0; i < threads.length; ++i) {
            chunk = (Chunk)chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i){

                @Override
                public void run() {
                    ExtendedRandomAccessibleInterval extendedInput = Views.extendMirrorDouble(ExplicitDiffusionScheme.this.input);
                    OutOfBounds ura = extendedInput.randomAccess();
                    ExtendedRandomAccessibleInterval extendedD = Views.extendMirrorDouble(ExplicitDiffusionScheme.this.D);
                    OutOfBounds dra = extendedD.randomAccess();
                    Cursor incrementCursor = ExplicitDiffusionScheme.this.increment.localizingCursor();
                    long[] position = new long[ExplicitDiffusionScheme.this.input.numDimensions()];
                    float[][] D = ExplicitDiffusionScheme.this.initDiffusionTensorArray();
                    float[] U = ExplicitDiffusionScheme.this.initDensityArray();
                    incrementCursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        incrementCursor.fwd();
                        ura.setPosition((Localizable)incrementCursor);
                        incrementCursor.localize(position);
                        for (int i = 0; i < position.length; ++i) {
                            dra.setPosition(position[i], i);
                        }
                        ExplicitDiffusionScheme.this.yieldDensity(ura, U);
                        ExplicitDiffusionScheme.this.yieldDiffusionTensor((RandomAccess<FloatType>)dra, D);
                        ((FloatType)incrementCursor.get()).setReal(ExplicitDiffusionScheme.this.diffusionScheme(U, D));
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            chunk = (Chunk)chunks.get(ithread);
            threads[ithread] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + ithread){

                @Override
                public void run() {
                    Cursor incrementCursor = ExplicitDiffusionScheme.this.increment.localizingCursor();
                    RandomAccess ra = ExplicitDiffusionScheme.this.input.randomAccess();
                    incrementCursor.reset();
                    incrementCursor.jumpFwd(chunk.getStartPosition());
                    for (long j = 0L; j < chunk.getLoopSize(); ++j) {
                        float inc = ((FloatType)incrementCursor.next()).get();
                        ra.setPosition((Localizable)incrementCursor);
                        float val = ((RealType)ra.get()).getRealFloat();
                        float sum = val + inc;
                        if (sum > ExplicitDiffusionScheme.this.maxVal) {
                            sum = ExplicitDiffusionScheme.this.maxVal;
                        }
                        if (sum < ExplicitDiffusionScheme.this.minVal) {
                            sum = ExplicitDiffusionScheme.this.minVal;
                        }
                        ((RealType)ra.get()).setReal(sum);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        long end = System.currentTimeMillis();
        this.processingTime += end - start;
        return true;
    }

    public RandomAccessibleInterval<FloatType> getIncrement() {
        return this.increment;
    }

    protected abstract float diffusionScheme(float[] var1, float[][] var2);

    public boolean checkInput() {
        if (null == this.input) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The input image is null.";
            return false;
        }
        if (null == this.D) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The diffusion tensor is null.";
            return false;
        }
        if (this.D.numDimensions() + 1 != this.input.numDimensions()) {
            this.errorMessage = BASE_ERROR_MESSAGE + "The diffusion tensor is expected to have " + this.input.numDimensions() + " dimension, but has " + this.D.numDimensions() + ".";
            return false;
        }
        for (int i = 0; i < this.input.numDimensions(); ++i) {
            if (this.D.dimension(i) == this.input.dimension(i)) continue;
            this.errorMessage = BASE_ERROR_MESSAGE + "Dimension " + i + " of the diffusion tensor is of size " + this.D.dimension(i) + ", expected " + this.input.dimension(i) + ".";
            return false;
        }
        return true;
    }

    public void setDiffusionTensor(RandomAccessibleInterval<FloatType> D) {
        this.D = D;
    }

    public RandomAccessibleInterval<FloatType> getDiffusionTensor() {
        return this.D;
    }

    protected abstract void yieldDensity(RandomAccess<T> var1, float[] var2);

    protected abstract void yieldDiffusionTensor(RandomAccess<FloatType> var1, float[][] var2);
}

