/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.Cursor;
import net.imglib2.Sampler;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.Utils;

public final class EllipseCursor<T>
extends AbstractNeighborhoodCursor<T> {
    protected CursorState state;
    protected CursorState nextState;
    protected int rx;
    protected int[] rxs;
    protected long[] position;
    protected boolean allDone;
    protected boolean hasNext;

    public EllipseCursor(AbstractNeighborhood<T> ellipse) {
        super(ellipse);
        this.rxs = new int[(int)(Math.max(ellipse.span[0], ellipse.span[1]) + 1L)];
        this.reset();
    }

    public double getDistanceSquared() {
        double sum = 0.0;
        for (int d = 0; d < this.position.length; ++d) {
            sum += (double)(this.position[d] * this.position[d]);
        }
        return sum;
    }

    public double getPhi() {
        return Math.atan2(this.position[1], this.position[0]);
    }

    public void reset() {
        this.ra.setPosition(this.neighborhood.center);
        this.state = CursorState.INITIALIZED;
        this.position = new long[this.numDimensions()];
        this.hasNext = true;
        this.allDone = false;
    }

    public void fwd() {
        switch (this.state) {
            case DRAWING_LINE: {
                this.ra.fwd(0);
                this.position[0] = this.position[0] + 1L;
                if (this.position[0] < (long)this.rx) break;
                this.state = this.nextState;
                if (!this.allDone) break;
                this.hasNext = false;
                break;
            }
            case INITIALIZED: {
                Utils.getXYEllipseBounds((int)this.neighborhood.span[0], (int)this.neighborhood.span[1], this.rxs);
                this.rx = this.rxs[0];
                this.ra.setPosition(this.neighborhood.center);
                this.ra.setPosition(this.neighborhood.center[0] - (long)this.rx, 0);
                this.position[0] = -this.rx;
                this.state = CursorState.DRAWING_LINE;
                this.nextState = CursorState.INCREMENT_Y;
                break;
            }
            case INCREMENT_Y: {
                this.position[1] = -this.position[1] + 1L;
                this.rx = this.rxs[(int)this.position[1]];
                this.ra.setPosition(this.neighborhood.center[1] + this.position[1], 1);
                this.position[0] = -this.rx;
                this.ra.setPosition(this.neighborhood.center[0] - (long)this.rx, 0);
                this.nextState = CursorState.MIRROR_Y;
                if (this.rx == 0) {
                    this.state = CursorState.MIRROR_Y;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case MIRROR_Y: {
                this.position[0] = -this.rx;
                this.position[1] = -this.position[1];
                this.ra.setPosition(this.neighborhood.center[1] + this.position[1], 1);
                this.ra.setPosition(this.neighborhood.center[0] - (long)this.rx, 0);
                if (this.position[1] <= -this.neighborhood.span[1]) {
                    this.allDone = true;
                } else {
                    this.nextState = CursorState.INCREMENT_Y;
                }
                if (this.rx == 0) {
                    if (this.allDone) {
                        this.hasNext = false;
                        break;
                    }
                    this.state = this.nextState;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Cursor<T> copyCursor() {
        return new EllipseCursor<T>(this.neighborhood);
    }

    public Sampler<T> copy() {
        return this.copyCursor();
    }

    private static enum CursorState {
        DRAWING_LINE,
        INITIALIZED,
        INCREMENT_Y,
        MIRROR_Y;

    }
}

