/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.BuildComponentTree;
import net.imglib2.algorithm.componenttree.ComponentTree;
import net.imglib2.algorithm.componenttree.PartialComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListPartialComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListPartialComponentGenerator;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.util.Util;

public final class PixelListComponentTree<T extends Type<T>>
implements ComponentTree<PixelListComponent<T>>,
Iterable<PixelListComponent<T>>,
PartialComponent.Handler<PixelListPartialComponent<T>> {
    private PixelListComponent<T> root = null;
    private final ArrayList<PixelListComponent<T>> nodes = new ArrayList();

    public static <T extends RealType<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T type, boolean darkToBright) {
        ImgFactory factory = Util.getArrayOrCellImgFactory(input, (NativeType)new LongType());
        return PixelListComponentTree.buildComponentTree(input, type, (ImgFactory<LongType>)factory, darkToBright);
    }

    public static <T extends RealType<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T type, ImgFactory<LongType> imgFactory, boolean darkToBright) {
        RealType max = (RealType)type.createVariable();
        max.setReal(darkToBright ? type.getMaxValue() : type.getMinValue());
        PixelListPartialComponentGenerator<RealType> generator = new PixelListPartialComponentGenerator<RealType>(max, input, imgFactory);
        PixelListComponentTree<T> tree = new PixelListComponentTree<T>();
        BuildComponentTree.buildComponentTree(input, generator, tree, darkToBright);
        return tree;
    }

    public static <T extends Type<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T maxValue, Comparator<T> comparator) {
        ImgFactory factory = Util.getArrayOrCellImgFactory(input, (NativeType)new LongType());
        return PixelListComponentTree.buildComponentTree(input, maxValue, comparator, (ImgFactory<LongType>)factory);
    }

    public static <T extends Type<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T maxValue, Comparator<T> comparator, ImgFactory<LongType> imgFactory) {
        PixelListPartialComponentGenerator<T> generator = new PixelListPartialComponentGenerator<T>(maxValue, input, imgFactory);
        PixelListComponentTree<T> tree = new PixelListComponentTree<T>();
        BuildComponentTree.buildComponentTree(input, generator, tree, comparator);
        return tree;
    }

    private PixelListComponentTree() {
    }

    @Override
    public void emit(PixelListPartialComponent<T> partialComponent) {
        PixelListComponent<T> component = new PixelListComponent<T>(partialComponent);
        this.root = component;
        this.nodes.add(component);
    }

    @Override
    public Iterator<PixelListComponent<T>> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public PixelListComponent<T> root() {
        return this.root;
    }

    @Override
    public Set<PixelListComponent<T>> roots() {
        return Collections.singleton(this.root);
    }
}

