/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.dog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.dog.DifferenceOfGaussian;
import net.imglib2.algorithm.localextrema.LocalExtrema;
import net.imglib2.algorithm.localextrema.RefinedPeak;
import net.imglib2.algorithm.localextrema.SubpixelLocalization;
import net.imglib2.meta.LinearSpace;
import net.imglib2.meta.axis.LinearAxis;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class DogDetection<T extends RealType<T> & NativeType<T>> {
    private ExecutorService executorService;
    protected final RandomAccessible<T> input;
    protected final Interval interval;
    protected final double sigma1;
    protected final double sigma2;
    protected final double[] pixelSize;
    protected RandomAccessibleInterval<T> dogImg;
    protected double imageSigma;
    protected double minf;
    protected ExtremaType extremaType;
    protected double minPeakValue;
    protected boolean normalizeMinPeakValue;
    protected boolean keepDoGImg;
    protected int numThreads;

    public <I extends RandomAccessibleInterval<T> & LinearSpace<?>> DogDetection(I input, double sigma1, double sigma2, ExtremaType extremaType, double minPeakValue) {
        this((RandomAccessible<T>)Views.extendMirrorSingle(input), (Interval)input, DogDetection.getcalib(input), sigma1, sigma2, extremaType, minPeakValue, true);
    }

    public DogDetection(RandomAccessible<T> input, Interval interval, double[] calibration, double sigma1, double sigma2, ExtremaType extremaType, double minPeakValue, boolean normalizeMinPeakValue) {
        this.input = input;
        this.interval = interval;
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.pixelSize = calibration;
        this.imageSigma = 0.5;
        this.minf = 2.0;
        this.extremaType = extremaType;
        this.minPeakValue = minPeakValue;
        this.normalizeMinPeakValue = normalizeMinPeakValue;
        this.keepDoGImg = true;
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public ArrayList<Point> getPeaks() {
        LocalExtrema.LocalNeighborhoodCheck localNeighborhoodCheck;
        ExecutorService service = this.executorService == null ? Executors.newFixedThreadPool(this.numThreads) : this.executorService;
        RealType type = (RealType)Util.getTypeFromInterval((Interval)Views.interval(this.input, (Interval)this.interval));
        this.dogImg = Util.getArrayOrCellImgFactory((Dimensions)this.interval, (NativeType)((NativeType)type)).create((Dimensions)this.interval, (Object)type);
        long[] translation = new long[this.interval.numDimensions()];
        this.interval.min(translation);
        this.dogImg = Views.translate(this.dogImg, (long[])translation);
        double[][] sigmas = DifferenceOfGaussian.computeSigmas(this.imageSigma, this.minf, this.pixelSize, this.sigma1, this.sigma2);
        DifferenceOfGaussian.DoG(sigmas[0], sigmas[1], this.input, this.dogImg, service);
        RealType val = (RealType)type.createVariable();
        double minValueT = type.getMinValue();
        double maxValueT = type.getMaxValue();
        double normalization = this.normalizeMinPeakValue ? this.sigma2 / this.sigma1 - 1.0 : 1.0;
        switch (this.extremaType) {
            case MINIMA: {
                val.setReal(Math.max(Math.min(-this.minPeakValue * normalization, maxValueT), minValueT));
                localNeighborhoodCheck = new LocalExtrema.MinimumCheck<RealType>(val);
                break;
            }
            default: {
                val.setReal(Math.max(Math.min(this.minPeakValue * normalization, maxValueT), minValueT));
                localNeighborhoodCheck = new LocalExtrema.MaximumCheck<RealType>(val);
            }
        }
        ArrayList<Point> peaks = LocalExtrema.findLocalExtrema(this.dogImg, localNeighborhoodCheck, service);
        if (!this.keepDoGImg) {
            this.dogImg = null;
        }
        if (this.executorService == null) {
            service.shutdown();
        }
        return peaks;
    }

    public ArrayList<RefinedPeak<Point>> getSubpixelPeaks() {
        boolean savedKeepDoGImg = this.keepDoGImg;
        this.keepDoGImg = true;
        ArrayList<Point> peaks = this.getPeaks();
        SubpixelLocalization<Point, T> spl = new SubpixelLocalization<Point, T>(this.dogImg.numDimensions());
        spl.setAllowMaximaTolerance(true);
        spl.setMaxNumMoves(10);
        ArrayList<RefinedPeak<Point>> refined = spl.process((List<Point>)peaks, (RandomAccessible<T>)this.dogImg, (Interval)this.dogImg);
        this.keepDoGImg = savedKeepDoGImg;
        if (!this.keepDoGImg) {
            this.dogImg = null;
        }
        return refined;
    }

    public void setImageSigma(double imageSigma) {
        this.imageSigma = imageSigma;
    }

    public void setMinf(double minf) {
        this.minf = minf;
    }

    public void setMinPeakValue(double minPeakValue) {
        this.minPeakValue = minPeakValue;
    }

    public void setNormalizeMinPeakValue(boolean normalizeMinPeakValue) {
        this.normalizeMinPeakValue = normalizeMinPeakValue;
    }

    public void setKeepDoGImg(boolean keepDoGImg) {
        this.keepDoGImg = keepDoGImg;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public double getImageSigma() {
        return this.imageSigma;
    }

    public double getMinf() {
        return this.minf;
    }

    public double getMinPeakValue() {
        return this.minPeakValue;
    }

    public boolean getNormalizeMinPeakValue() {
        return this.normalizeMinPeakValue;
    }

    public boolean getKeepDoGImg() {
        return this.keepDoGImg;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    private static double[] getcalib(LinearSpace<?> calib) {
        double[] c = new double[calib.numDimensions()];
        for (int d = 0; d < c.length; ++d) {
            c[d] = ((LinearAxis)calib.axis(d)).scale();
        }
        return c;
    }

    public static enum ExtremaType {
        MINIMA,
        MAXIMA;

    }
}

