/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.edge;

import java.util.ArrayList;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.edge.Edgel;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class SubpixelEdgelDetection {
    public static <T extends RealType<T>> ArrayList<Edgel> getEdgels(RandomAccessibleInterval<T> input, ImgFactory<T> factory, float minGradientMagnitude) {
        ArrayList<Edgel> edgels = new ArrayList<Edgel>();
        int n = input.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (input.dimension(d) >= 5L) continue;
            return edgels;
        }
        long[] dim = new long[n + 1];
        for (int d = 0; d < n; ++d) {
            dim[d] = input.dimension(d);
        }
        dim[n] = n;
        Img gradients = factory.create(dim, input.randomAccess().get());
        FinalInterval gradientComputationInterval = Intervals.expand(input, (long)-1L);
        for (int d = 0; d < n; ++d) {
            PartialDerivative.gradientCentralDifference(input, Views.interval((RandomAccessible)Views.hyperSlice((RandomAccessibleInterval)gradients, (int)n, (long)d), (Interval)gradientComputationInterval), d);
        }
        FinalInterval maximaComputationInterval = Intervals.expand(input, (long)-2L);
        long[] min = new long[n];
        maximaComputationInterval.min(min);
        long[] max = new long[n];
        maximaComputationInterval.max(max);
        long[] shiftback = new long[n];
        for (int d = 0; d < n; ++d) {
            shiftback[d] = min[d] - max[d];
        }
        NLinearInterpolatorFactory interpolatorFactory = new NLinearInterpolatorFactory();
        RealRandomAccess[] gradientAccess = new RealRandomAccess[n];
        for (int d = 0; d < n; ++d) {
            gradientAccess[d] = interpolatorFactory.create((RandomAccessible)Views.hyperSlice((RandomAccessibleInterval)gradients, (int)n, (long)d));
        }
        RandomAccess src = gradients.randomAccess();
        for (int d = 0; d < n; ++d) {
            src.setPosition(min[d], d);
        }
        src.setPosition(0, n);
        float[] g = new float[n];
        float[] doublePos = new float[n];
        float minMagnitudeSquared = minGradientMagnitude * minGradientMagnitude;
        long max0 = max[0];
        block6: while (true) {
            int d;
            float len = 0.0f;
            for (d = 0; d < n; ++d) {
                float gg = ((RealType)src.get()).getRealFloat();
                len += gg * gg;
                g[d] = gg;
                src.fwd(n);
            }
            src.setPosition(0, n);
            if (len >= minMagnitudeSquared) {
                len = (float)Math.sqrt(len);
                for (d = 0; d < n; ++d) {
                    int n2 = d;
                    g[n2] = g[n2] / len;
                    doublePos[d] = src.getFloatPosition(d) + g[d];
                }
                float lighterMag = SubpixelEdgelDetection.gradientMagnitudeInDirection(doublePos, g, gradientAccess);
                if (len >= lighterMag) {
                    for (int d2 = 0; d2 < n; ++d2) {
                        doublePos[d2] = src.getFloatPosition(d2) - g[d2];
                    }
                    float darkerMag = SubpixelEdgelDetection.gradientMagnitudeInDirection(doublePos, g, gradientAccess);
                    if (len >= darkerMag) {
                        float m = (darkerMag - lighterMag) / (2.0f * (darkerMag - 2.0f * len + lighterMag));
                        for (int d3 = 0; d3 < n; ++d3) {
                            doublePos[d3] = src.getFloatPosition(d3) + m * g[d3];
                        }
                        edgels.add(new Edgel(doublePos, g, len));
                    }
                }
            }
            if (src.getLongPosition(0) == max0) {
                src.move(shiftback[0], 0);
                if (n == 1) {
                    return edgels;
                }
                d = 1;
                while (true) {
                    if (d >= n) continue block6;
                    if (src.getLongPosition(d) == max[d]) {
                        src.move(shiftback[d], d);
                        if (d == n - 1) {
                            return edgels;
                        }
                    } else {
                        src.fwd(d);
                        continue block6;
                    }
                    ++d;
                }
            }
            src.fwd(0);
        }
    }

    private static <T extends RealType<T>> float gradientMagnitudeInDirection(float[] position, float[] direction, RealRandomAccess<T>[] gradientAccess) {
        float len = 0.0f;
        for (int d = 0; d < gradientAccess.length; ++d) {
            gradientAccess[d].setPosition(position);
            len += ((RealType)gradientAccess[d].get()).getRealFloat() * direction[d];
        }
        return len;
    }
}

