/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss;

import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss.SamplingLineIterator;
import net.imglib2.algorithm.gauss.WritableLineIterator;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public abstract class AbstractGauss<T extends NumericType<T>> {
    final Interval inputInterval;
    final Localizable outputOffset;
    RandomAccessible<T> input;
    RandomAccessible<T> output;
    final ImgFactory<T> factory;
    final Img<T> tmp1;
    final Img<T> tmp2;
    final T type;
    final int numDimensions;
    final double[] sigma;
    final double[][] kernel;
    int numThreads = Runtime.getRuntime().availableProcessors();

    public AbstractGauss(double[] sigma, RandomAccessible<T> input, Interval inputInterval, RandomAccessible<T> output, Localizable outputOffset, ImgFactory<T> factory, T type) {
        this.numDimensions = sigma.length;
        this.input = input;
        this.output = output;
        this.factory = factory;
        this.type = type;
        this.sigma = sigma;
        this.kernel = new double[this.numDimensions][];
        this.inputInterval = inputInterval;
        this.outputOffset = outputOffset;
        this.computeKernel();
        Interval intervalTmp = this.getTemporaryImgSize();
        this.tmp1 = this.numDimensions > 1 ? factory.create((Dimensions)intervalTmp, this.getProcessingType()) : null;
        this.tmp2 = this.numDimensions > 2 ? factory.create((Dimensions)intervalTmp, this.getProcessingType()) : null;
    }

    public double[] getSigma() {
        return this.sigma;
    }

    public double[][] getKernel() {
        return this.kernel;
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public RandomAccessible<T> getInput() {
        return this.input;
    }

    public RandomAccessible<T> getOutput() {
        return this.output;
    }

    public ImgFactory<T> getFactory() {
        return this.factory;
    }

    public Interval getInputInterval() {
        return this.inputInterval;
    }

    public Localizable getOutputOffset() {
        return this.outputOffset;
    }

    public T type() {
        return this.type;
    }

    public Img<T> getTmp1() {
        return this.tmp1;
    }

    public Img<T> getTmp2() {
        return this.tmp2;
    }

    protected T getProcessingType() {
        return (T)((NumericType)this.type.createVariable());
    }

    protected abstract Img<T> getProcessingLine(long var1);

    public RandomAccessible<T> getResult() {
        return this.output;
    }

    protected Interval getRange(int dim) {
        if (this.numDimensions == 1) {
            return this.inputInterval;
        }
        long[] min = new long[this.numDimensions];
        long[] max = new long[this.numDimensions];
        if (dim == 0) {
            min[0] = this.inputInterval.min(0);
            max[0] = this.inputInterval.max(0);
            for (int d = 1; d < this.numDimensions; ++d) {
                min[d] = this.inputInterval.min(d) - (long)(this.kernel[d].length / 2);
                max[d] = this.inputInterval.max(d) + (long)(this.kernel[d].length / 2);
            }
        } else {
            for (int d = 0; d < this.numDimensions; ++d) {
                if (d < dim) {
                    min[d] = 0L;
                    max[d] = this.inputInterval.dimension(d) - 1L;
                    continue;
                }
                if (d == dim) {
                    min[d] = this.kernel[d].length / 2;
                    max[d] = this.inputInterval.dimension(d) - 1L + (long)(this.kernel[d].length / 2);
                    continue;
                }
                min[d] = 0L;
                max[d] = this.inputInterval.dimension(d) - 1L + (long)this.kernel[d].length - 1L;
            }
        }
        return new FinalInterval(min, max);
    }

    protected SamplingLineIterator<T> createInputLineSampler(int dim, Interval range) {
        RandomAccess randomAccess = dim == 0 ? this.input.randomAccess((Interval)Intervals.expand((Interval)range, (long)(this.kernel[dim].length / 2), (int)dim)) : (dim % 2 == 1 ? this.tmp1.randomAccess() : this.tmp2.randomAccess());
        long sizeProcessLine = range.dimension(dim);
        long sizeInputData = sizeProcessLine + (long)this.kernel[dim].length - 1L;
        if (dim == 0) {
            range.min((Positionable)randomAccess);
            randomAccess.move(-(this.kernel[0].length / 2), 0);
        } else {
            range.min((Positionable)randomAccess);
            randomAccess.move(-(this.kernel[dim].length / 2), dim);
        }
        return new SamplingLineIterator<T>(dim, sizeInputData, randomAccess, this.getProcessingLine(sizeProcessLine), this.getProcessingType(), this.getProcessingType());
    }

    protected WritableLineIterator<T> createOutputLineWriter(int dim, Interval range, SamplingLineIterator<T> inputLineSampler) {
        RandomAccess randomAccess = dim == this.numDimensions - 1 ? this.output.randomAccess() : (dim % 2 == 0 ? this.tmp1.randomAccess() : this.tmp2.randomAccess());
        long sizeProcessLine = inputLineSampler.getProcessLine().size();
        if (dim == this.numDimensions - 1) {
            randomAccess.setPosition(this.outputOffset);
        } else if (dim % 2 == 0) {
            this.tmp1.min((Positionable)randomAccess);
        } else {
            this.tmp2.min((Positionable)randomAccess);
        }
        return new WritableLineIterator(dim, sizeProcessLine, randomAccess);
    }

    protected void processLine(SamplingLineIterator<T> input, double[] kernel) {
        int kernelSize = kernel.length;
        int kernelSizeMinus1 = kernelSize - 1;
        int kernelSizeHalf = kernelSize / 2;
        int kernelSizeHalfMinus1 = kernelSizeHalf - 1;
        RandomAccess randomAccessLeft = input.randomAccessLeft;
        RandomAccess randomAccessRight = input.randomAccessRight;
        NumericType copy = (NumericType)input.copy;
        NumericType tmp = (NumericType)input.tmp;
        long imgSize = input.getProcessLine().size();
        if (imgSize >= (long)kernelSize) {
            copy.set((Type)input.get());
            randomAccessLeft.setPosition(0, 0);
            copy.mul(kernel[0]);
            ((NumericType)randomAccessLeft.get()).add(copy);
            for (int i = 1; i < kernelSizeMinus1; ++i) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPosition(-1, 0);
                for (int o = 0; o <= i; ++o) {
                    randomAccessLeft.fwd(0);
                    tmp.set((Type)copy);
                    tmp.mul(kernel[i - o]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
            }
            long length = imgSize - (long)kernelSizeMinus1;
            for (long n = 0L; n < length; ++n) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPosition(n, 0);
                randomAccessRight.setPosition(n + (long)kernelSizeMinus1, 0);
                for (int k = 0; k < kernelSizeHalfMinus1; ++k) {
                    tmp.set((Type)copy);
                    tmp.mul(kernel[k]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                    ((NumericType)randomAccessRight.get()).add(tmp);
                    randomAccessLeft.fwd(0);
                    randomAccessRight.bck(0);
                }
                tmp.set((Type)copy);
                tmp.mul(kernel[kernelSizeHalfMinus1]);
                ((NumericType)randomAccessLeft.get()).add(tmp);
                ((NumericType)randomAccessRight.get()).add(tmp);
                randomAccessLeft.fwd(0);
                tmp.set((Type)copy);
                tmp.mul(kernel[kernelSizeHalf]);
                ((NumericType)randomAccessLeft.get()).add(tmp);
            }
            long endLength = imgSize + (long)kernelSizeMinus1;
            for (long i = imgSize; i < endLength; ++i) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPosition(i - (long)kernelSize, 0);
                int k = 0;
                for (long o = i - (long)kernelSize + 1L; o < imgSize; ++o) {
                    randomAccessLeft.fwd(0);
                    tmp.set((Type)copy);
                    tmp.mul(kernel[k++]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
            }
        } else {
            copy.set((Type)input.get());
            randomAccessLeft.setPosition(0, 0);
            copy.mul(kernel[0]);
            ((NumericType)randomAccessLeft.get()).add(copy);
            int i = 1;
            while ((long)i < imgSize) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPosition(-1, 0);
                for (int o = 0; o <= i; ++o) {
                    randomAccessLeft.fwd(0);
                    tmp.set((Type)copy);
                    tmp.mul(kernel[i - o]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
                ++i;
            }
            for (long i2 = imgSize; i2 < imgSize + (long)kernelSizeMinus1; ++i2) {
                input.fwd();
                copy.set((Type)input.get());
                long o = i2 - (long)kernelSize + 1L;
                int k = 0;
                if (o < 0L) {
                    k = -((int)o);
                    o = 0L;
                }
                randomAccessLeft.setPosition(o - 1L, 0);
                while (o < imgSize) {
                    randomAccessLeft.fwd(0);
                    tmp.set((Type)copy);
                    tmp.mul(kernel[k++]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                    ++o;
                }
            }
        }
    }

    protected void writeLine(WritableLineIterator<T> a, SamplingLineIterator<T> inputLineSampler) {
        Cursor resultCursor = inputLineSampler.resultCursor;
        resultCursor.reset();
        if (resultCursor.hasNext()) {
            resultCursor.fwd();
            a.set((Type)resultCursor.get());
        }
        while (resultCursor.hasNext()) {
            resultCursor.fwd();
            a.fwd();
            a.set((Type)resultCursor.get());
        }
    }

    protected void updateInputLineSampler(SamplingLineIterator<T> a, Interval range, long[] offset, Localizable originalLocation) {
        Positionable positionable = a.getPositionable();
        for (int d = 0; d < this.numDimensions; ++d) {
            positionable.setPosition(originalLocation.getLongPosition(d) + offset[d], d);
        }
        for (NumericType v : a.getProcessLine()) {
            v.setZero();
        }
    }

    protected void updateOutputLineWriter(WritableLineIterator<T> a, Interval range, long[] offset, Localizable originalLocation) {
        Positionable positionable = a.getPositionable();
        for (int d = 0; d < this.numDimensions; ++d) {
            positionable.setPosition(originalLocation.getLongPosition(d) + offset[d], d);
        }
    }

    protected void computeKernel() {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.kernel[d] = Util.createGaussianKernel1DDouble((double)this.sigma[d], (boolean)true);
        }
    }

    protected Interval getTemporaryImgSize() {
        return this.getRange(0);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = Math.max(1, numThreads);
    }

    public void call() {
        if (this.numDimensions > 1) {
            for (int d = 0; d < this.numDimensions; ++d) {
                final int dim = d;
                final int numThreads = this.getNumThreads();
                final AtomicInteger ai = new AtomicInteger();
                Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
                for (int ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            int myNumber = ai.getAndIncrement();
                            Interval range = AbstractGauss.this.getRange(dim);
                            long[] fakeSize = new long[AbstractGauss.this.numDimensions - 1];
                            long[] tmp = new long[AbstractGauss.this.numDimensions];
                            int countDim = 0;
                            for (int d = 0; d < AbstractGauss.this.numDimensions; ++d) {
                                if (d == dim) continue;
                                fakeSize[countDim++] = range.dimension(d);
                            }
                            SamplingLineIterator inputLineIterator = AbstractGauss.this.createInputLineSampler(dim, range);
                            Localizable offsetInput = inputLineIterator.getOffset();
                            WritableLineIterator outputLineIterator = AbstractGauss.this.createOutputLineWriter(dim, range, inputLineIterator);
                            Localizable offsetOutput = outputLineIterator.getOffset();
                            LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
                            while (cursorDim.hasNext()) {
                                cursorDim.fwd();
                                if (numThreads != 1 && cursorDim.getIntPosition(0) % numThreads != myNumber) continue;
                                cursorDim.localize(fakeSize);
                                tmp[dim] = 0L;
                                countDim = 0;
                                for (int d = 0; d < AbstractGauss.this.numDimensions; ++d) {
                                    if (d == dim) continue;
                                    tmp[d] = fakeSize[countDim++];
                                }
                                AbstractGauss.this.updateInputLineSampler(inputLineIterator, range, tmp, offsetInput);
                                AbstractGauss.this.processLine(inputLineIterator, AbstractGauss.this.kernel[dim]);
                                AbstractGauss.this.updateOutputLineWriter(outputLineIterator, range, tmp, offsetOutput);
                                AbstractGauss.this.writeLine(outputLineIterator, inputLineIterator);
                            }
                        }
                    });
                }
                SimpleMultiThreading.startAndJoin((Thread[])threads);
            }
        } else {
            Interval range = this.getRange(0);
            SamplingLineIterator<T> inputLineIterator = this.createInputLineSampler(0, range);
            WritableLineIterator<T> outputLineIterator = this.createOutputLineWriter(0, range, inputLineIterator);
            this.processLine(inputLineIterator, this.kernel[0]);
            this.writeLine(outputLineIterator, inputLineIterator);
        }
    }
}

