/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.gauss3.ConvolverFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public final class ConvolverNativeType<T extends NumericType<T> & NativeType<T>>
implements Runnable {
    private final double[] kernel;
    private final RandomAccess<T> in;
    private final RandomAccess<T> out;
    private final int d;
    private final int k;
    private final int k1;
    private final int k1k1;
    private final long linelen;
    final T b1;
    final T b2;
    final T tmp;

    public static <T extends NumericType<T> & NativeType<T>> ConvolverFactoryNativeType<T> factory(T type) {
        return new ConvolverFactoryNativeType<T>(type);
    }

    private ConvolverNativeType(double[] kernel, RandomAccess<T> in, RandomAccess<T> out, int d, long lineLength, T type) {
        this.kernel = kernel;
        this.in = in;
        this.out = out;
        this.d = d;
        this.k = kernel.length;
        this.k1 = this.k - 1;
        this.k1k1 = this.k1 + this.k1;
        this.linelen = lineLength;
        int buflen = 2 * this.k - 1;
        ArrayImg buf = new ArrayImgFactory().create(new long[]{buflen}, (NativeType)type);
        this.b1 = (NumericType)buf.randomAccess().get();
        this.b2 = (NumericType)buf.randomAccess().get();
        this.tmp = (NumericType)type.createVariable();
    }

    private void next() {
        for (int i = 0; i < this.k1k1; ++i) {
            ((NativeType)this.b2).updateIndex(i + 1);
            ((NativeType)this.b1).updateIndex(i);
            this.b1.set(this.b2);
        }
        NumericType w = (NumericType)this.in.get();
        this.tmp.set((Type)w);
        this.tmp.mul(this.kernel[0]);
        ((NativeType)this.b1).updateIndex(this.k1);
        this.b1.add(this.tmp);
        for (int j = 1; j < this.k1; ++j) {
            this.tmp.set((Type)w);
            this.tmp.mul(this.kernel[j]);
            ((NativeType)this.b1).updateIndex(this.k1 + j);
            this.b1.add(this.tmp);
            ((NativeType)this.b1).updateIndex(this.k1 - j);
            this.b1.add(this.tmp);
        }
        this.tmp.set((Type)w);
        this.tmp.mul(this.kernel[this.k1]);
        ((NativeType)this.b1).updateIndex(this.k1k1);
        this.b1.set(this.tmp);
        this.in.fwd(this.d);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.next();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
            ((NativeType)this.b1).updateIndex(0);
            this.b1.add(this.tmp);
            ((NumericType)this.out.get()).set(this.b1);
            this.out.fwd(this.d);
        }
    }

    /* synthetic */ ConvolverNativeType(double[] x0, RandomAccess x1, RandomAccess x2, int x3, long x4, NumericType x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    static class 1 {
    }

    public static final class ConvolverFactoryNativeType<T extends NumericType<T> & NativeType<T>>
    implements ConvolverFactory<T, T> {
        private final T type;

        public ConvolverFactoryNativeType(T type) {
            this.type = type;
        }

        @Override
        public Runnable create(double[] halfkernel, RandomAccess<T> in, RandomAccess<T> out, int d, long lineLength) {
            return new ConvolverNativeType(halfkernel, (RandomAccess)in, (RandomAccess)out, d, lineLength, (NumericType)this.type, null);
        }
    }
}

