/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.integral;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.integral.IntegralImg;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.LongType;

public class IntegralImgLong<R extends NumericType<R>>
extends IntegralImg<R, LongType> {
    public IntegralImgLong(RandomAccessibleInterval<R> img, LongType type, Converter<R, LongType> converter) {
        super(img, type, converter);
    }

    @Override
    protected void integrateLineDim0(Converter<R, LongType> converter, RandomAccess<R> cursorIn, RandomAccess<LongType> cursorOut, LongType sum, LongType tmpVar, long size) {
        converter.convert(cursorIn.get(), (Object)sum);
        ((LongType)cursorOut.get()).set(sum);
        long sum2 = sum.get();
        int i = 2;
        while ((long)i < size) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.get(), (Object)tmpVar);
            ((LongType)cursorOut.get()).set(sum2 += tmpVar.get());
            ++i;
        }
    }

    @Override
    protected void integrateLine(int d, RandomAccess<LongType> cursor, LongType sum, long size) {
        long sum2 = ((LongType)cursor.get()).get();
        int i = 2;
        while ((long)i < size) {
            cursor.fwd(d);
            ((LongType)cursor.get()).set(sum2 += ((LongType)cursor.get()).get());
            ++i;
        }
    }
}

