/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localextrema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;
import net.imglib2.algorithm.region.localneighborhood.RectangleShape;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class LocalExtrema {
    public static <P, T extends Comparable<T>> ArrayList<P> findLocalExtrema(RandomAccessibleInterval<T> img, LocalNeighborhoodCheck<P, T> localNeighborhoodCheck, ExecutorService service) {
        ArrayList allExtrema = new ArrayList();
        FinalInterval full = Intervals.expand(img, (long)-1L);
        int n = img.numDimensions();
        int splitd = n - 1;
        int numThreads = Runtime.getRuntime().availableProcessors();
        int numTasks = numThreads <= 1 ? 1 : (int)Math.min(full.dimension(splitd), (long)(numThreads * 20));
        long dsize = full.dimension(splitd) / (long)numTasks;
        long[] min = new long[n];
        long[] max = new long[n];
        full.min(min);
        full.max(max);
        RectangleShape shape = new RectangleShape(1, true);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        List synchronizedAllExtrema = Collections.synchronizedList(allExtrema);
        for (int taskNum = 0; taskNum < numTasks; ++taskNum) {
            min[splitd] = full.min(splitd) + (long)taskNum * dsize;
            max[splitd] = taskNum == numTasks - 1 ? full.max(splitd) : min[splitd] + dsize - 1L;
            IntervalView intervalView = Views.interval(img, (Interval)new FinalInterval(min, max));
            ArrayList extrema = new ArrayList(128);
            Callable<Void> r = new Callable<Void>((RandomAccessibleInterval)intervalView, shape, localNeighborhoodCheck, extrema, synchronizedAllExtrema){
                final /* synthetic */ RandomAccessibleInterval val$source;
                final /* synthetic */ RectangleShape val$shape;
                final /* synthetic */ LocalNeighborhoodCheck val$localNeighborhoodCheck;
                final /* synthetic */ ArrayList val$extrema;
                final /* synthetic */ List val$synchronizedAllExtrema;
                {
                    this.val$source = randomAccessibleInterval;
                    this.val$shape = rectangleShape;
                    this.val$localNeighborhoodCheck = localNeighborhoodCheck;
                    this.val$extrema = arrayList;
                    this.val$synchronizedAllExtrema = list;
                }

                @Override
                public Void call() {
                    Cursor center = Views.flatIterable((RandomAccessibleInterval)this.val$source).cursor();
                    for (Neighborhood neighborhood : this.val$shape.neighborhoods(this.val$source)) {
                        center.fwd();
                        Object p = this.val$localNeighborhoodCheck.check(center, neighborhood);
                        if (p == null) continue;
                        this.val$extrema.add(p);
                    }
                    this.val$synchronizedAllExtrema.addAll(this.val$extrema);
                    return null;
                }
            };
            futures.add(service.submit(r));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return allExtrema;
    }

    public static class MinimumCheck<T extends Comparable<T>>
    implements LocalNeighborhoodCheck<Point, T> {
        final T maxPeakValue;

        public MinimumCheck(T maxPeakValue) {
            this.maxPeakValue = maxPeakValue;
        }

        @Override
        public <C extends Localizable & Sampler<T>> Point check(C center, Neighborhood<T> neighborhood) {
            Comparable c = (Comparable)((Sampler<T>)center).get();
            if (this.maxPeakValue.compareTo((Comparable)c) < 0) {
                return null;
            }
            Iterator i$ = neighborhood.iterator();
            while (i$.hasNext()) {
                Comparable t = (Comparable)i$.next();
                if (t.compareTo(c) >= 0) continue;
                return null;
            }
            return new Point(center);
        }
    }

    public static class MaximumCheck<T extends Comparable<T>>
    implements LocalNeighborhoodCheck<Point, T> {
        final T minPeakValue;

        public MaximumCheck(T minPeakValue) {
            this.minPeakValue = minPeakValue;
        }

        @Override
        public <C extends Localizable & Sampler<T>> Point check(C center, Neighborhood<T> neighborhood) {
            Comparable c = (Comparable)((Sampler<T>)center).get();
            if (this.minPeakValue.compareTo((Comparable)c) > 0) {
                return null;
            }
            Iterator i$ = neighborhood.iterator();
            while (i$.hasNext()) {
                Comparable t = (Comparable)i$.next();
                if (t.compareTo(c) <= 0) continue;
                return null;
            }
            return new Point(center);
        }
    }

    public static interface LocalNeighborhoodCheck<P, T extends Comparable<T>> {
        public <C extends Localizable & Sampler<T>> P check(C var1, Neighborhood<T> var2);
    }
}

